/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.metadata.MetadataValue;
import org.greenstone.gatherer.metadata.MetadataValueTreeNode;
import org.greenstone.gatherer.util.Utility;

public abstract class DocXMLFile
extends File {
    static boolean isWin = Utility.isWindows();
    protected HashMap source_file_name_to_description_elements_mapping = new HashMap();
    protected final String MetadataWrap;
    protected final String MetadataItem;
    protected final String FILE_RENAME_METHOD_NONE = "none";
    protected final String FILE_RENAME_METHOD_URL = "url";
    protected final String FILE_RENAME_METHOD_BASE64 = "base64";

    public DocXMLFile(String string, String string2, String string3) {
        super(string);
        this.MetadataWrap = string2;
        this.MetadataItem = string3;
    }

    public ArrayList getMetadataExtractedFromFile(File file, String string) {
        ArrayList<MetadataValue> arrayList = new ArrayList<MetadataValue>();
        ArrayList arrayList2 = (ArrayList)this.source_file_name_to_description_elements_mapping.get(string);
        if (arrayList2 == null) {
            return arrayList;
        }
        MetadataSet metadataSet = MetadataSetManager.getMetadataSet("ex");
        DebugStream.println("Applicable file: " + this);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this), "UTF-8"));
            int n = 0;
            int n2 = (Integer)arrayList2.get(n);
            boolean bl = false;
            String string2 = null;
            int n3 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (n3 == n2) {
                    bl = true;
                } else if (bl) {
                    int n4;
                    String string3;
                    String string4;
                    if (string2.indexOf("</" + this.MetadataWrap + ">") != -1) {
                        if (++n == arrayList2.size()) break;
                        n2 = (Integer)arrayList2.get(n);
                        bl = false;
                    } else if (string2.indexOf("<" + this.MetadataItem + " ") != -1 && string2.indexOf("</" + this.MetadataItem + ">") != -1 && ((string4 = MetadataTools.getMetadataSetNamespace(string3 = string2.substring(n4 = string2.indexOf(" name=\"") + " name=\"".length(), string2.indexOf("\"", n4)))).equals("") || string4.equals("ex"))) {
                        String string5 = MetadataTools.getMetadataElementName(string3);
                        if (string5.equals("SourceSegment")) {
                            bufferedReader.close();
                            return new ArrayList();
                        }
                        if (!string5.startsWith("gsdl")) {
                            MetadataElement metadataElement = metadataSet.getMetadataElementWithName(string5);
                            int n5 = string2.indexOf(">", n4) + ">".length();
                            String string6 = string2.substring(n5, string2.lastIndexOf("</" + this.MetadataItem + ">"));
                            metadataElement.addMetadataValue(string6);
                            MetadataValueTreeNode metadataValueTreeNode = metadataElement.getMetadataValueTreeNode(string6);
                            MetadataValue metadataValue = new MetadataValue(metadataElement, metadataValueTreeNode);
                            arrayList.add(metadataValue);
                        }
                    }
                }
                ++n3;
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            DebugStream.printStackTrace(fileNotFoundException);
        }
        catch (IOException iOException) {
            DebugStream.printStackTrace(iOException);
        }
        return arrayList;
    }

    public void skimFile() {
        String string = null;
        String string2 = null;
        boolean bl = false;
        int n = -1;
        MetadataSet metadataSet = MetadataSetManager.getMetadataSet("ex");
        DebugStream.println("Skimming " + this + "...");
        try {
            Object object;
            Object object2;
            Object object3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this), "UTF-8"));
            int n2 = -1;
            String string3 = null;
            int n3 = 0;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.indexOf("<" + this.MetadataWrap + ">") != -1) {
                    if (n2 != -1) {
                        System.err.println("Parse error: previous " + this.MetadataWrap + " element unfinished!");
                    }
                    n2 = n3;
                } else if (string3.indexOf("</" + this.MetadataWrap + ">") != -1) {
                    if (n2 == -1) {
                        System.err.println("Parse error: " + this.MetadataWrap + " element unstarted!");
                    }
                    n2 = -1;
                } else if (n2 != -1) {
                    if (string3.indexOf("<" + this.MetadataItem + " ") == -1) {
                        DebugStream.println("Warning: " + this.MetadataWrap + " element line doesn't contain Metadata element.");
                    } else {
                        int n4 = string3.indexOf(" name=\"") + " name=\"".length();
                        object3 = string3.substring(n4, string3.indexOf("\"", n4));
                        object2 = MetadataTools.getMetadataSetNamespace((String)object3);
                        if (((String)object2).equals("") || ((String)object2).equals("ex")) {
                            MetadataElement metadataElement;
                            object = MetadataTools.getMetadataElementName((String)object3);
                            if (((String)object).equals("gsdlsourcefilerenamemethod")) {
                                int n5 = string3.indexOf(">", n4) + ">".length();
                                string = string3.substring(n5, string3.indexOf("<", n5));
                            } else if (((String)object).equals("gsdlsourcefilename")) {
                                int n6 = string3.indexOf(">", n4) + ">".length();
                                string2 = string3.substring(n6, string3.indexOf("<", n6));
                                int n7 = string2.indexOf("import");
                                if (n7 != -1) {
                                    n = n2;
                                } else if (string2.indexOf("tmp") == -1 && !string2.endsWith("collect.cfg") && !string2.endsWith("collectionConfig.xml")) {
                                    System.err.println("Warning: Could not understand gsdlsourcefilename " + string2);
                                }
                            }
                            if (!((String)object).startsWith("gsdl") && (metadataElement = metadataSet.getMetadataElementWithName((String)object)) == null) {
                                DebugStream.println("Extracted metadata element not defined: " + (String)object);
                                metadataSet.addMetadataElementForThisSession((String)object);
                            }
                        }
                    }
                }
                ++n3;
            }
            bufferedReader.close();
            n3 = string2.indexOf("import");
            if (n3 != -1) {
                String string4 = string2.substring(n3 + "import".length());
                bl = string4.startsWith("/");
            }
            string2 = this.adjustForRelativeToImportDir(string2);
            if (string == null) {
                string = "url";
            }
            if (!string.equals("none")) {
                string2 = this.decodeSourceFilename(string2, string, bl);
            }
            if (this.source_file_name_to_description_elements_mapping.get(string2) == null) {
                this.source_file_name_to_description_elements_mapping.put(string2, new ArrayList());
            }
            ((ArrayList)this.source_file_name_to_description_elements_mapping.get(string2)).add(n);
            if (isWin) {
                String string5 = string2;
                object3 = Gatherer.c_man.getCollection().getCollectionDirectory();
                object2 = new File((File)object3, "import" + File.separator + string2);
                if (((File)object2).exists()) {
                    string5 = ((File)object2).getCanonicalPath();
                }
                if (!string2.equals(string5 = this.adjustForRelativeToImportDir(string5))) {
                    object = this.source_file_name_to_description_elements_mapping.get(string2);
                    this.source_file_name_to_description_elements_mapping.put(string5, object);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            DebugStream.printStackTrace(fileNotFoundException);
        }
        catch (IOException iOException) {
            DebugStream.printStackTrace(iOException);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    private String adjustForRelativeToImportDir(String string) {
        int n = string.indexOf("import");
        if (n != -1) {
            string = string.substring(n + "import".length());
            boolean bl = string.startsWith("/");
            string = string.substring(1);
            if (bl && isWin) {
                string = string.replaceAll("\\/", "\\\\");
            } else if (!bl && !isWin) {
                string = string.replaceAll("\\\\", "/");
            }
        }
        return string;
    }

    protected String decodeSourceFilename(String string, String string2, boolean bl) throws Exception {
        int n = string.indexOf(".");
        String string3 = "";
        if (n != -1) {
            string3 = string.substring(n);
            string = string.substring(0, n);
        }
        String[] stringArray = DocXMLFile.getFilePathParts(string, bl);
        String string4 = "";
        String string5 = bl ? "/" : "\\";
        for (int i = 0; i < stringArray.length; ++i) {
            byte[] byArray;
            String string6 = "";
            string6 = string2.equals("url") ? URLDecoder.decode(stringArray[i], System.getProperty("file.encoding")) : ((byArray = Base64.decodeBase64(stringArray[i].getBytes())) == null ? stringArray[i] : new String(byArray, System.getProperty("file.encoding")));
            string4 = i == 0 ? string6 : string4 + string5 + string6;
        }
        string4 = string4 + string3;
        return string4;
    }

    private static String[] getFilePathParts(String string, boolean bl) {
        String[] stringArray;
        StringTokenizer stringTokenizer = bl ? new StringTokenizer(string, "/") : new StringTokenizer(string, "\\");
        int n = stringTokenizer.countTokens();
        if (n <= 0) {
            stringArray = new String[]{string};
        } else {
            int n2 = 0;
            stringArray = new String[n];
            while (stringTokenizer.hasMoreTokens()) {
                stringArray[n2] = stringTokenizer.nextToken();
                ++n2;
            }
        }
        return stringArray;
    }
}

