/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.collection.CollectionTreeNode;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.metadata.FilenameEncoding;

public class SynchronizedTreeModelTools {
    public static final Runnable insertNodeInto(DefaultTreeModel defaultTreeModel, MutableTreeNode mutableTreeNode, MutableTreeNode mutableTreeNode2) {
        return SynchronizedTreeModelTools.insertNodeInto(defaultTreeModel, mutableTreeNode, mutableTreeNode2, true);
    }

    public static final Runnable insertNodeInto(final DefaultTreeModel defaultTreeModel, final MutableTreeNode mutableTreeNode, final MutableTreeNode mutableTreeNode2, final boolean bl) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                DebugStream.println("insertNodeInto(" + defaultTreeModel + ", " + mutableTreeNode + ", " + mutableTreeNode2 + ", " + bl);
                int n = -1;
                int n2 = 0;
                while (n == -1 && n2 < mutableTreeNode.getChildCount()) {
                    TreeNode treeNode = mutableTreeNode.getChildAt(n2);
                    int n3 = 0;
                    n3 = mutableTreeNode2.isLeaf() && treeNode.isLeaf() || !mutableTreeNode2.isLeaf() && !treeNode.isLeaf() ? mutableTreeNode2.toString().toLowerCase().compareTo(treeNode.toString().toLowerCase()) : (mutableTreeNode2.isLeaf() ? 1 : -1);
                    if (n3 > 0) {
                        ++n2;
                        continue;
                    }
                    n = n2;
                }
                if (n == -1) {
                    n = mutableTreeNode.getChildCount();
                }
                defaultTreeModel.insertNodeInto(mutableTreeNode2, mutableTreeNode, n);
            }
        };
        try {
            if (bl && !SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return runnable;
    }

    public static final void removeNodeFromParent(final DefaultTreeModel defaultTreeModel, final MutableTreeNode mutableTreeNode) {
        block3: {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (mutableTreeNode instanceof CollectionTreeNode) {
                        CollectionTreeNode collectionTreeNode = (CollectionTreeNode)mutableTreeNode;
                        FilenameEncoding.map.remove(collectionTreeNode.getURLEncodedFilePath());
                    }
                    defaultTreeModel.removeNodeFromParent(mutableTreeNode);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
            catch (Error error) {
                if (!error.toString().equals("java.lang.Error: Cannot call invokeAndWait from the event dispatcher thread")) break block3;
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    public static final void removeShortcutFromRoot(final DefaultTreeModel defaultTreeModel, final MutableTreeNode mutableTreeNode, final MutableTreeNode mutableTreeNode2) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((FileSystemModel)defaultTreeModel).removeNodeFromRoot(mutableTreeNode2, mutableTreeNode);
            }
        };
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }
}

