/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gsdl3.service;

import java.io.File;
import org.apache.log4j.Logger;
import org.greenstone.gsdl3.core.GSException;
import org.greenstone.gsdl3.service.AbstractGS2DocumentRetrieve;
import org.greenstone.gsdl3.util.GSFile;
import org.greenstone.gsdl3.util.GSXML;
import org.greenstone.mgpp.MGPPRetrieveWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class GS2MGPPRetrieve
extends AbstractGS2DocumentRetrieve {
    static Logger logger = Logger.getLogger((String)GS2MGPPRetrieve.class.getName());
    private static final String LEVEL_PARAM = "level";
    private static final String DEFAULT_LEVEL_ELEM = "defaultLevel";
    private static MGPPRetrieveWrapper mgpp_src = null;
    private String default_level = null;
    private String mgpp_textdir = null;

    public GS2MGPPRetrieve() {
        if (mgpp_src == null) {
            mgpp_src = new MGPPRetrieveWrapper();
        }
    }

    public void cleanUp() {
        super.cleanUp();
    }

    public boolean configure(Element info, Element extra_info) {
        if (!super.configure(info, extra_info)) {
            return false;
        }
        logger.info((Object)"Configuring GS2MGPPRetrieve...");
        Element def = (Element)GSXML.getChildByTagName(info, DEFAULT_LEVEL_ELEM);
        if (def != null) {
            this.default_level = def.getAttribute("shortname");
        }
        if (this.default_level == null || this.default_level.equals("")) {
            logger.error((Object)"default level not specified!");
            return false;
        }
        this.mgpp_textdir = GSFile.collectionBaseDir(this.site_home, this.cluster_name) + File.separatorChar + GSFile.collectionTextPath(this.index_stem);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Element getNodeContent(String doc_id, String lang) throws GSException {
        long doc_num = this.coll_db.OID2DocnumLong(doc_id);
        if (doc_num == -1L) {
            logger.error((Object)("OID " + doc_id + " couldn't be converted to mgpp num"));
            return null;
        }
        Element content_node = this.doc.createElement("nodeContent");
        MGPPRetrieveWrapper mGPPRetrieveWrapper = mgpp_src;
        synchronized (mGPPRetrieveWrapper) {
            String doc_content = "";
            try {
                doc_content = mgpp_src.getDocument(this.mgpp_textdir, this.default_level, doc_num);
                if (doc_content != null) {
                    doc_content = this.resolveTextMacros(doc_content, doc_id, lang);
                }
            }
            catch (Exception e) {
                logger.info((Object)("exception happended with mgpp_src.getDocument()" + e));
                doc_content = "this is the content for section hash id " + doc_id + ", mgpp doc num " + doc_num + "\n";
            }
            Text t = this.doc.createTextNode(doc_content);
            content_node.appendChild(t);
            return content_node;
        }
    }
}

