/*
 * Decompiled with CFR 0.152.
 */
package jdbm.btree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import jdbm.btree.BTree;
import jdbm.helper.Serializer;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;

public final class BPage
implements Serializer {
    private static final boolean DEBUG = false;
    static final long serialVersionUID = 1L;
    transient BTree _btree;
    protected transient long _recid;
    protected boolean _isLeaf;
    protected Object[] _keys;
    protected Object[] _values;
    protected long[] _children;
    protected int _first;
    protected long _previous;
    protected long _next;

    public BPage() {
    }

    BPage(BTree bTree, BPage bPage, BPage bPage2) throws IOException {
        this._btree = bTree;
        this._isLeaf = false;
        this._first = this._btree._pageSize - 2;
        this._keys = new Object[this._btree._pageSize];
        this._keys[this._btree._pageSize - 2] = bPage2.getLargestKey();
        this._keys[this._btree._pageSize - 1] = bPage.getLargestKey();
        this._children = new long[this._btree._pageSize];
        this._children[this._btree._pageSize - 2] = bPage2._recid;
        this._children[this._btree._pageSize - 1] = bPage._recid;
        this._recid = this._btree._recman.insert(this, this);
    }

    BPage(BTree bTree, Object object, Object object2) throws IOException {
        this._btree = bTree;
        this._isLeaf = true;
        this._first = bTree._pageSize - 2;
        this._keys = new Object[this._btree._pageSize];
        this._keys[this._btree._pageSize - 2] = object;
        this._keys[this._btree._pageSize - 1] = null;
        this._values = new Object[this._btree._pageSize];
        this._values[this._btree._pageSize - 2] = object2;
        this._values[this._btree._pageSize - 1] = null;
        this._recid = this._btree._recman.insert(this, this);
    }

    BPage(BTree bTree, boolean bl) throws IOException {
        this._btree = bTree;
        this._isLeaf = bl;
        this._first = this._btree._pageSize / 2;
        this._keys = new Object[this._btree._pageSize];
        if (bl) {
            this._values = new Object[this._btree._pageSize];
        } else {
            this._children = new long[this._btree._pageSize];
        }
        this._recid = this._btree._recman.insert(this, this);
    }

    Object getLargestKey() {
        return this._keys[this._btree._pageSize - 1];
    }

    boolean isEmpty() {
        if (this._isLeaf) {
            return this._first == this._values.length - 1;
        }
        return this._first == this._children.length - 1;
    }

    boolean isFull() {
        return this._first == 0;
    }

    TupleBrowser find(int n, Object object) throws IOException {
        int n2 = this.findChildren(object);
        if (--n == 0) {
            return new Browser(this, n2);
        }
        BPage bPage = this.childBPage(n2);
        return bPage.find(n, object);
    }

    TupleBrowser findFirst() throws IOException {
        if (this._isLeaf) {
            return new Browser(this, this._first);
        }
        BPage bPage = this.childBPage(this._first);
        return bPage.findFirst();
    }

    InsertResult insert(int n, Object object, Object object2, boolean bl) throws IOException {
        long l;
        InsertResult insertResult;
        int n2 = this.findChildren(object);
        if (--n == 0) {
            insertResult = new InsertResult();
            l = -1L;
            if (this.compare(object, this._keys[n2]) == 0) {
                insertResult._existing = this._values[n2];
                if (bl) {
                    this._values[n2] = object2;
                    this._btree._recman.update(this._recid, this, this);
                }
                return insertResult;
            }
        } else {
            BPage bPage = this.childBPage(n2);
            insertResult = bPage.insert(n, object, object2, bl);
            if (insertResult._existing != null) {
                return insertResult;
            }
            if (insertResult._overflow == null) {
                return insertResult;
            }
            object = insertResult._overflow.getLargestKey();
            l = insertResult._overflow._recid;
            this._keys[n2] = bPage.getLargestKey();
            insertResult._overflow = null;
        }
        if (!this.isFull()) {
            if (n == 0) {
                BPage.insertEntry(this, n2 - 1, object, object2);
            } else {
                BPage.insertChild(this, n2 - 1, object, l);
            }
            this._btree._recman.update(this._recid, this, this);
            return insertResult;
        }
        int n3 = this._btree._pageSize >> 1;
        BPage bPage = new BPage(this._btree, this._isLeaf);
        if (n2 < n3) {
            if (n == 0) {
                BPage.copyEntries(this, 0, bPage, n3, n2);
                BPage.setEntry(bPage, n3 + n2, object, object2);
                BPage.copyEntries(this, n2, bPage, n3 + n2 + 1, n3 - n2 - 1);
            } else {
                BPage.copyChildren(this, 0, bPage, n3, n2);
                BPage.setChild(bPage, n3 + n2, object, l);
                BPage.copyChildren(this, n2, bPage, n3 + n2 + 1, n3 - n2 - 1);
            }
        } else if (n == 0) {
            BPage.copyEntries(this, 0, bPage, n3, n3);
            BPage.copyEntries(this, n3, this, n3 - 1, n2 - n3);
            BPage.setEntry(this, n2 - 1, object, object2);
        } else {
            BPage.copyChildren(this, 0, bPage, n3, n3);
            BPage.copyChildren(this, n3, this, n3 - 1, n2 - n3);
            BPage.setChild(this, n2 - 1, object, l);
        }
        this._first = n3 - 1;
        for (int i = 0; i < this._first; ++i) {
            if (n == 0) {
                BPage.setEntry(this, i, null, null);
                continue;
            }
            BPage.setChild(this, i, null, -1L);
        }
        if (this._isLeaf) {
            bPage._previous = this._previous;
            bPage._next = this._recid;
            if (this._previous != 0L) {
                BPage bPage2 = this.loadBPage(this._previous);
                bPage2._next = bPage._recid;
                this._btree._recman.update(this._previous, bPage2, this);
            }
            this._previous = bPage._recid;
        }
        this._btree._recman.update(this._recid, this, this);
        this._btree._recman.update(bPage._recid, bPage, this);
        insertResult._overflow = bPage;
        return insertResult;
    }

    RemoveResult remove(int n, Object object) throws IOException {
        RemoveResult removeResult;
        int n2 = this._btree._pageSize / 2;
        int n3 = this.findChildren(object);
        if (--n == 0) {
            if (this.compare(this._keys[n3], object) != 0) {
                throw new IllegalArgumentException("Key not found: " + object);
            }
            removeResult = new RemoveResult();
            removeResult._value = this._values[n3];
            BPage.removeEntry(this, n3);
            this._btree._recman.update(this._recid, this, this);
        } else {
            BPage bPage = this.childBPage(n3);
            removeResult = bPage.remove(n, object);
            this._keys[n3] = bPage.getLargestKey();
            this._btree._recman.update(this._recid, this, this);
            if (removeResult._underflow) {
                if (bPage._first != n2 + 1) {
                    throw new IllegalStateException("Error during underflow [1]");
                }
                if (n3 < this._children.length - 1) {
                    BPage bPage2 = this.childBPage(n3 + 1);
                    int n4 = bPage2._first;
                    if (n4 < n2) {
                        int n5 = (n2 - n4 + 1) / 2;
                        bPage2._first += n5;
                        bPage._first -= n5;
                        if (bPage._isLeaf) {
                            BPage.copyEntries(bPage, n2 + 1, bPage, n2 + 1 - n5, n2 - 1);
                            BPage.copyEntries(bPage2, n4, bPage, 2 * n2 - n5, n5);
                        } else {
                            BPage.copyChildren(bPage, n2 + 1, bPage, n2 + 1 - n5, n2 - 1);
                            BPage.copyChildren(bPage2, n4, bPage, 2 * n2 - n5, n5);
                        }
                        for (int i = n4; i < n4 + n5; ++i) {
                            if (bPage2._isLeaf) {
                                BPage.setEntry(bPage2, i, null, null);
                                continue;
                            }
                            BPage.setChild(bPage2, i, null, -1L);
                        }
                        this._keys[n3] = bPage.getLargestKey();
                        this._btree._recman.update(this._recid, this, this);
                        this._btree._recman.update(bPage2._recid, bPage2, this);
                        this._btree._recman.update(bPage._recid, bPage, this);
                    } else {
                        BPage bPage3;
                        if (bPage2._first != n2) {
                            throw new IllegalStateException("Error during underflow [2]");
                        }
                        bPage2._first = 1;
                        if (bPage._isLeaf) {
                            BPage.copyEntries(bPage, n2 + 1, bPage2, 1, n2 - 1);
                        } else {
                            BPage.copyChildren(bPage, n2 + 1, bPage2, 1, n2 - 1);
                        }
                        this._btree._recman.update(bPage2._recid, bPage2, this);
                        if (this._isLeaf) {
                            BPage.copyEntries(this, this._first, this, this._first + 1, n3 - this._first);
                            BPage.setEntry(this, this._first, null, null);
                        } else {
                            BPage.copyChildren(this, this._first, this, this._first + 1, n3 - this._first);
                            BPage.setChild(this, this._first, null, -1L);
                        }
                        ++this._first;
                        this._btree._recman.update(this._recid, this, this);
                        if (bPage._previous != 0L) {
                            bPage3 = this.loadBPage(bPage._previous);
                            bPage3._next = bPage._next;
                            this._btree._recman.update(bPage3._recid, bPage3, this);
                        }
                        if (bPage._next != 0L) {
                            bPage3 = this.loadBPage(bPage._next);
                            bPage3._previous = bPage._previous;
                            this._btree._recman.update(bPage3._recid, bPage3, this);
                        }
                        this._btree._recman.delete(bPage._recid);
                    }
                } else {
                    BPage bPage4 = this.childBPage(n3 - 1);
                    int n6 = bPage4._first;
                    if (n6 < n2) {
                        int n7 = (n2 - n6 + 1) / 2;
                        bPage4._first += n7;
                        bPage._first -= n7;
                        if (bPage._isLeaf) {
                            BPage.copyEntries(bPage4, 2 * n2 - n7, bPage, n2 + 1 - n7, n7);
                            BPage.copyEntries(bPage4, n6, bPage4, n6 + n7, 2 * n2 - n6 - n7);
                        } else {
                            BPage.copyChildren(bPage4, 2 * n2 - n7, bPage, n2 + 1 - n7, n7);
                            BPage.copyChildren(bPage4, n6, bPage4, n6 + n7, 2 * n2 - n6 - n7);
                        }
                        for (int i = n6; i < n6 + n7; ++i) {
                            if (bPage4._isLeaf) {
                                BPage.setEntry(bPage4, i, null, null);
                                continue;
                            }
                            BPage.setChild(bPage4, i, null, -1L);
                        }
                        this._keys[n3 - 1] = bPage4.getLargestKey();
                        this._btree._recman.update(this._recid, this, this);
                        this._btree._recman.update(bPage4._recid, bPage4, this);
                        this._btree._recman.update(bPage._recid, bPage, this);
                    } else {
                        BPage bPage5;
                        if (bPage4._first != n2) {
                            throw new IllegalStateException("Error during underflow [3]");
                        }
                        bPage._first = 1;
                        if (bPage._isLeaf) {
                            BPage.copyEntries(bPage4, n2, bPage, 1, n2);
                        } else {
                            BPage.copyChildren(bPage4, n2, bPage, 1, n2);
                        }
                        this._btree._recman.update(bPage._recid, bPage, this);
                        if (this._isLeaf) {
                            BPage.copyEntries(this, this._first, this, this._first + 1, n3 - 1 - this._first);
                            BPage.setEntry(this, this._first, null, null);
                        } else {
                            BPage.copyChildren(this, this._first, this, this._first + 1, n3 - 1 - this._first);
                            BPage.setChild(this, this._first, null, -1L);
                        }
                        ++this._first;
                        this._btree._recman.update(this._recid, this, this);
                        if (bPage4._previous != 0L) {
                            bPage5 = this.loadBPage(bPage4._previous);
                            bPage5._next = bPage4._next;
                            this._btree._recman.update(bPage5._recid, bPage5, this);
                        }
                        if (bPage4._next != 0L) {
                            bPage5 = this.loadBPage(bPage4._next);
                            bPage5._previous = bPage4._previous;
                            this._btree._recman.update(bPage5._recid, bPage5, this);
                        }
                        this._btree._recman.delete(bPage4._recid);
                    }
                }
            }
        }
        removeResult._underflow = this._first > n2;
        return removeResult;
    }

    private int findChildren(Object object) {
        int n = this._first;
        int n2 = this._btree._pageSize - 1;
        while (n < n2) {
            int n3 = (n + n2) / 2;
            if (this.compare(this._keys[n3], object) < 0) {
                n = n3 + 1;
                continue;
            }
            n2 = n3;
        }
        return n2;
    }

    private static void insertEntry(BPage bPage, int n, Object object, Object object2) {
        Object[] objectArray = bPage._keys;
        Object[] objectArray2 = bPage._values;
        int n2 = bPage._first;
        int n3 = n - bPage._first + 1;
        System.arraycopy(objectArray, n2, objectArray, n2 - 1, n3);
        System.arraycopy(objectArray2, n2, objectArray2, n2 - 1, n3);
        --bPage._first;
        objectArray[n] = object;
        objectArray2[n] = object2;
    }

    private static void insertChild(BPage bPage, int n, Object object, long l) {
        Object[] objectArray = bPage._keys;
        long[] lArray = bPage._children;
        int n2 = bPage._first;
        int n3 = n - bPage._first + 1;
        System.arraycopy(objectArray, n2, objectArray, n2 - 1, n3);
        System.arraycopy(lArray, n2, lArray, n2 - 1, n3);
        --bPage._first;
        objectArray[n] = object;
        lArray[n] = l;
    }

    private static void removeEntry(BPage bPage, int n) {
        Object[] objectArray = bPage._keys;
        Object[] objectArray2 = bPage._values;
        int n2 = bPage._first;
        int n3 = n - bPage._first;
        System.arraycopy(objectArray, n2, objectArray, n2 + 1, n3);
        objectArray[n2] = null;
        System.arraycopy(objectArray2, n2, objectArray2, n2 + 1, n3);
        objectArray2[n2] = null;
        ++bPage._first;
    }

    private static void setEntry(BPage bPage, int n, Object object, Object object2) {
        bPage._keys[n] = object;
        bPage._values[n] = object2;
    }

    private static void setChild(BPage bPage, int n, Object object, long l) {
        bPage._keys[n] = object;
        bPage._children[n] = l;
    }

    private static void copyEntries(BPage bPage, int n, BPage bPage2, int n2, int n3) {
        System.arraycopy(bPage._keys, n, bPage2._keys, n2, n3);
        System.arraycopy(bPage._values, n, bPage2._values, n2, n3);
    }

    private static void copyChildren(BPage bPage, int n, BPage bPage2, int n2, int n3) {
        System.arraycopy(bPage._keys, n, bPage2._keys, n2, n3);
        System.arraycopy(bPage._children, n, bPage2._children, n2, n3);
    }

    BPage childBPage(int n) throws IOException {
        return this.loadBPage(this._children[n]);
    }

    private BPage loadBPage(long l) throws IOException {
        BPage bPage = (BPage)this._btree._recman.fetch(l, this);
        bPage._recid = l;
        bPage._btree = this._btree;
        return bPage;
    }

    private final int compare(Object object, Object object2) {
        if (object == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        return this._btree._comparator.compare(object, object2);
    }

    static byte[] readByteArray(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        if (n < 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        objectInput.readFully(byArray);
        return byArray;
    }

    static void writeByteArray(ObjectOutput objectOutput, byte[] byArray) throws IOException {
        if (byArray == null) {
            objectOutput.writeInt(-1);
        } else {
            objectOutput.writeInt(byArray.length);
            objectOutput.write(byArray);
        }
    }

    private void dump(int n) {
        int n2;
        String string = "";
        for (n2 = 0; n2 < n; ++n2) {
            string = string + "    ";
        }
        System.out.println(string + "-------------------------------------- BPage recid=" + this._recid);
        System.out.println(string + "first=" + this._first);
        for (n2 = 0; n2 < this._btree._pageSize; ++n2) {
            if (this._isLeaf) {
                System.out.println(string + "BPage [" + n2 + "] " + this._keys[n2] + " " + this._values[n2]);
                continue;
            }
            System.out.println(string + "BPage [" + n2 + "] " + this._keys[n2] + " " + this._children[n2]);
        }
        System.out.println(string + "--------------------------------------");
    }

    void dumpRecursive(int n, int n2) throws IOException {
        ++n2;
        if (--n > 0) {
            for (int i = this._first; i < this._btree._pageSize && this._keys[i] != null; ++i) {
                BPage bPage = this.childBPage(i);
                bPage.dump(n2);
                bPage.dumpRecursive(n, n2);
            }
        }
    }

    private void assertConsistency() {
        for (int i = this._first; i < this._btree._pageSize - 1; ++i) {
            if (this.compare((byte[])this._keys[i], (byte[])this._keys[i + 1]) < 0) continue;
            this.dump(0);
            throw new Error("BPage not ordered");
        }
    }

    void assertConsistencyRecursive(int n) throws IOException {
        this.assertConsistency();
        if (--n > 0) {
            for (int i = this._first; i < this._btree._pageSize && this._keys[i] != null; ++i) {
                BPage bPage = this.childBPage(i);
                if (this.compare((byte[])this._keys[i], bPage.getLargestKey()) != 0) {
                    this.dump(0);
                    bPage.dump(0);
                    throw new Error("Invalid child subordinate key");
                }
                bPage.assertConsistencyRecursive(n);
            }
        }
    }

    @Override
    public Object deserialize(byte[] byArray) throws IOException {
        int n;
        BPage bPage = new BPage();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        bPage._isLeaf = objectInputStream.readBoolean();
        if (bPage._isLeaf) {
            bPage._previous = objectInputStream.readLong();
            bPage._next = objectInputStream.readLong();
        }
        bPage._first = objectInputStream.readInt();
        bPage._keys = new Object[this._btree._pageSize];
        try {
            for (n = bPage._first; n < this._btree._pageSize; ++n) {
                if (this._btree._keySerializer == null) {
                    bPage._keys[n] = objectInputStream.readObject();
                    continue;
                }
                byArray = BPage.readByteArray(objectInputStream);
                if (byArray == null) continue;
                bPage._keys[n] = this._btree._keySerializer.deserialize(byArray);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        if (bPage._isLeaf) {
            bPage._values = new Object[this._btree._pageSize];
            try {
                for (n = bPage._first; n < this._btree._pageSize; ++n) {
                    if (this._btree._valueSerializer == null) {
                        bPage._values[n] = objectInputStream.readObject();
                        continue;
                    }
                    byArray = BPage.readByteArray(objectInputStream);
                    if (byArray == null) continue;
                    bPage._values[n] = this._btree._valueSerializer.deserialize(byArray);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException(classNotFoundException.getMessage());
            }
        } else {
            bPage._children = new long[this._btree._pageSize];
            for (n = bPage._first; n < this._btree._pageSize; ++n) {
                bPage._children[n] = objectInputStream.readLong();
            }
        }
        objectInputStream.close();
        byteArrayInputStream.close();
        return bPage;
    }

    @Override
    public byte[] serialize(Object object) throws IOException {
        byte[] byArray;
        int n;
        BPage bPage = (BPage)object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeBoolean(bPage._isLeaf);
        if (bPage._isLeaf) {
            objectOutputStream.writeLong(bPage._previous);
            objectOutputStream.writeLong(bPage._next);
        }
        objectOutputStream.writeInt(bPage._first);
        for (n = bPage._first; n < this._btree._pageSize; ++n) {
            if (this._btree._keySerializer == null) {
                objectOutputStream.writeObject(bPage._keys[n]);
                continue;
            }
            if (bPage._keys[n] != null) {
                byArray = this._btree._keySerializer.serialize(bPage._keys[n]);
                BPage.writeByteArray(objectOutputStream, byArray);
                continue;
            }
            BPage.writeByteArray(objectOutputStream, null);
        }
        if (bPage._isLeaf) {
            for (n = bPage._first; n < this._btree._pageSize; ++n) {
                if (this._btree._valueSerializer == null) {
                    objectOutputStream.writeObject(bPage._values[n]);
                    continue;
                }
                if (bPage._values[n] != null) {
                    byArray = this._btree._valueSerializer.serialize(bPage._values[n]);
                    BPage.writeByteArray(objectOutputStream, byArray);
                    continue;
                }
                BPage.writeByteArray(objectOutputStream, null);
            }
        } else {
            for (n = bPage._first; n < this._btree._pageSize; ++n) {
                objectOutputStream.writeLong(bPage._children[n]);
            }
        }
        objectOutputStream.flush();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        objectOutputStream.close();
        byteArrayOutputStream.close();
        return byArray2;
    }

    static class Browser
    extends TupleBrowser {
        private BPage _page;
        private int _index;

        Browser(BPage bPage, int n) {
            this._page = bPage;
            this._index = n;
        }

        @Override
        public boolean getNext(Tuple tuple) throws IOException {
            if (this._index < this._page._btree._pageSize) {
                if (this._page._keys[this._index] == null) {
                    return false;
                }
            } else if (this._page._next != 0L) {
                this._page = this._page.loadBPage(this._page._next);
                this._index = this._page._first;
            }
            tuple.setKey(this._page._keys[this._index]);
            tuple.setValue(this._page._values[this._index]);
            ++this._index;
            return true;
        }

        @Override
        public boolean getPrevious(Tuple tuple) throws IOException {
            if (this._index == this._page._first) {
                if (this._page._previous != 0L) {
                    this._page = this._page.loadBPage(this._page._previous);
                    this._index = this._page._btree._pageSize;
                } else {
                    return false;
                }
            }
            --this._index;
            tuple.setKey(this._page._keys[this._index]);
            tuple.setValue(this._page._values[this._index]);
            return true;
        }
    }

    static class RemoveResult {
        boolean _underflow;
        Object _value;

        RemoveResult() {
        }
    }

    static class InsertResult {
        BPage _overflow;
        Object _existing;

        InsertResult() {
        }
    }
}

