/*
 * Decompiled with CFR 0.152.
 */
package jdbm.recman;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import jdbm.RecordManager;
import jdbm.helper.DefaultSerializer;
import jdbm.helper.Serializer;
import jdbm.recman.Location;
import jdbm.recman.LogicalRowIdManager;
import jdbm.recman.PageManager;
import jdbm.recman.PhysicalRowIdManager;
import jdbm.recman.RecordFile;
import jdbm.recman.TransactionManager;

public final class BaseRecordManager
implements RecordManager {
    private RecordFile _file;
    private PhysicalRowIdManager _physMgr;
    private LogicalRowIdManager _logMgr;
    private PageManager _pageman;
    public static final int NAME_DIRECTORY_ROOT = 0;
    public static final boolean DEBUG = false;
    private Map _nameDirectory;

    public BaseRecordManager(String string) throws IOException {
        this._file = new RecordFile(string);
        this._pageman = new PageManager(this._file);
        this._physMgr = new PhysicalRowIdManager(this._file, this._pageman);
        this._logMgr = new LogicalRowIdManager(this._file, this._pageman);
    }

    public synchronized TransactionManager getTransactionManager() {
        this.checkIfClosed();
        return this._file.txnMgr;
    }

    public synchronized void disableTransactions() {
        this.checkIfClosed();
        this._file.disableTransactions();
    }

    @Override
    public synchronized void close() throws IOException {
        this.checkIfClosed();
        this._pageman.close();
        this._pageman = null;
        this._file.close();
        this._file = null;
    }

    @Override
    public long insert(Object object) throws IOException {
        return this.insert(object, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized long insert(Object object, Serializer serializer) throws IOException {
        this.checkIfClosed();
        byte[] byArray = serializer.serialize(object);
        Location location = this._physMgr.insert(byArray, 0, byArray.length);
        long l = this._logMgr.insert(location).toLong();
        return l;
    }

    @Override
    public synchronized void delete(long l) throws IOException {
        this.checkIfClosed();
        if (l <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + l);
        }
        Location location = new Location(l);
        Location location2 = this._logMgr.fetch(location);
        this._physMgr.delete(location2);
        this._logMgr.delete(location);
    }

    @Override
    public void update(long l, Object object) throws IOException {
        this.update(l, object, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized void update(long l, Object object, Serializer serializer) throws IOException {
        byte[] byArray;
        this.checkIfClosed();
        if (l <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + l);
        }
        Location location = new Location(l);
        Location location2 = this._logMgr.fetch(location);
        Location location3 = this._physMgr.update(location2, byArray = serializer.serialize(object), 0, byArray.length);
        if (!location3.equals(location2)) {
            this._logMgr.update(location, location3);
        }
    }

    @Override
    public Object fetch(long l) throws IOException {
        return this.fetch(l, DefaultSerializer.INSTANCE);
    }

    @Override
    public synchronized Object fetch(long l, Serializer serializer) throws IOException {
        this.checkIfClosed();
        if (l <= 0L) {
            throw new IllegalArgumentException("Argument 'recid' is invalid: " + l);
        }
        byte[] byArray = this._physMgr.fetch(this._logMgr.fetch(new Location(l)));
        return serializer.deserialize(byArray);
    }

    @Override
    public int getRootCount() {
        return 1013;
    }

    @Override
    public synchronized long getRoot(int n) throws IOException {
        this.checkIfClosed();
        return this._pageman.getFileHeader().getRoot(n);
    }

    @Override
    public synchronized void setRoot(int n, long l) throws IOException {
        this.checkIfClosed();
        this._pageman.getFileHeader().setRoot(n, l);
    }

    @Override
    public long getNamedObject(String string) throws IOException {
        this.checkIfClosed();
        Map map = this.getNameDirectory();
        Long l = (Long)map.get(string);
        if (l == null) {
            return 0L;
        }
        return l;
    }

    @Override
    public void setNamedObject(String string, long l) throws IOException {
        this.checkIfClosed();
        Map map = this.getNameDirectory();
        if (l == 0L) {
            map.remove(string);
        } else {
            map.put(string, new Long(l));
        }
        this.saveNameDirectory(map);
    }

    @Override
    public synchronized void commit() throws IOException {
        this.checkIfClosed();
        this._pageman.commit();
    }

    @Override
    public synchronized void rollback() throws IOException {
        this.checkIfClosed();
        this._pageman.rollback();
    }

    private Map getNameDirectory() throws IOException {
        long l = this.getRoot(0);
        if (l == 0L) {
            this._nameDirectory = new HashMap();
            l = this.insert(this._nameDirectory);
            this.setRoot(0, l);
        } else {
            this._nameDirectory = (Map)this.fetch(l);
        }
        return this._nameDirectory;
    }

    private void saveNameDirectory(Map map) throws IOException {
        long l = this.getRoot(0);
        if (l == 0L) {
            throw new IOException("Name directory must exist");
        }
        this.update(l, this._nameDirectory);
    }

    private void checkIfClosed() throws IllegalStateException {
        if (this._file == null) {
            throw new IllegalStateException("RecordManager has been closed");
        }
    }
}

