/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Properties;
import jdbm.RecordManager;
import jdbm.RecordManagerFactory;
import jdbm.helper.FastIterator;
import jdbm.htree.HTree;

public class JdbmAPI {
    static String TNAME = "greenstone";
    RecordManager recman_;
    HTree hashtable_;
    private static PrintWriter utf8out = null;

    public JdbmAPI(String string, boolean bl) throws IOException {
        if (string.endsWith(".jdb")) {
            string = string.substring(0, string.length() - 4);
        }
        Properties properties = new Properties();
        this.recman_ = RecordManagerFactory.createRecordManager((String)string, (Properties)properties);
        long l = this.recman_.getNamedObject(TNAME);
        if (l != 0L) {
            this.hashtable_ = HTree.load((RecordManager)this.recman_, (long)l);
        } else {
            if (bl) {
                this.recman_.close();
                throw new IOException();
            }
            this.hashtable_ = HTree.createInstance((RecordManager)this.recman_);
            this.recman_.setNamedObject(TNAME, this.hashtable_.getRecid());
        }
    }

    public JdbmAPI(String string) throws IOException {
        this(string, false);
    }

    public void append(String string, String string2) throws IOException {
        String string3 = (String)this.hashtable_.get((Object)string);
        String string4 = string3 + string2;
        this.hashtable_.put((Object)string, (Object)string4);
        this.recman_.commit();
    }

    public void set(String string, String string2) throws IOException {
        this.hashtable_.put((Object)string, (Object)string2);
        this.recman_.commit();
    }

    public void delete(String string) throws IOException {
        this.hashtable_.remove((Object)string);
        this.recman_.commit();
    }

    public String get(String string) throws IOException {
        String string2 = (String)this.hashtable_.get((Object)string);
        this.recman_.commit();
        return string2;
    }

    public ArrayList get_keys() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        FastIterator fastIterator = this.hashtable_.keys();
        String string = (String)fastIterator.next();
        while (string != null) {
            arrayList.add(string);
            string = (String)fastIterator.next();
        }
        this.recman_.commit();
        return arrayList;
    }

    public void close() throws IOException {
        this.recman_.close();
    }

    public static void skip_eol(BufferedReader bufferedReader) throws IOException {
        int n = bufferedReader.read();
        if (n == 13) {
            n = bufferedReader.read();
        }
        if (n != 10) {
            // empty if block
        }
    }

    public static void print_usage() {
        System.err.println("");
        System.err.println("Usage: java JdbmAPI database-name");
        System.err.println("");
        System.err.println("  - The JDBM commands to perform are then taken from standard-in");
        System.err.println("  - Commands (with operands) are:");
        System.err.println("      Keys");
        System.err.println("      Get\\n<key>");
        System.err.println("      Set\\n<key>\\n<vallen>\\n<val>");
        System.err.println("      Append\\n<key>\\n<vallen>\\n<val>");
        System.err.println("      Delete\\n<key>");
        System.err.println("");
        System.err.println("  - Operands are given on separate lines.");
        System.err.println("  - In the case of <val> it is preceeded by its length.");
        System.err.println("");
        System.err.println("  - For example the following would set the key 'HASH0143' to 'testing':");
        System.err.println("      Set");
        System.err.println("      HASH0143");
        System.err.println("      7");
        System.err.println("      testing");
        System.err.println("");
        System.exit(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] stringArray) {
        int n = stringArray.length;
        if (n != 1) {
            JdbmAPI.print_usage();
        }
        try {
            String string = stringArray[0];
            JdbmAPI jdbmAPI = new JdbmAPI(string);
            InputStreamReader inputStreamReader = new InputStreamReader(System.in, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            boolean bl = false;
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                block15: {
                    Object object;
                    int n2;
                    Object object2;
                    block17: {
                        block16: {
                            if (!string2.equals("Keys")) break block16;
                            object2 = jdbmAPI.get_keys();
                            int n3 = ((ArrayList)object2).size();
                            utf8out.println(n3);
                            for (n2 = 0; n2 < n3; ++n2) {
                                object = (String)((ArrayList)object2).get(n2);
                                utf8out.println((String)object);
                            }
                            break block15;
                        }
                        if (!string2.equals("Get") && !string2.equals("Delete")) break block17;
                        object2 = bufferedReader.readLine();
                        if (object2 != null) {
                            if (string2.equals("Get")) {
                                String string3 = jdbmAPI.get((String)object2);
                                utf8out.println(string3.length());
                                utf8out.println(string3);
                                break block15;
                            } else {
                                jdbmAPI.delete((String)object2);
                            }
                            break block15;
                        } else {
                            bl = true;
                            break;
                        }
                    }
                    if (string2.equals("Set") || string2.equals("Append")) {
                        object2 = bufferedReader.readLine();
                        String string4 = bufferedReader.readLine();
                        if (string4 == null) {
                            bl = true;
                            break;
                        }
                        n2 = Integer.parseInt(string4);
                        object = new char[n2];
                        bufferedReader.read((char[])object, 0, n2);
                        JdbmAPI.skip_eol(bufferedReader);
                        if (((Object)object).length == 0) {
                            bl = true;
                            break;
                        }
                        String string5 = new String((char[])object);
                        if (string2.equals("Set")) {
                            jdbmAPI.set((String)object2, string5);
                        } else {
                            jdbmAPI.append((String)object2, string5);
                        }
                    } else {
                        bl = true;
                    }
                }
                string2 = bufferedReader.readLine();
            }
            jdbmAPI.close();
            if (!bl) return;
            System.exit(-1);
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static {
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)System.out, "UTF-8");
            utf8out = new PrintWriter((Writer)outputStreamWriter, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.out.println(unsupportedEncodingException);
        }
    }
}

