/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.BuildTypeManager;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.Index;
import org.greenstone.gatherer.cdm.SearchMeta;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.util.CheckList;
import org.greenstone.gatherer.util.JarTools;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class BaseIndexManager
extends DOMProxyListModel
implements BuildTypeManager.BuildTypeListener {
    protected DOMProxyListModel index_model = null;
    protected Index default_index = null;
    protected Control controls = null;
    protected String build_type = null;
    protected String index_element_name = null;
    protected String index_default_element_name = null;
    protected String controls_title_key = null;
    protected String new_button_key = "CDM.IndexManager.New";
    protected String new_button_tooltip_key = null;
    protected String edit_button_key = "CDM.IndexManager.Edit";
    protected String edit_button_tooltip_key = null;
    protected String remove_button_key = "CDM.IndexManager.Remove";
    protected String remove_button_tooltip_key = null;
    protected String default_indicator_key = null;
    protected String set_default_tooltip_key = "CDM.IndexManager.Set_Default_Tooltip";
    protected String nip_new_index_key = null;
    protected String nip_edit_index_key = null;
    protected String nip_source_label_key = null;
    protected String nip_source_tooltip_key = null;
    protected String nip_custom_label_key = null;
    protected String nip_custom_tooltip_key = null;
    protected String nip_add_index_button_key = null;
    protected String nip_add_index_tooltip_key = null;
    protected String nip_replace_index_button_key = null;
    protected String nip_replace_index_tooltip_key = null;
    protected String nip_add_all_index_button_key = null;
    protected String nip_add_all_index_tooltip_key = null;
    protected static final Dimension PROMPT_SIZE = new Dimension(500, 500);

    public BaseIndexManager(Element element, String string, String string2, String string3, Index index) {
        super(element, string2, index);
        NodeList nodeList;
        DebugStream.println(this.getClass().getSimpleName() + ": " + this.getSize() + " items parsed.");
        this.index_element_name = string2;
        this.index_default_element_name = string3;
        this.index_model = this;
        if (this.index_default_element_name != null && (nodeList = CollectionConfiguration.getElementsByTagName(this.index_default_element_name)).getLength() > 0) {
            this.default_index = this.createIndex((Element)nodeList.item(0));
        }
        this.build_type = string;
    }

    protected Index createIndex(Element element) {
        return (Index)this.getClassType().create(element);
    }

    protected Index createIndex(ArrayList arrayList) {
        return (Index)((Index)this.getClassType()).create(arrayList);
    }

    protected void addIndex(Index index, SearchMeta searchMeta) {
        if (!this.contains(index)) {
            CollectionDesignManager.searchmeta_manager.addMetadatum(searchMeta);
            if (this.getSize() > 0) {
                Index index2 = (Index)this.getElementAt(this.getSize() - 1);
                this.addAfter(index, index2);
            } else {
                this.add(index);
                this.setDefault(index);
            }
        } else {
            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.IndexManager.Index_Exists"), Dictionary.get("General.Warning"), 2);
        }
    }

    @Override
    public void buildTypeChanged(String string) {
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new IndexControl();
        }
        return this.controls;
    }

    public Index getIndex(int n) {
        if (0 <= n && n < this.getSize()) {
            return (Index)this.getElementAt(n);
        }
        return null;
    }

    public Index getIndex(String string) {
        int n = this.getSize();
        for (int i = 0; i < n; ++i) {
            Index index = (Index)this.getElementAt(i);
            if (!index.getID().equals(string)) continue;
            return index;
        }
        return null;
    }

    public ArrayList getIndexes() {
        return this.children();
    }

    public void modeChanged(int n) {
    }

    protected void moveIndex(Index index, boolean bl) {
        int n = this.indexOf(index);
        if (n == -1) {
            return;
        }
        if (n == 0 && bl) {
            return;
        }
        if (n == this.getSize() - 1 && !bl) {
            return;
        }
        if (bl) {
            this.remove(index);
            this.add(--n, index);
        } else {
            this.remove(index);
            this.add(++n, index);
        }
    }

    protected void removeIndex(Index index) {
        if (index != null) {
            CollectionDesignManager.searchmeta_manager.removeMetadata(index.getID(), index.getType());
            this.remove(index);
            if (this.default_index != null && this.default_index.equals(index)) {
                if (this.getSize() > 0) {
                    Index index2 = (Index)this.getElementAt(0);
                    this.setDefault(index2);
                    index2 = null;
                } else {
                    this.default_index.setAssigned(false);
                }
            }
        }
    }

    protected void replaceIndex(Index index, Index index2, SearchMeta searchMeta) {
        if (index == null || index2 == null || searchMeta == null) {
            return;
        }
        if (!index.getID().equals(index2.getID()) && this.contains(index2)) {
            return;
        }
        CollectionDesignManager.searchmeta_manager.removeMetadata(index.getID(), index.getType());
        CollectionDesignManager.searchmeta_manager.addMetadatum(searchMeta);
        int n = this.indexOf(index);
        this.remove(index);
        this.add(n, index2);
    }

    public void setDefault(Index index) {
        if (this.index_default_element_name == null) {
            return;
        }
        if (index != null) {
            if (this.default_index == null) {
                Element element = this.root.getOwnerDocument().createElement(this.index_default_element_name);
                this.default_index = this.createIndex(element);
                Node node = CollectionConfiguration.findInsertionPoint(element);
                if (node != null) {
                    this.root.getOwnerDocument().getDocumentElement().insertBefore(element, node);
                } else {
                    this.root.getOwnerDocument().getDocumentElement().appendChild(element);
                }
            }
            this.default_index.setAssigned(true);
            this.default_index.setSources(index.getSources());
        } else if (this.default_index != null) {
            this.default_index.setAssigned(false);
        }
    }

    protected class IndexControl
    extends JPanel
    implements Control {
        protected JList index_list;
        protected JButton move_down_button;
        protected JButton move_up_button;
        protected JButton set_default_button;
        protected JButton new_button;
        protected JButton edit_button;
        protected JButton remove_button;
        protected boolean has_default = false;

        public IndexControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            if (BaseIndexManager.this.index_default_element_name != null) {
                this.has_default = true;
            }
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            JLabel jLabel = new JLabel(Dictionary.get(BaseIndexManager.this.controls_title_key));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            this.index_list = new JList(BaseIndexManager.this.index_model);
            this.index_list.setCellRenderer(new IndexListRenderer());
            this.index_list.setVisibleRowCount(6);
            this.index_list.setSelectionMode(0);
            this.index_list.addMouseListener(new ClickListener());
            this.index_list.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            this.move_up_button = new GLIButton(Dictionary.get("CDM.Move.Move_Up"), JarTools.getImage("arrow-up.gif"), Dictionary.get("CDM.Move.Move_Up_Tooltip"));
            this.move_up_button.setEnabled(false);
            this.move_down_button = new GLIButton(Dictionary.get("CDM.Move.Move_Down"), JarTools.getImage("arrow-down.gif"), Dictionary.get("CDM.Move.Move_Down_Tooltip"));
            this.move_down_button.setEnabled(false);
            this.set_default_button = new GLIButton(Dictionary.get("CDM.IndexManager.Set_Default"), Dictionary.get(BaseIndexManager.this.set_default_tooltip_key));
            this.set_default_button.setEnabled(false);
            JPanel jPanel3 = new JPanel();
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            this.new_button = new GLIButton(Dictionary.get(BaseIndexManager.this.new_button_key) + "...", Dictionary.get(BaseIndexManager.this.new_button_tooltip_key));
            this.new_button.setEnabled(true);
            this.edit_button = new GLIButton(Dictionary.get(BaseIndexManager.this.edit_button_key) + "...", Dictionary.get(BaseIndexManager.this.edit_button_tooltip_key));
            this.edit_button.setEnabled(false);
            this.remove_button = new GLIButton(Dictionary.get(BaseIndexManager.this.remove_button_key), Dictionary.get(BaseIndexManager.this.remove_button_tooltip_key));
            this.remove_button.setEnabled(false);
            this.new_button.addActionListener(new NewIndexListener());
            this.edit_button.addActionListener(new EditIndexListener());
            this.remove_button.addActionListener(new RemoveIndexListener());
            this.remove_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.index_list.addListSelectionListener(new IndexListListener());
            this.move_down_button.addActionListener(new MoveListener(false));
            this.move_down_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            this.move_up_button.addActionListener(new MoveListener(true));
            this.move_up_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
            jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
            jPanel2.setLayout(new GridLayout(3, 1));
            jPanel2.add(this.move_up_button);
            jPanel2.add(this.move_down_button);
            if (this.has_default) {
                this.set_default_button.addActionListener(new SetDefaultListener());
                jPanel2.add(this.set_default_button);
            }
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jLabel, "North");
            jPanel.add((Component)new JScrollPane(this.index_list), "Center");
            jPanel.add((Component)jPanel2, "After");
            jPanel3.setLayout(new GridLayout(1, 3, 5, 0));
            jPanel3.add(this.new_button);
            jPanel3.add(this.edit_button);
            jPanel3.add(this.remove_button);
            this.setBorder(BorderFactory.createBevelBorder(0));
            this.setLayout(new BorderLayout());
            this.add((Component)jPanel, "Center");
            this.add((Component)jPanel3, "South");
        }

        @Override
        public void loseFocus() {
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void destroy() {
        }

        protected NewIndexPrompt createNewIndexPrompt(String string, Index index) {
            return new NewIndexPrompt(string, index);
        }

        protected class NewIndexPrompt
        extends ModalDialog {
            NewIndexPrompt new_index_prompt;
            protected CheckList source_list;
            protected JTextField custom_field;
            protected JButton add_or_replace_button;
            protected JButton add_all_button;
            protected JButton cancel_button;
            protected JPanel content_pane;
            protected JPanel details_pane;
            protected JPanel extra_pane;
            protected JPanel button_pane;
            protected boolean editing;

            public NewIndexPrompt(String string, Index index) {
                super((Frame)Gatherer.g_man, true);
                this.new_index_prompt = null;
                this.editing = false;
                this.setComponentOrientation(Dictionary.getOrientation());
                this.new_index_prompt = this;
                this.setModal(true);
                this.setSize(PROMPT_SIZE);
                if (index != null) {
                    this.setTitle(Dictionary.get(BaseIndexManager.this.nip_edit_index_key));
                    this.editing = true;
                } else {
                    this.setTitle(Dictionary.get(BaseIndexManager.this.nip_new_index_key));
                }
                this.setJMenuBar(new SimpleMenuBar("searchindexes"));
                this.content_pane = (JPanel)this.getContentPane();
                this.content_pane.setComponentOrientation(Dictionary.getOrientation());
                this.generateContents(string, index);
                Dimension dimension = Configuration.screen_size;
                this.setLocation((dimension.width - BaseIndexManager.PROMPT_SIZE.width) / 2, (dimension.height - BaseIndexManager.PROMPT_SIZE.height) / 2);
                dimension = null;
                this.setVisible(true);
            }

            public boolean display() {
                this.setVisible(true);
                return true;
            }

            public void destroy() {
            }

            protected void generateContents(String string, Index index) {
                ArrayList arrayList = new ArrayList();
                arrayList.addAll(MetadataSetManager.getEveryMetadataSetElement());
                this.details_pane = new JPanel();
                this.details_pane.setComponentOrientation(Dictionary.getOrientation());
                JLabel jLabel = new JLabel(Dictionary.get(BaseIndexManager.this.nip_source_label_key));
                jLabel.setComponentOrientation(Dictionary.getOrientation());
                this.source_list = new CheckList(false);
                this.source_list.setListData(arrayList);
                this.source_list.setToolTipText(Dictionary.get(BaseIndexManager.this.nip_source_tooltip_key));
                this.source_list.addListSelectionListener(new SourceListListener());
                this.extra_pane = new JPanel();
                this.extra_pane.setComponentOrientation(Dictionary.getOrientation());
                JPanel jPanel = new JPanel();
                JLabel jLabel2 = new JLabel(Dictionary.get(BaseIndexManager.this.nip_custom_label_key));
                jLabel2.setComponentOrientation(Dictionary.getOrientation());
                this.custom_field = new JTextField();
                this.custom_field.setComponentOrientation(Dictionary.getOrientation());
                this.custom_field.setCaretPosition(0);
                this.custom_field.setToolTipText(Dictionary.get(BaseIndexManager.this.nip_custom_tooltip_key));
                this.button_pane = new JPanel();
                this.button_pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.button_pane.setComponentOrientation(Dictionary.getOrientation());
                if (this.editing) {
                    this.button_pane.setLayout(new GridLayout(0, 2, 5, 0));
                } else {
                    this.button_pane.setLayout(new GridLayout(0, 3, 5, 0));
                }
                if (index != null) {
                    this.add_or_replace_button = new GLIButton(Dictionary.get(BaseIndexManager.this.nip_replace_index_button_key), Dictionary.get(BaseIndexManager.this.nip_replace_index_tooltip_key));
                    this.add_or_replace_button.addActionListener(new ReplaceIndexListener());
                } else {
                    this.add_or_replace_button = new GLIButton(Dictionary.get(BaseIndexManager.this.nip_add_index_button_key), Dictionary.get(BaseIndexManager.this.nip_add_index_tooltip_key));
                    this.add_or_replace_button.addActionListener(new AddIndexListener());
                    this.add_all_button = new GLIButton(Dictionary.get(BaseIndexManager.this.nip_add_all_index_button_key), Dictionary.get(BaseIndexManager.this.nip_add_all_index_tooltip_key));
                    this.add_all_button.addActionListener(new AddAllActionListener());
                }
                this.add_or_replace_button.addActionListener(CollectionDesignManager.buildcol_change_listener);
                this.add_or_replace_button.setEnabled(false);
                this.button_pane.add(this.add_or_replace_button);
                if (!this.editing) {
                    this.button_pane.add(this.add_all_button);
                }
                this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel"));
                this.cancel_button.setEnabled(true);
                this.cancel_button.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        NewIndexPrompt.this.new_index_prompt.dispose();
                    }
                });
                this.button_pane.add(this.cancel_button);
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jLabel2, "After");
                jPanel.add((Component)this.custom_field, "Center");
                this.extra_pane.setLayout(new GridLayout(0, 1, 5, 5));
                this.extra_pane.add(jPanel);
                this.details_pane.setLayout(new BorderLayout(10, 10));
                this.details_pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                this.details_pane.add((Component)new JScrollPane(this.source_list), "Center");
                this.details_pane.add((Component)this.extra_pane, "South");
                if (index != null) {
                    ArrayList arrayList2 = index.getSources();
                    this.source_list.setTickedObjects(arrayList2.toArray());
                    this.source_list.setEnabled(true);
                    this.custom_field.setText(this.getCustomItemsFromSources(arrayList2));
                }
                this.custom_field.getDocument().addDocumentListener(new CustomFieldListener());
                this.content_pane.setLayout(new BorderLayout());
                this.content_pane.add((Component)jLabel, "North");
                this.content_pane.add((Component)this.details_pane, "Center");
                this.content_pane.add((Component)this.button_pane, "South");
            }

            protected Index generateNewIndex() {
                Index index = null;
                String string = this.custom_field.getText();
                if (!this.source_list.isNothingTicked() || !string.equals("")) {
                    ArrayList arrayList = this.source_list.getTicked();
                    this.addCustomItemsToSources(arrayList, string);
                    index = BaseIndexManager.this.createIndex(arrayList);
                }
                return index;
            }

            protected void addCustomItemsToSources(ArrayList arrayList, String string) {
                if (!string.equals("")) {
                    String[] stringArray = string.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        arrayList.add(stringArray[i]);
                    }
                }
            }

            protected String getCustomItemsFromSources(ArrayList arrayList) {
                ArrayList arrayList2 = this.source_list.getAll();
                String string = "";
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e = arrayList.get(i);
                    if (arrayList2.contains(e)) continue;
                    string = string + e + ",";
                }
                return string;
            }

            protected void validateAddOrReplaceButton() {
                Index index = this.generateNewIndex();
                if (index == null || BaseIndexManager.this.index_model.contains(index)) {
                    this.add_or_replace_button.setEnabled(false);
                } else {
                    this.add_or_replace_button.setEnabled(true);
                }
                if (!this.editing) {
                    if (this.source_list.isEnabled() && this.source_list.numTicked() > 1) {
                        this.add_all_button.setEnabled(true);
                    } else {
                        this.add_all_button.setEnabled(false);
                    }
                }
            }

            protected SearchMeta generateSearchMeta(Index index) {
                SearchMeta searchMeta = new SearchMeta(index.getID(), index.getType());
                if (this.use_macro_as_display_name(index.getID())) {
                    searchMeta.setValue(this.get_macro_name(index.getID()));
                } else {
                    searchMeta.setValue(index.getID());
                }
                return searchMeta;
            }

            protected boolean use_macro_as_display_name(String string) {
                if (string.indexOf(":") != -1) {
                    string = string.substring(string.indexOf(":") + 1);
                }
                String string2 = null;
                String[] stringArray = string.split(",");
                for (int i = 0; i < stringArray.length; ++i) {
                    String string3 = stringArray[i];
                    if (string3.indexOf(".") != -1) {
                        string3 = string3.substring(string3.indexOf(".") + 1);
                    }
                    if (string2 == null) {
                        string2 = string3;
                        continue;
                    }
                    if (string2.equals(string3)) continue;
                    return false;
                }
                return (string2 = string2.toLowerCase()).equals("text") || string2.equals("title") || string2.equals("creator") || string2.equals("subject") || string2.equals("description") || string2.equals("publisher") || string2.equals("contributor") || string2.equals("date") || string2.equals("type") || string2.equals("format") || string2.equals("identifier") || string2.equals("source") || string2.equals("language") || string2.equals("relation") || string2.equals("coverage") || string2.equals("rights");
            }

            protected String get_macro_name(String string) {
                if (string.indexOf(":") != -1) {
                    string = string.substring(string.indexOf(":") + 1);
                }
                if (string.indexOf(",") != -1) {
                    string = string.substring(0, string.indexOf(","));
                }
                if (string.indexOf(".") != -1) {
                    string = string.substring(string.indexOf(".") + 1);
                }
                return "_label" + string + "_";
            }

            protected class ReplaceIndexListener
            implements ActionListener {
                protected ReplaceIndexListener() {
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Index index = NewIndexPrompt.this.generateNewIndex();
                    if (index != null) {
                        SearchMeta searchMeta = NewIndexPrompt.this.generateSearchMeta(index);
                        BaseIndexManager.this.replaceIndex((Index)IndexControl.this.index_list.getSelectedValue(), index, searchMeta);
                        IndexControl.this.index_list.setSelectedValue(index, true);
                    }
                    NewIndexPrompt.this.new_index_prompt.dispose();
                }
            }

            protected class CustomFieldListener
            implements DocumentListener {
                protected CustomFieldListener() {
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    NewIndexPrompt.this.validateAddOrReplaceButton();
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    NewIndexPrompt.this.validateAddOrReplaceButton();
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    NewIndexPrompt.this.validateAddOrReplaceButton();
                }
            }

            protected class SourceListListener
            implements ListSelectionListener {
                protected SourceListListener() {
                }

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    if (listSelectionEvent.getValueIsAdjusting()) {
                        return;
                    }
                    NewIndexPrompt.this.validateAddOrReplaceButton();
                }
            }

            private class AddAllActionListener
            implements ActionListener {
                private AddAllActionListener() {
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    ArrayList arrayList = NewIndexPrompt.this.source_list.getTicked();
                    ArrayList arrayList2 = new ArrayList();
                    for (int i = 0; i < arrayList.size(); ++i) {
                        Object e = arrayList.get(i);
                        arrayList2.clear();
                        arrayList2.add(e);
                        Index index = BaseIndexManager.this.createIndex(arrayList2);
                        if (!BaseIndexManager.this.index_model.contains(index)) {
                            SearchMeta searchMeta = NewIndexPrompt.this.generateSearchMeta(index);
                            BaseIndexManager.this.addIndex(index, searchMeta);
                        }
                        e = null;
                        index = null;
                    }
                    arrayList2 = null;
                    NewIndexPrompt.this.new_index_prompt.dispose();
                }
            }

            protected class AddIndexListener
            implements ActionListener {
                protected AddIndexListener() {
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Index index = NewIndexPrompt.this.generateNewIndex();
                    if (index != null) {
                        SearchMeta searchMeta = NewIndexPrompt.this.generateSearchMeta(index);
                        BaseIndexManager.this.addIndex(index, searchMeta);
                        IndexControl.this.index_list.setSelectedValue(index, true);
                    }
                    NewIndexPrompt.this.new_index_prompt.dispose();
                }
            }
        }

        protected class SetDefaultListener
        implements ActionListener {
            protected SetDefaultListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Index index = (Index)IndexControl.this.index_list.getSelectedValue();
                if (index != null) {
                    BaseIndexManager.this.setDefault(index);
                    IndexControl.this.index_list.setSelectedValue(index, true);
                }
                IndexControl.this.set_default_button.setEnabled(false);
            }
        }

        protected class MoveListener
        implements ActionListener {
            protected boolean move_up;

            public MoveListener(boolean bl) {
                this.move_up = bl;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Index index = (Index)IndexControl.this.index_list.getSelectedValue();
                if (index != null) {
                    BaseIndexManager.this.moveIndex(index, this.move_up);
                    IndexControl.this.index_list.setSelectedValue(index, true);
                    index = null;
                }
            }
        }

        protected class RemoveIndexListener
        implements ActionListener {
            protected RemoveIndexListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = IndexControl.this.index_list.getSelectedIndex();
                if (n2 != -1) {
                    BaseIndexManager.this.removeIndex((Index)IndexControl.this.index_list.getSelectedValue());
                }
                if (n2 == (n = IndexControl.this.index_list.getModel().getSize())) {
                    --n2;
                }
                IndexControl.this.index_list.setSelectedIndex(n2);
            }
        }

        protected class EditIndexListener
        implements ActionListener {
            protected EditIndexListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Index index = (Index)IndexControl.this.index_list.getSelectedValue();
                NewIndexPrompt newIndexPrompt = IndexControl.this.createNewIndexPrompt(BaseIndexManager.this.build_type, index);
                newIndexPrompt.destroy();
            }
        }

        protected class NewIndexListener
        implements ActionListener {
            protected NewIndexListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewIndexPrompt newIndexPrompt = IndexControl.this.createNewIndexPrompt(BaseIndexManager.this.build_type, null);
                newIndexPrompt.destroy();
            }
        }

        protected class IndexListRenderer
        extends DefaultListCellRenderer {
            protected IndexListRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (BaseIndexManager.this.default_index != null && BaseIndexManager.this.default_index.equals(object)) {
                    jLabel.setText(jLabel.getText() + " " + Dictionary.get(BaseIndexManager.this.default_indicator_key));
                }
                return jLabel;
            }
        }

        protected class IndexListListener
        implements ListSelectionListener {
            protected IndexListListener() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                IndexControl.this.set_default_button.setEnabled(true);
                Object e = IndexControl.this.index_list.getSelectedValue();
                if (e == null) {
                    IndexControl.this.move_down_button.setEnabled(false);
                    IndexControl.this.move_up_button.setEnabled(false);
                    IndexControl.this.remove_button.setEnabled(false);
                    IndexControl.this.edit_button.setEnabled(false);
                    IndexControl.this.set_default_button.setEnabled(false);
                    return;
                }
                IndexControl.this.remove_button.setEnabled(true);
                IndexControl.this.edit_button.setEnabled(true);
                IndexControl.this.set_default_button.setEnabled(BaseIndexManager.this.default_index == null || !BaseIndexManager.this.default_index.equals(e));
                int n = IndexControl.this.index_list.getSelectedIndex();
                int n2 = IndexControl.this.index_list.getModel().getSize();
                IndexControl.this.move_up_button.setEnabled(n > 0);
                IndexControl.this.move_down_button.setEnabled(n < n2 - 1);
            }
        }

        protected class ClickListener
        extends MouseAdapter {
            protected ClickListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2 && !IndexControl.this.index_list.isSelectionEmpty()) {
                    Index index = (Index)IndexControl.this.index_list.getSelectedValue();
                    NewIndexPrompt newIndexPrompt = IndexControl.this.createNewIndexPrompt(BaseIndexManager.this.build_type, index);
                    newIndexPrompt.destroy();
                }
            }
        }
    }
}

