/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.io.BufferedReader;
import java.util.StringTokenizer;
import org.greenstone.gatherer.DebugStream;

public class CommandTokenizer {
    public static final int BRACKET_ENCLOSED = 0;
    public static final int DOUBLE_QUOTE_ENCLOSED = 1;
    public static final int NORMAL = 2;
    public static final int QUOTE_ENCLOSED = 3;
    private BufferedReader in_stream;
    private int count = -1;
    private StringTokenizer internal_tokenizer;
    private boolean strip_quotes = true;

    public CommandTokenizer(String string) {
        this.internal_tokenizer = new StringTokenizer(string);
        this.in_stream = null;
    }

    public CommandTokenizer(String string, BufferedReader bufferedReader) {
        this.internal_tokenizer = new StringTokenizer(string);
        this.in_stream = bufferedReader;
    }

    public CommandTokenizer(String string, BufferedReader bufferedReader, boolean bl) {
        this.internal_tokenizer = new StringTokenizer(string);
        this.in_stream = bufferedReader;
        this.strip_quotes = bl;
    }

    public int countTokens() {
        if (this.count == 0 && this.internal_tokenizer.countTokens() > 1) {
            return 1;
        }
        if (this.count == -1) {
            this.count = this.internal_tokenizer.countTokens();
        }
        return this.count;
    }

    public boolean hasMoreTokens() {
        return this.internal_tokenizer.hasMoreTokens();
    }

    public String nextToken() {
        String string = null;
        if (this.internal_tokenizer.hasMoreTokens()) {
            StringBuffer stringBuffer = new StringBuffer(this.internal_tokenizer.nextToken());
            switch (stringBuffer.charAt(0)) {
                case '\"': {
                    string = this.buildToken(stringBuffer, '\"', this.strip_quotes);
                    break;
                }
                case '\'': {
                    string = this.buildToken(stringBuffer, '\'', this.strip_quotes);
                    break;
                }
                case '[': {
                    string = this.buildToken(stringBuffer, ']', false);
                    break;
                }
                default: {
                    string = stringBuffer.toString();
                }
            }
            stringBuffer = null;
        }
        if (this.count > 0) {
            --this.count;
        }
        return string;
    }

    private String buildToken(StringBuffer stringBuffer, char c, boolean bl) {
        while (stringBuffer.length() == 1 || stringBuffer.charAt(stringBuffer.length() - 1) != c || stringBuffer.length() > 3 && stringBuffer.charAt(stringBuffer.length() - 2) == '\\') {
            try {
                if (this.internal_tokenizer.hasMoreTokens()) {
                    stringBuffer.append(' ');
                    stringBuffer.append(this.internal_tokenizer.nextToken());
                    continue;
                }
                if (this.in_stream != null) {
                    String string = null;
                    while (!this.internal_tokenizer.hasMoreTokens() && (string = this.in_stream.readLine()) != null) {
                        this.internal_tokenizer = new StringTokenizer(string);
                        stringBuffer.append('\n');
                    }
                    string = null;
                    if (this.internal_tokenizer.hasMoreTokens()) {
                        if (stringBuffer.charAt(stringBuffer.length() - 1) != '\n') {
                            stringBuffer.append(' ');
                        }
                        stringBuffer.append(this.internal_tokenizer.nextToken());
                        continue;
                    }
                    if (bl) {
                        return stringBuffer.substring(1);
                    }
                    stringBuffer.append(c);
                    return stringBuffer.toString();
                }
                if (bl) {
                    return stringBuffer.substring(1);
                }
                stringBuffer.append(c);
                return stringBuffer.toString();
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
                if (bl) {
                    return stringBuffer.substring(1);
                }
                stringBuffer.append(c);
                return stringBuffer.toString();
            }
        }
        if (stringBuffer.length() >= 2 && bl) {
            return stringBuffer.substring(1, stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

