/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.CollectionMeta;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.EmailField;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.GUIUtils;
import org.greenstone.gatherer.gui.TestingPreparation;

public class GeneralManager {
    private Control controls;

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    public void loseFocus() {
    }

    public void gainFocus() {
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new GeneralControl();
        }
        return this.controls;
    }

    public void modeChanged(int n) {
    }

    private class GeneralControl
    extends JPanel
    implements Control {
        private boolean ready = false;
        private CollectionMeta collection_extra_collectionmeta;
        private CollectionMeta collection_name_collectionmeta;
        private CollectionMeta creator_collectionmeta;
        private CollectionMeta icon_collection_collectionmeta;
        private CollectionMeta icon_collection_small_collectionmeta;
        private CollectionMeta maintainer_collectionmeta;
        private CollectionMeta public_collectionmeta;
        private EmailField creator_emailfield;
        private EmailField maintainer_emailfield;
        private JButton browse_about_icon_button;
        private JButton browse_home_icon_button;
        private JCheckBox public_checkbox;
        private JLabel creator_label;
        private JLabel description_label;
        private JLabel icon_label;
        private JLabel maintainer_label;
        private JLabel name_label;
        private JLabel small_icon_label;
        private JTextField icon_textfield;
        private JTextField name_textfield;
        private JTextField small_icon_textfield;
        private JTextArea description_textarea;

        public GeneralControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            this.public_collectionmeta = new CollectionMeta(CollectionDesignManager.collect_config.getPublic());
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.General", "generalsettings");
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            this.creator_label = new JLabel(Dictionary.get("CDM.General.Email.Creator"));
            this.creator_label.setComponentOrientation(Dictionary.getOrientation());
            this.creator_emailfield = new EmailField(Configuration.getColor("coloring.error_background", false));
            this.creator_emailfield.setToolTipText(Dictionary.get("CDM.General.Email.Creator_Tooltip"));
            this.maintainer_label = new JLabel(Dictionary.get("CDM.General.Email.Maintainer"));
            this.maintainer_label.setComponentOrientation(Dictionary.getOrientation());
            this.maintainer_emailfield = new EmailField(Configuration.getColor("coloring.error_background", false));
            this.maintainer_emailfield.setToolTipText(Dictionary.get("CDM.General.Email.Maintainer_Tooltip"));
            this.name_label = new JLabel(Dictionary.get("CDM.General.Collection_Name"));
            this.name_label.setComponentOrientation(Dictionary.getOrientation());
            this.name_textfield = new JTextField();
            this.name_textfield.setComponentOrientation(Dictionary.getOrientation());
            this.name_textfield.setToolTipText(Dictionary.get("CDM.General.Collection_Name_Tooltip"));
            JLabel jLabel = new JLabel(Dictionary.get("NewCollectionPrompt.Collection_Name"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            JTextField jTextField = new JTextField(CollectionManager.getLoadedCollectionName());
            jTextField.setComponentOrientation(Dictionary.getOrientation());
            jTextField.setEditable(false);
            jTextField.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            JPanel jPanel4 = new JPanel();
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            this.icon_label = new JLabel(Dictionary.get("CDM.General.Icon_Collection"));
            this.icon_label.setComponentOrientation(Dictionary.getOrientation());
            this.icon_textfield = new JTextField();
            this.icon_textfield.setComponentOrientation(Dictionary.getOrientation());
            this.icon_textfield.setToolTipText(Dictionary.get("CDM.General.Icon_Collection_Tooltip"));
            this.browse_about_icon_button = new GLIButton(Dictionary.get("General.Browse"));
            JPanel jPanel5 = new JPanel();
            jPanel5.setComponentOrientation(Dictionary.getOrientation());
            this.small_icon_label = new JLabel(Dictionary.get("CDM.General.Icon_Collection_Small"));
            this.small_icon_label.setComponentOrientation(Dictionary.getOrientation());
            this.small_icon_textfield = new JTextField();
            this.small_icon_textfield.setComponentOrientation(Dictionary.getOrientation());
            this.small_icon_textfield.setToolTipText(Dictionary.get("CDM.General.Icon_Collection_Small_Tooltip"));
            this.browse_home_icon_button = new GLIButton(Dictionary.get("General.Browse"));
            JPanel jPanel6 = new JPanel();
            jPanel6.setComponentOrientation(Dictionary.getOrientation());
            this.public_checkbox = new JCheckBox(Dictionary.get("CDM.General.Access"), this.public_collectionmeta.getValue(true).equals("true"));
            this.public_checkbox.setComponentOrientation(Dictionary.getOrientation());
            JPanel jPanel7 = new JPanel();
            jPanel7.setComponentOrientation(Dictionary.getOrientation());
            this.description_label = new JLabel(Dictionary.get("CDM.General.Collection_Extra"));
            this.description_label.setComponentOrientation(Dictionary.getOrientation());
            this.description_textarea = new JTextArea();
            this.description_textarea.setComponentOrientation(Dictionary.getOrientation());
            this.description_textarea.setBackground(Configuration.getColor("coloring.editable_background", false));
            this.description_textarea.setToolTipText(Dictionary.get("CDM.General.Collection_Extra_Tooltip"));
            BrowseListener browseListener = new BrowseListener("_httpprefix_/collect/<col_name>/images/");
            this.browse_about_icon_button.addActionListener(browseListener);
            this.browse_home_icon_button.addActionListener(browseListener);
            browseListener = null;
            this.public_checkbox.addActionListener(CollectionDesignManager.change_listener);
            this.creator_emailfield.getDocument().addDocumentListener(CollectionDesignManager.change_listener);
            this.description_textarea.getDocument().addDocumentListener(CollectionDesignManager.change_listener);
            this.icon_textfield.getDocument().addDocumentListener(CollectionDesignManager.change_listener);
            this.maintainer_emailfield.getDocument().addDocumentListener(CollectionDesignManager.change_listener);
            this.name_textfield.getDocument().addDocumentListener(CollectionDesignManager.change_listener);
            this.name_textfield.getDocument().addDocumentListener(new CollectionTitleUpdater());
            this.small_icon_textfield.getDocument().addDocumentListener(CollectionDesignManager.change_listener);
            jPanel3.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel3.setLayout(new BorderLayout(5, 2));
            JPanel jPanel8 = new JPanel();
            jPanel8.setComponentOrientation(Dictionary.getOrientation());
            jPanel8.setLayout(new GridLayout(6, 1));
            JPanel jPanel9 = new JPanel();
            jPanel9.setComponentOrientation(Dictionary.getOrientation());
            jPanel9.setLayout(new GridLayout(6, 1));
            jPanel8.add(this.creator_label);
            jPanel9.add(this.creator_emailfield);
            jPanel8.add(this.maintainer_label);
            jPanel9.add(this.maintainer_emailfield);
            jPanel8.add(this.name_label);
            jPanel9.add(this.name_textfield);
            jPanel8.add(jLabel);
            jPanel9.add(jTextField);
            jPanel8.add(this.icon_label);
            jPanel9.add(jPanel4);
            jPanel8.add(this.small_icon_label);
            jPanel9.add(jPanel5);
            jPanel3.add((Component)jPanel8, "Before");
            jPanel3.add((Component)jPanel9, "Center");
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)this.icon_textfield, "Center");
            jPanel4.add((Component)this.browse_about_icon_button, "After");
            jPanel5.setLayout(new BorderLayout());
            jPanel5.add((Component)this.small_icon_textfield, "Center");
            jPanel5.add((Component)this.browse_home_icon_button, "After");
            jPanel6.setLayout(new GridLayout(1, 1, 5, 2));
            jPanel6.add(this.public_checkbox);
            jPanel7.setLayout(new BorderLayout());
            jPanel7.add((Component)this.description_label, "North");
            jPanel7.add((Component)new JScrollPane(this.description_textarea), "Center");
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)jPanel3, "North");
            jPanel2.add((Component)jPanel6, "Center");
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jPanel2, "North");
            jPanel.add((Component)jPanel7, "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jPanel, "Center");
            TestingPreparation.setIndividualSubcomponentNames(this, this.browse_about_icon_button, this.browse_home_icon_button);
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
            this.collection_extra_collectionmeta = CollectionDesignManager.collectionmeta_manager.getMetadatum("collectionextra");
            this.collection_name_collectionmeta = CollectionDesignManager.collectionmeta_manager.getMetadatum("collectionname");
            this.creator_collectionmeta = new CollectionMeta(CollectionDesignManager.collect_config.getCreator());
            this.icon_collection_collectionmeta = CollectionDesignManager.collectionmeta_manager.getMetadatum("iconcollection");
            this.icon_collection_small_collectionmeta = CollectionDesignManager.collectionmeta_manager.getMetadatum("iconcollectionsmall");
            this.maintainer_collectionmeta = new CollectionMeta(CollectionDesignManager.collect_config.getMaintainer());
            this.creator_emailfield.setText(this.creator_collectionmeta.getValue(true));
            this.creator_emailfield.setCaretPosition(0);
            this.description_textarea.setText(this.collection_extra_collectionmeta.getValue(true));
            this.description_textarea.setCaretPosition(0);
            this.icon_textfield.setText(this.icon_collection_collectionmeta.getValue(true));
            this.icon_textfield.setCaretPosition(0);
            this.maintainer_emailfield.setText(this.maintainer_collectionmeta.getValue(true));
            this.maintainer_emailfield.setCaretPosition(0);
            this.name_textfield.setText(this.collection_name_collectionmeta.getValue(true));
            this.name_textfield.setCaretPosition(0);
            this.small_icon_textfield.setText(this.icon_collection_small_collectionmeta.getValue(true));
            this.small_icon_textfield.setCaretPosition(0);
            this.public_checkbox.setSelected(this.public_collectionmeta.getValue(true).equals("true"));
            this.ready = true;
        }

        @Override
        public void loseFocus() {
            if (!this.ready) {
                return;
            }
            boolean bl = true;
            this.public_collectionmeta.setValue(this.public_checkbox.isSelected() ? "true" : "false");
            String string = this.creator_emailfield.getText();
            this.creator_collectionmeta.setValue(string);
            this.collection_extra_collectionmeta.setValue(this.description_textarea.getText(), bl);
            this.icon_collection_collectionmeta.setValue(this.icon_textfield.getText());
            this.maintainer_collectionmeta.setValue(this.maintainer_emailfield.getText());
            this.icon_collection_small_collectionmeta.setValue(this.small_icon_textfield.getText());
            this.collection_name_collectionmeta.setValue(this.name_textfield.getText());
        }

        private class CollectionTitleUpdater
        implements DocumentListener {
            private CollectionTitleUpdater() {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.setTitle();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.setTitle();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.setTitle();
            }

            private void setTitle() {
                String string = GeneralControl.this.name_textfield.getText();
                String string2 = CollectionManager.getLoadedCollectionName(true);
                Gatherer.g_man.setTitle(string, string2);
                GeneralControl.this.collection_name_collectionmeta.setValue(string);
                string = null;
                string2 = null;
            }
        }

        private class BrowseListener
        implements ActionListener {
            private String prefix;

            public BrowseListener(String string) {
                this.prefix = string.replaceAll("<col_name>", CollectionManager.getLoadedCollectionName());
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(CollectionManager.getLoadedCollectionImagesDirectoryPath());
                if (!file.exists()) {
                    file.mkdirs();
                }
                JFileChooser jFileChooser = new JFileChooser(file);
                jFileChooser.setAcceptAllFileFilterUsed(false);
                jFileChooser.setDialogTitle(Dictionary.get("CDM.General.Browser_Title"));
                jFileChooser.setFileFilter(new ImageFilter());
                jFileChooser.setSize(400, 300);
                GUIUtils.disableRename(jFileChooser);
                int n = jFileChooser.showOpenDialog(Gatherer.g_man);
                if (n == 0) {
                    Object object;
                    File file2 = jFileChooser.getSelectedFile();
                    if (!file2.getParentFile().equals(file)) {
                        try {
                            object = new File(file, file2.getName());
                            Gatherer.f_man.getQueue().copyFile(file2, (File)object, true);
                            if (Gatherer.isGsdlRemote) {
                                Gatherer.remoteGreenstoneServer.uploadCollectionFile(CollectionManager.getLoadedCollectionName(), (File)object);
                            }
                        }
                        catch (Exception exception) {
                            DebugStream.printStackTrace(exception);
                            String[] stringArray = new String[]{file2.getAbsolutePath(), file.getAbsolutePath()};
                            JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("CDM.General.Image_Copy_Failed", stringArray), Dictionary.get("General.Error"), 0);
                            return;
                        }
                    }
                    object = this.prefix + file2.getName();
                    if (Gatherer.GS3) {
                        object = file2.getName();
                    }
                    if (actionEvent.getSource() == GeneralControl.this.browse_about_icon_button) {
                        GeneralControl.this.icon_textfield.setText((String)object);
                        GeneralControl.this.icon_collection_collectionmeta.setValue(GeneralControl.this.icon_textfield.getText());
                    } else {
                        GeneralControl.this.small_icon_textfield.setText((String)object);
                        GeneralControl.this.icon_collection_small_collectionmeta.setValue(GeneralControl.this.small_icon_textfield.getText());
                    }
                    object = null;
                }
            }

            private class ImageFilter
            extends FileFilter {
                private Pattern pattern = Pattern.compile(".*\\.(gif|png|jpe?g)");

                @Override
                public boolean accept(File file) {
                    String string = file.getName().toLowerCase();
                    Matcher matcher = this.pattern.matcher(string);
                    return file.isDirectory() || matcher.matches();
                }

                @Override
                public String getDescription() {
                    return Dictionary.get("CDM.General.Image_Filter");
                }
            }
        }
    }
}

