/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.util.ArrayList;
import org.greenstone.gatherer.cdm.CollectionConfiguration;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.DOMProxyListEntry;
import org.w3c.dom.Element;

public class Language
implements Comparable,
DOMProxyListEntry {
    private Element element = null;
    private String code = null;
    private String name = null;

    public Language() {
    }

    public Language(Element element) {
        this.element = element;
    }

    public Language(String string) {
        this.code = string;
        this.element = CollectionConfiguration.createElement("Language");
        this.element.setAttribute("name", string);
        this.element.setAttribute("assigned", "true");
    }

    public Language(ArrayList arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!bl) {
                stringBuffer.append(",");
            } else {
                bl = false;
            }
            stringBuffer.append(arrayList.get(i));
        }
        this.code = stringBuffer.toString();
        this.element = CollectionConfiguration.createElement("Language");
        this.element.setAttribute("name", this.code);
        this.element.setAttribute("assigned", "true");
    }

    public int compareTo(Object object) {
        return this.toString().compareTo(object.toString());
    }

    @Override
    public DOMProxyListEntry create(Element element) {
        return new Language(element);
    }

    public boolean equals(Object object) {
        if (object instanceof Language) {
            return this.getCode().equals(((Language)object).getCode());
        }
        if (object instanceof String) {
            return this.getCode().equals((String)object);
        }
        return false;
    }

    public String getCode() {
        if (this.code == null && this.element != null) {
            this.code = this.element.getAttribute("name");
        }
        return this.code;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    public String getName() {
        if (this.name == null) {
            String string = this.getCode();
            String[] stringArray = string.split(",");
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = true;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!bl) {
                    stringBuffer.append(",");
                } else {
                    bl = false;
                }
                stringBuffer.append(CollectionDesignManager.language_manager.getLanguageName(stringArray[i]));
            }
            this.name = stringBuffer.toString();
        }
        return this.name;
    }

    @Override
    public boolean isAssigned() {
        return this.element != null && this.element.getAttribute("assigned").equals("true");
    }

    @Override
    public void setAssigned(boolean bl) {
        if (this.element != null) {
            this.element.setAttribute("assigned", bl ? "true" : "false");
        }
    }

    public void setCode(String string) {
        this.code = string;
        if (this.element != null) {
            this.element.setAttribute("name", string);
        }
        this.name = null;
    }

    @Override
    public void setElement(Element element) {
        this.element = element;
        this.code = null;
        this.name = null;
    }

    public String toString() {
        return this.getName();
    }
}

