/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.gui.GLIButton;

public class MacrosManager {
    private Control controls;

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
    }

    public void loseFocus() {
    }

    public void gainFocus() {
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new MacrosControl();
        }
        return this.controls;
    }

    public void modeChanged(int n) {
    }

    private class MacrosControl
    extends JPanel
    implements Control,
    WindowFocusListener {
        JTextArea macros_textarea = null;
        JButton undo_button = null;
        JButton redo_button = null;
        private final UndoManager undo = new UndoManager();
        private boolean macros_changed = false;

        public MacrosControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.Macros", "collectionspecificmacros");
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jPanel.setLayout(new BorderLayout());
            this.macros_textarea = new JTextArea();
            this.macros_textarea.setComponentOrientation(Dictionary.getOrientation());
            this.macros_textarea.setBackground(Configuration.getColor("coloring.editable_background", false));
            this.macros_textarea.setLineWrap(false);
            this.macros_textarea.setWrapStyleWord(false);
            this.macros_textarea.setToolTipText(Dictionary.get("CDM.MacrosManager.Editor_Tooltip"));
            this.readMacroFile();
            this.macros_textarea.getDocument().addDocumentListener(new EditorListener());
            this.macros_textarea.getDocument().addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    MacrosControl.this.undo.addEdit(undoableEditEvent.getEdit());
                }
            });
            this.macros_textarea.setCaretPosition(0);
            JPanel jPanel2 = new JPanel();
            jPanel2.setComponentOrientation(Dictionary.getOrientation());
            jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            jPanel2.setLayout(new BorderLayout());
            jPanel2.add((Component)new JScrollPane(this.macros_textarea), "Center");
            this.undo_button = new GLIButton(Dictionary.get("General.Undo"), Dictionary.get("General.Undo_Tooltip"));
            this.undo_button.setEnabled(false);
            this.undo_button.addActionListener(new UndoListener());
            this.redo_button = new GLIButton(Dictionary.get("General.Redo"), Dictionary.get("General.Redo_Tooltip"));
            this.redo_button.setEnabled(false);
            this.redo_button.addActionListener(new RedoListener());
            JPanel jPanel3 = new JPanel();
            jPanel3.setComponentOrientation(Dictionary.getOrientation());
            jPanel3.setLayout(new GridLayout(1, 2));
            jPanel3.add(this.undo_button);
            jPanel3.add(this.redo_button);
            jPanel.add((Component)jPanel2, "Center");
            jPanel.add((Component)jPanel3, "South");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jPanel, "Center");
            Gatherer.g_man.addWindowFocusListener(this);
        }

        @Override
        public void destroy() {
        }

        @Override
        public void loseFocus() {
            if (this.macros_changed) {
                this.writeMacroFile();
                this.macros_changed = false;
            }
        }

        @Override
        public void gainFocus() {
            this.macros_textarea.grabFocus();
        }

        @Override
        public void windowGainedFocus(WindowEvent windowEvent) {
        }

        @Override
        public void windowLostFocus(WindowEvent windowEvent) {
            if (this.macros_changed) {
                this.writeMacroFile();
                this.macros_changed = false;
            }
        }

        private void readMacroFile() {
            this.macros_textarea.setText("");
            File file = new File(CollectionManager.getLoadedCollectionMacrosDirectoryPath() + "extra.dm");
            if (file.exists()) {
                try {
                    String string;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                    while ((string = bufferedReader.readLine()) != null) {
                        this.macros_textarea.append(string + "\n");
                    }
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    DebugStream.printStackTrace(exception);
                }
            }
        }

        private void writeMacroFile() {
            File file = new File(CollectionManager.getLoadedCollectionMacrosDirectoryPath() + "extra.dm");
            try {
                Object object;
                if (!file.exists()) {
                    object = file.getParentFile();
                    ((File)object).mkdirs();
                    file.createNewFile();
                }
                object = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                String string = this.macros_textarea.getText();
                ((BufferedWriter)object).write(string, 0, string.length());
                ((BufferedWriter)object).newLine();
                ((BufferedWriter)object).flush();
                ((BufferedWriter)object).close();
                if (Gatherer.isGsdlRemote) {
                    Gatherer.remoteGreenstoneServer.uploadCollectionFile(CollectionManager.getLoadedCollectionName(), file);
                }
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
            }
        }

        private class RedoListener
        implements ActionListener {
            private RedoListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (MacrosControl.this.undo.canRedo()) {
                        int n = MacrosControl.this.macros_textarea.getCaretPosition();
                        MacrosControl.this.undo.redo();
                        MacrosControl.this.macros_textarea.setCaretPosition(n + 1);
                        MacrosControl.this.macros_textarea.grabFocus();
                    }
                    if (!MacrosControl.this.undo.canRedo()) {
                        MacrosControl.this.redo_button.setEnabled(false);
                    } else {
                        MacrosControl.this.redo_button.setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    DebugStream.printStackTrace(exception);
                }
            }
        }

        private class UndoListener
        implements ActionListener {
            private UndoListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (MacrosControl.this.undo.canUndo()) {
                        int n = MacrosControl.this.macros_textarea.getCaretPosition();
                        MacrosControl.this.undo.undo();
                        MacrosControl.this.macros_textarea.setCaretPosition(n - 1);
                        MacrosControl.this.macros_textarea.grabFocus();
                        MacrosControl.this.redo_button.setEnabled(true);
                    }
                    if (!MacrosControl.this.undo.canUndo()) {
                        MacrosControl.this.undo_button.setEnabled(false);
                    } else {
                        MacrosControl.this.undo_button.setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    DebugStream.printStackTrace(exception);
                }
            }
        }

        private class EditorListener
        implements DocumentListener {
            private EditorListener() {
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                MacrosControl.this.macros_changed = true;
                MacrosControl.this.undo_button.setEnabled(true);
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                MacrosControl.this.macros_changed = true;
                MacrosControl.this.undo_button.setEnabled(true);
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                MacrosControl.this.macros_changed = true;
                MacrosControl.this.undo_button.setEnabled(true);
            }
        }
    }
}

