/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.cdm.BaseIndexManager;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.Index;
import org.greenstone.gatherer.cdm.SortField;
import org.w3c.dom.Element;

public class SortFieldManager
extends BaseIndexManager {
    private static final String NONE = "none";
    private static final String RANK = "rank";

    public SortFieldManager(Element element, String string) {
        super(element, string, "Sort", "defaultSort", new SortField());
        this.controls_title_key = "CDM.SortFieldManager.Title";
        this.new_button_tooltip_key = "CDM.SortFieldManager.New_Button_Tooltip";
        this.edit_button_tooltip_key = "CDM.SortFieldManager.Edit_Button_Tooltip";
        this.remove_button_tooltip_key = "CDM.SortFieldManager.Remove_Button_Tooltip";
        this.default_indicator_key = "CDM.SortFieldManager.Default_Sort_Indicator";
        this.set_default_tooltip_key = "CDM.SortFieldManager.Set_Default_Tooltip";
        this.nip_new_index_key = "CDM.SortFieldManager.New";
        this.nip_edit_index_key = "CDM.SortFieldManager.Edit";
        this.nip_source_label_key = "CDM.SortFieldManager.Source";
        this.nip_source_tooltip_key = "CDM.SortFieldManager.Source_Tooltip";
        this.nip_custom_label_key = "CDM.IndexManager.Custom";
        this.nip_custom_tooltip_key = "CDM.IndexManager.Custom_Tooltip";
        this.nip_add_index_button_key = "CDM.SortFieldManager.Add";
        this.nip_add_index_tooltip_key = "CDM.SortFieldManager.Add_Tooltip";
        this.nip_replace_index_button_key = "CDM.SortFieldManager.Replace";
        this.nip_replace_index_tooltip_key = "CDM.SortFieldManager.Replace_Tooltip";
        this.nip_add_all_index_button_key = "CDM.IndexManager.AddAll";
        this.nip_add_all_index_tooltip_key = "CDM.SortFieldManager.AddAll_Tooltip";
    }

    @Override
    public void buildTypeChanged(String string) {
        if (string.equals("solr") || string.equals("lucene")) {
            this.setAssigned(true);
        } else {
            this.setAssigned(false);
        }
    }

    @Override
    public Control getControls() {
        if (this.controls == null) {
            this.controls = new SortFieldControl();
        }
        return this.controls;
    }

    private class SortFieldControl
    extends BaseIndexManager.IndexControl {
        @Override
        protected BaseIndexManager.IndexControl.NewIndexPrompt createNewIndexPrompt(String string, Index index) {
            return new NewSortFieldPrompt(string, index);
        }

        protected class NewSortFieldPrompt
        extends BaseIndexManager.IndexControl.NewIndexPrompt {
            private JCheckBox none_checkbox;
            private JCheckBox rank_checkbox;

            public NewSortFieldPrompt(String string, Index index) {
                super(string, index);
            }

            @Override
            protected void generateContents(String string, Index index) {
                super.generateContents(string, index);
                this.none_checkbox = new JCheckBox(Dictionary.get("CDM.SortFieldManager.Field_None"));
                this.none_checkbox.addItemListener(new NoneRankBoxListener());
                this.none_checkbox.setComponentOrientation(Dictionary.getOrientation());
                this.none_checkbox.setToolTipText(Dictionary.get("CDM.SortFieldManager.Field_None_Tooltip"));
                this.rank_checkbox = new JCheckBox(Dictionary.get("CDM.SortFieldManager.Field_Rank"));
                this.rank_checkbox.addItemListener(new NoneRankBoxListener());
                this.rank_checkbox.setComponentOrientation(Dictionary.getOrientation());
                this.rank_checkbox.setToolTipText(Dictionary.get("CDM.SortFieldManager.Field_Rank_Tooltip"));
                if (index != null) {
                    ArrayList arrayList = index.getSources();
                    if (arrayList.contains(SortFieldManager.NONE)) {
                        this.none_checkbox.setSelected(true);
                        this.rank_checkbox.setEnabled(false);
                        this.source_list.setEnabled(false);
                        this.custom_field.setEnabled(false);
                    } else if (arrayList.contains(SortFieldManager.RANK)) {
                        this.rank_checkbox.setSelected(true);
                        this.none_checkbox.setEnabled(false);
                        this.source_list.setEnabled(false);
                        this.custom_field.setEnabled(false);
                    }
                }
                this.extra_pane.add(this.none_checkbox);
                this.extra_pane.add(this.rank_checkbox);
            }

            @Override
            protected String getCustomItemsFromSources(ArrayList arrayList) {
                ArrayList arrayList2 = this.source_list.getAll();
                String string = "";
                for (int i = 0; i < arrayList.size(); ++i) {
                    Object e = arrayList.get(i);
                    if (arrayList2.contains(e) || e.equals(SortFieldManager.RANK) || e.equals(SortFieldManager.NONE)) continue;
                    string = string + e + ",";
                }
                return string;
            }

            @Override
            protected Index generateNewIndex() {
                ArrayList arrayList;
                String string = this.custom_field.getText();
                if (this.none_checkbox.isSelected()) {
                    arrayList = new ArrayList();
                    arrayList.add(SortFieldManager.NONE);
                } else if (this.rank_checkbox.isSelected()) {
                    arrayList = new ArrayList();
                    arrayList.add(SortFieldManager.RANK);
                } else if (!this.source_list.isNothingTicked() || !string.equals("")) {
                    arrayList = this.source_list.getTicked();
                    this.addCustomItemsToSources(arrayList, string);
                } else {
                    return null;
                }
                return new SortField(arrayList);
            }

            private class NoneRankBoxListener
            implements ItemListener {
                private NoneRankBoxListener() {
                }

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (NewSortFieldPrompt.this.none_checkbox.isSelected()) {
                        NewSortFieldPrompt.this.source_list.setEnabled(false);
                        NewSortFieldPrompt.this.rank_checkbox.setEnabled(false);
                        NewSortFieldPrompt.this.custom_field.setEnabled(false);
                    } else if (NewSortFieldPrompt.this.rank_checkbox.isSelected()) {
                        NewSortFieldPrompt.this.source_list.setEnabled(false);
                        NewSortFieldPrompt.this.none_checkbox.setEnabled(false);
                        NewSortFieldPrompt.this.custom_field.setEnabled(false);
                    } else {
                        NewSortFieldPrompt.this.none_checkbox.setEnabled(true);
                        NewSortFieldPrompt.this.rank_checkbox.setEnabled(true);
                        NewSortFieldPrompt.this.source_list.setEnabled(true);
                        NewSortFieldPrompt.this.custom_field.setEnabled(true);
                    }
                    NewSortFieldPrompt.this.validateAddOrReplaceButton();
                }
            }
        }
    }
}

