/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.cdm;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Control;
import org.greenstone.gatherer.cdm.DOMProxyListModel;
import org.greenstone.gatherer.cdm.SuperCollection;
import org.greenstone.gatherer.collection.BasicCollectionConfiguration;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.gui.DesignPaneHeader;
import org.greenstone.gatherer.util.CheckList;
import org.greenstone.gatherer.util.CheckListEntry;
import org.greenstone.gatherer.util.Utility;
import org.w3c.dom.Element;

public class SuperCollectionManager
extends DOMProxyListModel {
    public static final String SUPERCOLLECTION_COMMAND = "supercollection";
    public static final String CCS_COMMAND = "ccs";
    private ArrayList collection_checklist_model = null;
    private Control controls = null;
    private DOMProxyListModel model = null;
    private String current_coll_name = null;
    private boolean superCollectionChanged = false;

    public SuperCollectionManager(Element element) {
        super(element, "Collection", new SuperCollection());
        DebugStream.println("SuperCollectionManager: " + this.getSize() + " supercollection members parsed.");
        this.model = this;
    }

    public void destroy() {
        if (this.controls != null) {
            this.controls.destroy();
            this.controls = null;
        }
        if (this.collection_checklist_model != null) {
            this.collection_checklist_model.clear();
            this.collection_checklist_model = null;
        }
    }

    private void addSuperCollection(SuperCollection superCollection) {
        if (!this.contains(superCollection)) {
            this.add(this.getSize(), superCollection);
        }
    }

    public Control getControls() {
        if (this.controls == null) {
            this.controls = new SuperCollectionControl();
        }
        return this.controls;
    }

    public SuperCollection getSuperCollection(String string) {
        SuperCollection superCollection = null;
        int n = this.getSize();
        for (int i = 0; superCollection == null && i < n; ++i) {
            SuperCollection superCollection2 = (SuperCollection)this.getElementAt(i);
            if (superCollection2.getName().equals(string)) {
                superCollection = superCollection2;
            }
            superCollection2 = null;
        }
        return superCollection;
    }

    public void modeChanged(int n) {
    }

    private void removeSuperCollection(SuperCollection superCollection) {
        if (this.contains(superCollection)) {
            this.remove(superCollection);
        }
    }

    private class SuperCollectionControl
    extends JPanel
    implements Control {
        private boolean init = true;
        private CheckList collection_checklist = null;

        SuperCollectionControl() {
            this.setComponentOrientation(Dictionary.getOrientation());
            DesignPaneHeader designPaneHeader = new DesignPaneHeader("CDM.GUI.SuperCollection", "xcollectionsearching");
            this.collection_checklist = new CheckList(false);
            this.buildModel();
            this.collection_checklist.setListData(SuperCollectionManager.this.collection_checklist_model);
            JPanel jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JScrollPane(this.collection_checklist), "Center");
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
            this.setLayout(new BorderLayout());
            this.add((Component)designPaneHeader, "North");
            this.add((Component)jPanel, "Center");
        }

        @Override
        public void destroy() {
        }

        @Override
        public void gainFocus() {
        }

        @Override
        public void loseFocus() {
            Object object;
            int n = 0;
            ArrayList arrayList = SuperCollectionManager.this.children();
            int n2 = SuperCollectionManager.this.collection_checklist_model.size();
            for (int i = 0; i < n2; ++i) {
                String string;
                object = (CheckListEntry)SuperCollectionManager.this.collection_checklist_model.get(i);
                if (!((AbstractButton)object).isSelected() || (string = ((CheckListEntry)object).getProperty()).equals(SuperCollectionManager.this.current_coll_name)) continue;
                SuperCollection superCollection = SuperCollectionManager.this.getSuperCollection(string);
                if (superCollection == null) {
                    Element element = SuperCollectionManager.this.root.getOwnerDocument().createElement("Collection");
                    superCollection = new SuperCollection(element);
                    superCollection.setName(string);
                    SuperCollectionManager.this.addSuperCollection(superCollection);
                } else {
                    arrayList.remove(superCollection);
                }
                superCollection.setAssigned(true);
                ++n;
            }
            if (n > 0) {
                SuperCollection superCollection = SuperCollectionManager.this.getSuperCollection(SuperCollectionManager.this.current_coll_name);
                if (superCollection == null) {
                    object = SuperCollectionManager.this.root.getOwnerDocument().createElement("Collection");
                    superCollection = new SuperCollection((Element)object);
                    superCollection.setName(SuperCollectionManager.this.current_coll_name);
                    SuperCollectionManager.this.addSuperCollection(superCollection);
                } else {
                    arrayList.remove(superCollection);
                }
                ((SuperCollectionManager)SuperCollectionManager.this).model.root.setAttribute("assigned", "true");
            } else {
                ((SuperCollectionManager)SuperCollectionManager.this).model.root.setAttribute("assigned", "false");
            }
            for (int i = arrayList.size(); i > 0; --i) {
                object = (SuperCollection)arrayList.get(i - 1);
                SuperCollectionManager.this.removeSuperCollection((SuperCollection)object);
            }
        }

        private void buildModel() {
            SuperCollectionManager.this.collection_checklist_model = new ArrayList();
            SuperCollectionManager.this.current_coll_name = CollectionManager.getLoadedCollectionName(true);
            File file = new File(Gatherer.getCollectDirectoryPath());
            this.add_collections_to_model(file);
        }

        private void add_collections_to_model(File file) {
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                String string = Gatherer.GS3 ? Utility.CONFIG_GS3_FILE : Utility.CONFIG_FILE;
                File file2 = new File(fileArray[i], string);
                if (!file2.exists()) continue;
                BasicCollectionConfiguration basicCollectionConfiguration = new BasicCollectionConfiguration(file2);
                if (basicCollectionConfiguration.getCollectGroup().equals("true")) {
                    this.add_collections_to_model(fileArray[i]);
                    continue;
                }
                StringBuffer stringBuffer = new StringBuffer(basicCollectionConfiguration.getName());
                stringBuffer.append(" ");
                stringBuffer.append("[");
                stringBuffer.append(basicCollectionConfiguration.getShortName());
                stringBuffer.append("]");
                String string2 = stringBuffer.toString();
                stringBuffer = null;
                String string3 = basicCollectionConfiguration.getShortName();
                if (basicCollectionConfiguration.getName().equals("**title**")) continue;
                CheckListEntry checkListEntry = new CheckListEntry((Object)string2);
                checkListEntry.setProperty(string3);
                checkListEntry.setSelected(SuperCollectionManager.this.getSuperCollection(string3) != null || string3.equals(SuperCollectionManager.this.current_coll_name));
                checkListEntry.setFixed(string3.equals(SuperCollectionManager.this.current_coll_name));
                SuperCollectionManager.this.collection_checklist_model.add(checkListEntry);
            }
        }
    }
}

