/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.collection;

import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.FullCollectionTreeNode;
import org.greenstone.gatherer.file.FileNode;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.gui.TextFileEditor;
import org.greenstone.gatherer.gui.XMLFileEditor;
import org.greenstone.gatherer.gui.tree.DragTree;
import org.greenstone.gatherer.util.UnzipTools;

public class FullCollectionTree
extends DragTree
implements MouseListener {
    public FullCollectionTree(FileSystemModel fileSystemModel, boolean bl) {
        super(fileSystemModel, bl);
        this.addMouseListener(this);
        this.setBackgroundNonSelectionColor(Configuration.getColor("coloring.collection_tree_background", false));
        this.setBackgroundSelectionColor(Configuration.getColor("coloring.collection_selection_background", false));
        this.setTextNonSelectionColor(Configuration.getColor("coloring.collection_tree_foreground", false));
        this.setTextSelectionColor(Configuration.getColor("coloring.collection_selection_foreground", false));
        this.filter.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        this.filter.setEditable(Configuration.getMode() >= 2);
    }

    public File getRootFile() {
        FileNode fileNode = (FileNode)this.getModel().getRoot();
        return fileNode.getFile();
    }

    @Override
    public boolean isDraggable() {
        return true;
    }

    @Override
    public boolean isDroppable() {
        return true;
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        if (!this.isDroppable()) {
            return;
        }
        this.setImmediate(true);
        this.clearSelection();
        this.setImmediate(false);
        super.drop(dropTargetDropEvent);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            new FullCollectionTreeRightClickMenu(this, mouseEvent).showMenu(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public String toString() {
        return "CollectionFiles";
    }

    protected class FullCollectionTreeRightClickMenu
    extends JPopupMenu
    implements ActionListener {
        protected FullCollectionTree collection_tree = null;
        protected TreePath[] selection_paths = null;
        protected FullCollectionTreeNode node = null;
        protected JMenuItem collapse_folder = null;
        protected JMenuItem expand_folder = null;
        protected JMenuItem unzip_file = null;
        protected JMenuItem delete = null;
        protected JMenuItem new_folder = null;
        protected JMenuItem new_file = null;
        protected JMenuItem new_dummy_doc = null;
        protected JMenuItem refresh = null;
        protected JMenuItem open_externally = null;
        protected JMenuItem rename = null;
        protected JMenuItem replace = null;
        protected JMenuItem edit_file = null;

        protected FullCollectionTreeRightClickMenu(FullCollectionTree fullCollectionTree2, MouseEvent mouseEvent) {
            this.collection_tree = fullCollectionTree2;
            TreePath treePath = this.collection_tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath == null) {
                this.selection_paths = null;
                this.collection_tree.setImmediate(true);
                this.collection_tree.clearSelection();
                this.collection_tree.setImmediate(false);
            } else {
                this.selection_paths = this.collection_tree.getSelectionPaths();
                if (this.selection_paths == null) {
                    this.selection_paths = new TreePath[1];
                    this.selection_paths[0] = treePath;
                    this.collection_tree.setImmediate(true);
                    this.collection_tree.setSelectionPath(treePath);
                    this.collection_tree.setImmediate(false);
                } else if (this.selection_paths.length == 1 && !this.selection_paths[0].equals(treePath)) {
                    this.collection_tree.setImmediate(true);
                    this.collection_tree.clearSelection();
                    this.collection_tree.setSelectionPath(treePath);
                    this.collection_tree.setImmediate(false);
                    this.selection_paths[0] = treePath;
                } else {
                    boolean bl = false;
                    for (int i = 0; i < this.selection_paths.length; ++i) {
                        if (!this.selection_paths[i].equals(treePath)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.collection_tree.setImmediate(true);
                        this.collection_tree.clearSelection();
                        this.collection_tree.setSelectionPath(treePath);
                        this.collection_tree.setImmediate(false);
                        this.selection_paths = new TreePath[1];
                        this.selection_paths[0] = treePath;
                    }
                }
            }
        }

        public void showMenu(MouseEvent mouseEvent) {
            this.buildContextMenu(this.selection_paths);
            this.show(this.collection_tree, mouseEvent.getX(), mouseEvent.getY());
        }

        protected boolean selectedFilesOfSameType(TreePath[] treePathArray) {
            if (treePathArray == null || treePathArray.length <= 0) {
                return false;
            }
            boolean bl = true;
            String string = treePathArray[0].getLastPathComponent().toString();
            int n = string.lastIndexOf(46);
            if (n == -1) {
                return false;
            }
            String string2 = string.substring(n);
            for (int i = 1; i < treePathArray.length && bl; ++i) {
                String string3 = treePathArray[i].getLastPathComponent().toString();
                String string4 = string3.substring(string3.lastIndexOf(46));
                if (string2.equals(string4)) continue;
                bl = false;
            }
            return bl;
        }

        protected void buildContextMenu(TreePath[] treePathArray) {
            if (treePathArray == null) {
                this.new_folder = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_Folder"), 78);
                this.new_folder.addActionListener(this);
                this.add(this.new_folder);
                this.new_file = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_File"));
                this.new_file.addActionListener(this);
                this.add(this.new_file);
                this.new_dummy_doc = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_Empty_File"));
                this.new_dummy_doc.addActionListener(this);
                this.add(this.new_dummy_doc);
                this.refresh = new JMenuItem(Dictionary.get("CollectionPopupMenu.Refresh"));
                if (Gatherer.isGsdlRemote) {
                    this.refresh.setEnabled(false);
                }
                this.refresh.addActionListener(this);
                this.add(this.refresh);
                this.node = (FullCollectionTreeNode)this.collection_tree.getModel().getRoot();
                return;
            }
            this.delete = new JMenuItem(Dictionary.get("CollectionPopupMenu.Delete"), 68);
            this.delete.addActionListener(this);
            this.add(this.delete);
            FullCollectionTreeNode fullCollectionTreeNode = (FullCollectionTreeNode)treePathArray[0].getLastPathComponent();
            if (!Gatherer.isGsdlRemote && fullCollectionTreeNode.isZipFile()) {
                this.unzip_file = new JMenuItem(Dictionary.get("CollectionPopupMenu.Unzip"), 85);
                this.unzip_file.addActionListener(this);
                this.add(this.unzip_file);
                if (!this.selectedFilesOfSameType(treePathArray)) {
                    this.unzip_file.setEnabled(false);
                }
            }
            if (treePathArray.length > 1) {
                return;
            }
            this.rename = new JMenuItem(Dictionary.get("CollectionPopupMenu.Rename"), 82);
            this.rename.addActionListener(this);
            this.add(this.rename);
            TreePath treePath = treePathArray[0];
            this.node = (FullCollectionTreeNode)treePath.getLastPathComponent();
            if (this.node.isLeaf()) {
                this.replace = new JMenuItem(Dictionary.get("CollectionPopupMenu.Replace"), 80);
                this.replace.addActionListener(this);
                this.add(this.replace);
                if (this.node.isEditable()) {
                    this.edit_file = new JMenuItem(Dictionary.get("CollectionPopupMenu.Edit"), 69);
                    this.edit_file.addActionListener(this);
                    this.add(this.edit_file);
                }
                this.open_externally = new JMenuItem(Dictionary.get("Menu.Open_Externally"), 79);
                this.open_externally.addActionListener(this);
                this.add(this.open_externally);
                return;
            }
            if (this.collection_tree.isExpanded(treePath)) {
                this.collapse_folder = new JMenuItem(Dictionary.get("Menu.Collapse"), 67);
                this.collapse_folder.addActionListener(this);
                this.add(this.collapse_folder);
            } else {
                this.expand_folder = new JMenuItem(Dictionary.get("Menu.Expand"), 79);
                this.expand_folder.addActionListener(this);
                this.add(this.expand_folder);
            }
            if (!this.node.isReadOnly()) {
                this.new_folder = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_Folder"), 78);
                this.new_folder.addActionListener(this);
                this.add(this.new_folder);
                this.new_file = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_File"));
                this.new_file.addActionListener(this);
                this.add(this.new_file);
                this.new_dummy_doc = new JMenuItem(Dictionary.get("CollectionPopupMenu.New_Empty_File"));
                this.new_dummy_doc.addActionListener(this);
                this.add(this.new_dummy_doc);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.collapse_folder) {
                this.collection_tree.collapsePath(this.selection_paths[0]);
            } else if (object == this.expand_folder) {
                this.collection_tree.expandPath(this.selection_paths[0]);
            } else if (object == this.unzip_file) {
                Vector<FullCollectionTreeNode> vector = new Vector<FullCollectionTreeNode>(this.selection_paths.length);
                for (int i = 0; i < this.selection_paths.length; ++i) {
                    FullCollectionTreeNode fullCollectionTreeNode = (FullCollectionTreeNode)this.selection_paths[i].getLastPathComponent();
                    if (!UnzipTools.unzipFile(fullCollectionTreeNode.getFile().getPath(), fullCollectionTreeNode.getFile().getParent() + File.separator)) continue;
                    vector.add(fullCollectionTreeNode);
                }
                FileNode[] fileNodeArray = new FullCollectionTreeNode[vector.size()];
                fileNodeArray = vector.toArray(fileNodeArray);
                Gatherer.f_man.action(this.collection_tree, fileNodeArray, Gatherer.recycle_bin, null);
            } else if (object == this.delete) {
                FileNode[] fileNodeArray = new FullCollectionTreeNode[this.selection_paths.length];
                for (int i = 0; i < this.selection_paths.length; ++i) {
                    fileNodeArray[i] = (FullCollectionTreeNode)this.selection_paths[i].getLastPathComponent();
                }
                Gatherer.f_man.action(this.collection_tree, fileNodeArray, Gatherer.recycle_bin, null);
            } else if (object == this.new_folder) {
                Gatherer.f_man.newFolder(this.collection_tree, this.node);
            } else if (object == this.new_file) {
                Gatherer.f_man.newCollectionFile(this.collection_tree, this.node);
            } else if (object == this.new_dummy_doc) {
                Gatherer.f_man.newEmptyFile(this.collection_tree, this.node);
            } else if (object == this.refresh) {
                Gatherer.g_man.refreshCollectionTree(2);
            } else if (object == this.open_externally) {
                Gatherer.f_man.openFileInExternalApplication(this.node.getFile());
            } else if (object == this.edit_file) {
                File file = this.node.getFile();
                String string = file.getName();
                string = string.substring(string.lastIndexOf(".") + 1);
                Gatherer.g_man.doLoseFocus();
                TextFileEditor textFileEditor = string.matches("xml|xsl|mds|col") ? new XMLFileEditor(file) : new TextFileEditor(file);
                textFileEditor.setVisible(true);
                textFileEditor.setSize(900, 700);
            } else if (object == this.rename) {
                Gatherer.f_man.renameCollectionFile(this.collection_tree, this.node);
            } else if (object == this.replace) {
                Gatherer.f_man.replaceCollectionFile(this.collection_tree, this.node);
            }
        }
    }
}

