/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.collection;

import java.io.File;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.Classifier;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.metadata.ProfileXMLFileManager;

public class LegacyCollectionImporter {
    public static final String IMPORT_BAK_DIR = "import.bak" + File.separator;

    public static void backupMetadataXMLFiles(File file) {
        File file2 = new File(file, "import");
        File file3 = new File(file, IMPORT_BAK_DIR);
        file3.mkdir();
        LegacyCollectionImporter.copyMetadataXMLFiles(file2, file3);
    }

    private static void copyMetadataXMLFiles(File file, File file2) {
        Object object;
        if (file == null || !file.exists()) {
            return;
        }
        File file3 = new File(file, "metadata.xml");
        if (file3.exists()) {
            object = new File(file2, "metadata.xml");
            try {
                file2.mkdirs();
                Gatherer.f_man.getQueue().copyFile(file3, (File)object, false);
                if (!((File)object).exists()) {
                    throw new Exception("");
                }
            }
            catch (Exception exception) {
                DebugStream.println("Exception: couldn't copy the file " + file3.getPath() + exception.getMessage());
            }
        }
        object = file.listFiles();
        for (int i = 0; i < ((File[])object).length; ++i) {
            File file4 = object[i];
            if (!file4.isDirectory()) continue;
            LegacyCollectionImporter.copyMetadataXMLFiles(file4, new File(file2, file4.getName()));
        }
    }

    public static void updateClassifiers(CollectionDesignManager collectionDesignManager) {
        int n = 0;
        while (true) {
            Object object;
            Object object2;
            Object object3;
            if (n >= CollectionDesignManager.classifier_manager.getSize()) break;
            Classifier classifier = CollectionDesignManager.classifier_manager.getClassifier(n);
            Argument argument = classifier.getArgument("-metadata");
            Object object4 = argument.getValue();
            String string = LegacyCollectionImporter.mapLegacyMetadataElementName((String)object4);
            if (string != null && !string.equals("") && (object3 = MetadataTools.getDisplayNameForMetadataElementWithName(string)) != null) {
                object4 = object3;
                argument.setValue((String)object4);
            }
            if ((object3 = classifier.getArgument("-sort")) != null && (object2 = LegacyCollectionImporter.mapLegacyMetadataElementName(((Argument)object3).getValue())) != null && !((String)object2).equals("") && (object = MetadataTools.getDisplayNameForMetadataElementWithName((String)object2)) != null) {
                ((Argument)object3).setValue((String)object);
            }
            if ((object2 = classifier.getArgument("-buttonname")) != null && ((Argument)object2).getValue().equals("")) {
                int n2 = ((String)object4).indexOf(".");
                if (n2 != -1) {
                    ((Argument)object2).setValue(((String)object4).substring(n2 + 1));
                } else {
                    ((Argument)object2).setValue((String)object4);
                }
                ((Argument)object2).setAssigned(true);
            }
            if (classifier.getName().equalsIgnoreCase("Hierarchy")) {
                object = classifier.getArgument("-hfile");
                ((Argument)object).setValue(string + ".txt");
            }
            ++n;
        }
    }

    private static String mapLegacyMetadataElementName(String string) {
        if (string.startsWith("ex.") && string.indexOf(46, "ex.".length()) == -1) {
            string = string.substring("ex.".length());
        }
        return ProfileXMLFileManager.getMetadataElementFor(string);
    }
}

