/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.collection;

import java.io.StringReader;
import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.greenstone.LocalGreenstone;
import org.greenstone.gatherer.util.ArrayTools;
import org.greenstone.gatherer.util.Codec;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ScriptOptions {
    private Element arguments_element;
    private Element values_element;
    private static final String ARGUMENT = "Argument";
    private static final String ENABLED = "enabled";
    private static final String FALSE = "false";
    private static final String NAME = "name";
    private static final String OPTION = "Option";
    private static final String TRUE = "true";

    public ScriptOptions(Element element, String string) {
        this.values_element = element;
        this.arguments_element = this.loadArguments(string, Configuration.getLanguage());
    }

    public Argument getArgument(int n) {
        Argument argument = null;
        NodeList nodeList = this.arguments_element.getElementsByTagName(OPTION);
        if (n >= 0 && n < nodeList.getLength()) {
            argument = new Argument();
            argument.parseXML((Element)nodeList.item(n));
        }
        return argument;
    }

    public int getArgumentCount() {
        NodeList nodeList = this.arguments_element.getElementsByTagName(OPTION);
        return nodeList.getLength();
    }

    public String getValue(String string) {
        return this.getValue(string, false);
    }

    public boolean getValueEnabled(String string) {
        boolean bl = false;
        String string2 = this.getValue(string, true);
        if (string2 != null && string2.length() > 0) {
            bl = string2.equalsIgnoreCase(TRUE);
        }
        return bl;
    }

    public String[] getValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            NodeList nodeList = this.values_element.getElementsByTagName(ARGUMENT);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttribute(ENABLED).equalsIgnoreCase(TRUE)) {
                    arrayList.add("-" + element.getAttribute(NAME));
                    String string = Codec.transform(XMLTools.getValue(element), "DOM_TO_TEXT");
                    if (string != null && string.length() > 0) {
                        arrayList.add(string);
                    }
                    string = null;
                }
                element = null;
            }
            nodeList = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return ArrayTools.arrayListToStringArray(arrayList);
    }

    public void removeValue(String string) {
        try {
            NodeList nodeList = this.values_element.getElementsByTagName(ARGUMENT);
            boolean bl = false;
            for (int i = 0; !bl && i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttribute(NAME).equalsIgnoreCase(string)) {
                    this.values_element.removeChild(element);
                    bl = true;
                }
                element = null;
            }
            nodeList = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public void setValue(String string, boolean bl, String string2) {
        try {
            Document document = this.values_element.getOwnerDocument();
            NodeList nodeList = this.values_element.getElementsByTagName(ARGUMENT);
            boolean bl2 = false;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttribute(NAME).equalsIgnoreCase(string)) {
                    bl2 = true;
                    element.setAttribute(ENABLED, bl ? TRUE : FALSE);
                    if (string2 != null) {
                        while (element.hasChildNodes()) {
                            element.removeChild(element.getFirstChild());
                        }
                        element.appendChild(document.createTextNode(string2));
                    }
                }
                element = null;
            }
            if (!bl2 && (bl || string2 != null)) {
                Element element = document.createElement(ARGUMENT);
                element.setAttribute(NAME, string);
                element.setAttribute(ENABLED, bl ? TRUE : FALSE);
                if (string2 != null) {
                    element.appendChild(document.createTextNode(string2));
                }
                this.values_element.appendChild(element);
            }
            nodeList = null;
            document = null;
            Gatherer.c_man.getCollection().setSaved(false);
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    private String getValue(String string, boolean bl) {
        String string2 = null;
        try {
            NodeList nodeList = this.values_element.getElementsByTagName(ARGUMENT);
            for (int i = 0; string2 == null && i < nodeList.getLength(); ++i) {
                Element element = (Element)nodeList.item(i);
                if (element.getAttribute(NAME).equalsIgnoreCase(string)) {
                    if (bl) {
                        string2 = element.getAttribute(ENABLED);
                    } else {
                        String string3 = XMLTools.getValue(element);
                        if (string3 != null) {
                            string2 = string3;
                        }
                        string3 = null;
                    }
                }
                element = null;
            }
            nodeList = null;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
        return string2;
    }

    private Element loadArguments(String string, String string2) {
        try {
            Document document;
            if (Gatherer.isGsdlRemote) {
                String string3 = Gatherer.remoteGreenstoneServer.getScriptOptions(string, "");
                document = XMLTools.parseXML(new StringReader(string3));
            } else {
                String[] stringArray = new String[]{Configuration.perl_path, "-S", LocalGreenstone.getBinScriptDirectoryPath() + string, "-xml", "-language", string2};
                SafeProcess safeProcess = new SafeProcess(stringArray);
                int n = safeProcess.runProcess();
                if (n != 0) {
                    throw new Exception("*** Error running ScriptOptions process, process exited with: " + n);
                }
                String string4 = safeProcess.getStdError();
                StringReader stringReader = new StringReader(string4);
                document = XMLTools.parseXML(stringReader);
                stringReader.close();
                if (document == null) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        DebugStream.print(stringArray[i] + " ");
                    }
                    DebugStream.println("");
                }
            }
            return document.getDocumentElement();
        }
        catch (Exception exception) {
            DebugStream.println("Error in ScriptOptions.loadArguments(): " + exception);
            DebugStream.printStackTrace(exception);
            return null;
        }
    }
}

