/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.file.FileFilter;
import org.greenstone.gatherer.file.FileSystemModel;
import org.greenstone.gatherer.metadata.FilenameEncoding;
import org.greenstone.gatherer.util.ArrayTools;

public abstract class FileNode
implements MutableTreeNode {
    protected boolean allows_children = true;
    protected ArrayList child_nodes = null;
    protected ArrayList child_nodes_unfiltered = null;
    protected File file = null;
    protected FileSystemModel model = null;
    protected MutableTreeNode parent = null;
    protected String urlEncodedFileName = "";
    protected String urlEncodedFilePath = "";
    protected String filenameEncoding = "";
    protected String displayFileName = null;

    public FileNode(File file) {
        this.file = file;
        if (file != null) {
            if (file.isFile()) {
                this.allows_children = false;
            }
            this.filenameEncoding = "";
            this.urlEncodedFilePath = FilenameEncoding.calcURLEncodedFilePath(file);
            this.urlEncodedFileName = FilenameEncoding.calcURLEncodedFileName(this.urlEncodedFilePath);
            this.displayFileName = this.calcDisplayString();
        }
    }

    public String getURLEncodedFileName() {
        return this.urlEncodedFileName;
    }

    public String getURLEncodedFilePath() {
        return this.urlEncodedFilePath;
    }

    public String getFilenameEncoding() {
        return this.filenameEncoding;
    }

    protected String calcDisplayString() {
        if (FilenameEncoding.DEBUGGING) {
            return this.getURLEncodedFileName();
        }
        return this.file.getName();
    }

    public Enumeration children() {
        return new FileEnumeration();
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allows_children;
    }

    @Override
    public TreeNode getChildAt(int n) {
        return (TreeNode)this.child_nodes.get(n);
    }

    @Override
    public int getChildCount() {
        this.map();
        if (this.child_nodes != null) {
            return this.child_nodes.size();
        }
        return 0;
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (this.child_nodes != null) {
            return this.child_nodes.indexOf(treeNode);
        }
        return -1;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public void insert(MutableTreeNode mutableTreeNode, int n) {
        DebugStream.println("Insert " + mutableTreeNode + " in " + this + " at index " + n + " [Model: " + this.model + "]");
        if (mutableTreeNode == null) {
            return;
        }
        try {
            FileNode fileNode = (FileNode)mutableTreeNode;
            this.child_nodes.add(n, fileNode);
            fileNode.model = this.model;
            fileNode.parent = this;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    @Override
    public boolean isLeaf() {
        return !this.allows_children;
    }

    @Override
    public void remove(int n) {
        if (n >= 0 && n < this.child_nodes.size()) {
            this.child_nodes.remove(n);
        }
    }

    @Override
    public void remove(MutableTreeNode mutableTreeNode) {
        this.remove(this.getIndex(mutableTreeNode));
    }

    @Override
    public void removeFromParent() {
        this.parent.remove(this);
        this.parent = null;
    }

    @Override
    public void setUserObject(Object object) {
        try {
            this.file = (File)object;
        }
        catch (Exception exception) {
            DebugStream.printStackTrace(exception);
        }
    }

    public void add(MutableTreeNode mutableTreeNode) {
        this.insert(mutableTreeNode, this.child_nodes.size());
    }

    protected abstract FileNode addChildNode(File var1);

    public boolean equals(FileNode fileNode) {
        if (fileNode == null) {
            return false;
        }
        if (this.file != null) {
            return this.file.equals(fileNode.getFile());
        }
        return this.toString().equals(fileNode.toString());
    }

    public FileNode getChildAtUnfiltered(int n) {
        if (n >= 0 && n < this.size()) {
            return (FileNode)this.child_nodes_unfiltered.get(n);
        }
        return null;
    }

    public File getFile() {
        return this.file;
    }

    public TreeNode[] getPath() {
        TreeNode treeNode;
        int n = 0;
        for (treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            ++n;
        }
        TreeNode[] treeNodeArray = new TreeNode[n];
        for (treeNode = this; treeNode != null; treeNode = treeNode.getParent()) {
            treeNodeArray[n - 1] = treeNode;
            --n;
        }
        return treeNodeArray;
    }

    public boolean isFileSystemRoot() {
        if (this.file != null) {
            return FileSystemView.getFileSystemView().isFileSystemRoot(this.file);
        }
        return false;
    }

    public boolean isInLoadedCollection() {
        return false;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void map() {
        if (this.child_nodes != null) {
            return;
        }
        this.child_nodes = new ArrayList();
        if (this.file != null && this.getAllowsChildren()) {
            File[] fileArray = this.file.listFiles();
            if (fileArray != null && fileArray.length > 0) {
                int n;
                ArrayTools.sort(fileArray);
                this.child_nodes_unfiltered = new ArrayList();
                for (int i = 0; i < fileArray.length; ++i) {
                    FileNode fileNode = this.addChildNode(fileArray[i]);
                    this.child_nodes_unfiltered.add(fileNode);
                }
                FileFilter[] fileFilterArray = this.model.getFilters();
                for (n = 0; fileFilterArray != null && n < fileFilterArray.length; ++n) {
                    fileArray = ArrayTools.filter(fileArray, fileFilterArray[n].filter, fileFilterArray[n].exclude);
                }
                int n2 = 0;
                for (n = 0; n < this.child_nodes_unfiltered.size() && n2 < fileArray.length; ++n) {
                    FileNode fileNode = (FileNode)this.child_nodes_unfiltered.get(n);
                    if (!fileNode.getFile().equals(fileArray[n2])) continue;
                    this.child_nodes.add(fileNode);
                    ++n2;
                }
                this.refreshDescendantEncodings();
            }
            Gatherer.invokeInEDT_replacesProceedInCurrThread("FileNode.map()", true, new Runnable(){

                @Override
                public void run() {
                    FileNode.this.model.nodeStructureChanged(FileNode.this);
                }
            });
        }
    }

    public void refresh() {
        this.unmap();
        this.map();
    }

    public void resetDescendantEncodings() {
    }

    public void refreshDescendantEncodings() {
    }

    public void setModel(FileSystemModel fileSystemModel) {
        this.model = fileSystemModel;
    }

    @Override
    public void setParent(MutableTreeNode mutableTreeNode) {
        this.parent = mutableTreeNode;
    }

    public int size() {
        if (this.child_nodes_unfiltered != null) {
            return this.child_nodes_unfiltered.size();
        }
        return 0;
    }

    public String toString() {
        if (this.isFileSystemRoot()) {
            return this.file.getAbsolutePath();
        }
        if (this.displayFileName == null) {
            this.displayFileName = this.calcDisplayString();
        }
        return this.displayFileName;
    }

    public void unmap() {
        DebugStream.println("Unmapping " + this + "...");
        this.child_nodes_unfiltered = null;
        this.child_nodes = null;
    }

    private class FileEnumeration
    implements Enumeration {
        private int index = 0;

        private FileEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            if (FileNode.this.child_nodes == null) {
                return false;
            }
            return this.index < FileNode.this.child_nodes.size();
        }

        public Object nextElement() {
            Object var1_1 = null;
            if (this.index < FileNode.this.child_nodes.size()) {
                var1_1 = FileNode.this.child_nodes.get(this.index);
                ++this.index;
            }
            return var1_1;
        }
    }
}

