/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.gems.Attribute;
import org.greenstone.gatherer.gems.AttributeContainer;
import org.greenstone.gatherer.gems.GEMSConstants;
import org.greenstone.gatherer.gems.MetadataElementEvent;
import org.greenstone.gatherer.gems.MetadataElementListener;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetModel;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MetadataElementModel
extends AttributeContainer {
    private Element metadata_element;
    private ArrayList children;
    private MetadataElementModel parent;
    private static ArrayList listeners = new ArrayList();
    private MetadataSetInfo metadataSetInfo;
    private String name;
    private static int count = 0;

    public MetadataElementModel() {
    }

    public MetadataElementModel(MetadataSetInfo metadataSetInfo) {
        this(metadataSetInfo, null);
    }

    public MetadataElementModel(MetadataSetInfo metadataSetInfo, String string) {
        super(null, GEMSConstants.ELEMENT_LANG_DEPEND_ATTR_NAMES);
        this.required_attribute_names = GEMSConstants.ELEMENT_REQUIRED_ATTRIBUTES;
        this.metadataSetInfo = metadataSetInfo;
        this.children = new ArrayList();
        this.name = string != null ? string : GEMSConstants.NEW_ELEMENT + count++;
        Attribute attribute = new Attribute(GEMSConstants.NAME_ATTRIBUTE, this.name, true);
        this.attributes.add(attribute);
        attribute = this.getAttributeByNameAndLanguage(GEMSConstants.LABEL_ATTRIBUTE, Configuration.getLanguage());
        attribute.setValue(this.name);
    }

    public MetadataElementModel(Element element, MetadataSetInfo metadataSetInfo) {
        super(null, null);
        this.required_attribute_names = GEMSConstants.ELEMENT_REQUIRED_ATTRIBUTES;
        this.language_dependent_attribute_names = GEMSConstants.ELEMENT_LANG_DEPEND_ATTR_NAMES;
        this.metadataSetInfo = metadataSetInfo;
        this.metadata_element = element;
        this.children = new ArrayList();
        this.constructModel(this.metadata_element);
        ArrayList arrayList = XMLTools.getChildElementsByTagName(this.metadata_element, GEMSConstants.ELEMENT_ELEMENT);
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element2 = (Element)arrayList.get(i);
            MetadataElementModel metadataElementModel = new MetadataElementModel(element2, this.metadataSetInfo);
            metadataElementModel.setParent(this);
            this.children.add(metadataElementModel);
        }
    }

    private void constructModel(Element element) {
        Object object;
        String string;
        Object object2;
        this.name = element.getAttribute(GEMSConstants.NAME_ATTRIBUTE);
        Attribute attribute = new Attribute(GEMSConstants.NAME_ATTRIBUTE, this.name, true);
        this.attributes.add(attribute);
        ArrayList arrayList = XMLTools.getChildElementsByTagName(this.metadata_element, GEMSConstants.ATTRIBUTE_ELEMENT);
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element2 = (Element)arrayList.get(i);
            object2 = element2.getAttribute(GEMSConstants.NAME_ATTRIBUTE).trim();
            string = XMLTools.getElementTextValue(element2);
            attribute = new Attribute((String)object2, string);
            object = element2.getAttribute(GEMSConstants.LANGUAGE_ATTRIBUTE);
            if (((String)object).equals("")) {
                attribute.setRequired(this.isAttributeRequired((String)object2));
                this.attributes.add(attribute);
                continue;
            }
            attribute.setLanguage((String)object);
            attribute.setRequired(this.isLangDependentAttributeRequired((String)object2));
            this.language_dependent_attributes.add(attribute);
        }
        ArrayList arrayList2 = XMLTools.getChildElementsByTagName(this.metadata_element, GEMSConstants.LANGUAGE_ELEMENT);
        for (int i = 0; i < arrayList2.size(); ++i) {
            object2 = (Element)arrayList2.get(i);
            string = object2.getAttribute(GEMSConstants.CODE_ATTRIBUTE);
            object = XMLTools.getChildElementsByTagName((Element)object2, GEMSConstants.ATTRIBUTE_ELEMENT);
            for (int j = 0; j < ((ArrayList)object).size(); ++j) {
                Element element3 = (Element)((ArrayList)object).get(j);
                String string2 = element3.getAttribute(GEMSConstants.NAME_ATTRIBUTE).trim();
                String string3 = XMLTools.getElementTextValue(element3);
                attribute = new Attribute(string2, string3, this.isLangDependentAttributeRequired(string2));
                attribute.setLanguage(string);
                this.language_dependent_attributes.add(attribute);
            }
        }
    }

    public void addMetadataElementListener(MetadataElementListener metadataElementListener) {
        if (!listeners.contains(metadataElementListener)) {
            listeners.add(metadataElementListener);
        }
    }

    public void removeMetadataElementListener(MetadataElementListener metadataElementListener) {
        listeners.remove(metadataElementListener);
    }

    public void removeAllMetadataElementListeners() {
        listeners.clear();
    }

    public boolean doesChildWithThisNameExist(String string) {
        for (int i = 0; i < this.children.size(); ++i) {
            if (!string.equals(((MetadataElementModel)this.children.get(i)).getName())) continue;
            return true;
        }
        return false;
    }

    public Element getMetadataElement() {
        return this.metadata_element;
    }

    public void notifyListeners(boolean bl) {
        MetadataElementEvent metadataElementEvent = new MetadataElementEvent(this);
        metadataElementEvent = !bl ? new MetadataElementEvent(this) : new MetadataElementEvent(null);
        for (int i = 0; i < listeners.size(); ++i) {
            MetadataElementListener metadataElementListener = (MetadataElementListener)listeners.get(i);
            metadataElementListener.metadataElementChanged(metadataElementEvent);
        }
    }

    public ArrayList getChildElements() {
        return this.children;
    }

    public void addChild(MetadataElementModel metadataElementModel) {
        this.metadataSetInfo.getMetadataSetModel().setChanged(true);
        metadataElementModel.setParent(this);
        this.children.add(metadataElementModel);
    }

    public void removeChild(MetadataElementModel metadataElementModel) {
        this.metadataSetInfo.getMetadataSetModel().setChanged(true);
        this.children.remove(metadataElementModel);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.metadataSetInfo.getMetadataSetModel().setChanged(true);
        this.name = string;
        MetadataSetModel metadataSetModel = this.metadataSetInfo.getMetadataSetModel();
        metadataSetModel.valueChanged();
    }

    public String getFullName() {
        if (this.parent == null) {
            return this.metadataSetInfo.getNamespace() + "." + this.name;
        }
        return this.parent.getFullName() + "^" + this.name;
    }

    public void setParent(MetadataElementModel metadataElementModel) {
        this.parent = metadataElementModel;
    }

    public MetadataElementModel getParent() {
        return this.parent;
    }

    public boolean moveUp(MetadataElementModel metadataElementModel) {
        this.metadataSetInfo.getMetadataSetModel().setChanged(true);
        int n = this.children.indexOf(metadataElementModel);
        if (n - 1 >= 0) {
            this.children.remove(metadataElementModel);
            this.children.add(n - 1, metadataElementModel);
            return true;
        }
        return false;
    }

    public boolean moveDown(MetadataElementModel metadataElementModel) {
        this.metadataSetInfo.getMetadataSetModel().setChanged(true);
        int n = this.children.indexOf(metadataElementModel);
        if (n + 1 < this.children.size()) {
            this.children.remove(metadataElementModel);
            this.children.add(n + 1, metadataElementModel);
            return true;
        }
        return false;
    }

    public void save() {
        this.saveElement();
        for (int i = 0; i < this.children.size(); ++i) {
            MetadataElementModel metadataElementModel = (MetadataElementModel)this.children.get(i);
            metadataElementModel.save();
        }
    }

    private void saveElement() {
        Document document = this.metadataSetInfo.getMetadataSetDocument();
        Element element = null;
        element = this.parent != null ? this.parent.getMetadataElement() : document.getDocumentElement();
        this.metadata_element = this.save(document);
        element.appendChild(this.metadata_element);
    }

    private Element save(Document document) {
        Object object;
        this.metadata_element = document.createElement(GEMSConstants.ELEMENT_ELEMENT);
        this.metadata_element.setAttribute(GEMSConstants.NAME_ATTRIBUTE, this.name);
        for (int i = 0; i < this.attributes.size(); ++i) {
            Attribute attribute = (Attribute)this.attributes.get(i);
            if (attribute.getName() == null || attribute.getName().trim().equals("") || attribute.getName().equals("name")) continue;
            object = document.createElement(GEMSConstants.ATTRIBUTE_ELEMENT);
            object.setAttribute(GEMSConstants.NAME_ATTRIBUTE, attribute.getName());
            object.appendChild(document.createTextNode(attribute.getValue()));
            this.metadata_element.appendChild((Node)object);
        }
        ArrayList arrayList = this.getAllLanguages();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (String)arrayList.get(i);
            Element element = document.createElement(GEMSConstants.LANGUAGE_ELEMENT);
            element.setAttribute(GEMSConstants.CODE_ATTRIBUTE, (String)object);
            ArrayList arrayList2 = this.getAttributesByLanguage((String)object);
            for (int j = 0; j < arrayList2.size(); ++j) {
                Attribute attribute = (Attribute)arrayList2.get(j);
                Element element2 = document.createElement(GEMSConstants.ATTRIBUTE_ELEMENT);
                element2.setAttribute(GEMSConstants.NAME_ATTRIBUTE, attribute.getName());
                element2.appendChild(document.createTextNode(attribute.getValue()));
                element.appendChild(element2);
            }
            this.metadata_element.appendChild(element);
        }
        return this.metadata_element;
    }
}

