/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.util.ArrayList;
import java.util.Observable;
import org.greenstone.gatherer.gems.AttributeEvent;
import org.greenstone.gatherer.gems.AttributeListener;
import org.greenstone.gatherer.gems.GEMSConstants;
import org.greenstone.gatherer.gems.MetadataElementModel;
import org.greenstone.gatherer.gems.MetadataSetEvent;
import org.greenstone.gatherer.gems.MetadataSetInfo;
import org.greenstone.gatherer.gems.MetadataSetListener;
import org.greenstone.gatherer.gems.MetadataSetManager;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataSetModel
extends Observable
implements MetadataSetListener,
AttributeListener {
    private Document metadata_doc;
    private MetadataSetManager meta_manager;
    private ArrayList model;
    private MetadataSetInfo meta_info;
    private boolean changed = false;

    public MetadataSetModel(MetadataSetManager metadataSetManager) {
        this.meta_manager = metadataSetManager;
        this.model = new ArrayList();
    }

    public String getCurrentLanguage() {
        return this.meta_manager.getCurrentLanguage();
    }

    @Override
    public void metadataSetChanged(MetadataSetEvent metadataSetEvent) {
        if (this.meta_info != null) {
            this.save(true);
        }
        this.model = new ArrayList();
        this.meta_info = metadataSetEvent.getMetadataSetInfo();
        this.meta_info.setMetadataSetModel(this);
        this.metadata_doc = this.meta_manager.getMetadataSetDocument(this.meta_info.getFilePath());
        this.constructModel();
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
        this.changed = false;
    }

    public void valueChanged() {
        this.setChanged();
        this.notifyObservers(false);
        this.clearChanged();
    }

    private void constructModel() {
        if (this.metadata_doc == null) {
            return;
        }
        ArrayList arrayList = XMLTools.getChildElementsByTagName(this.metadata_doc.getDocumentElement(), GEMSConstants.ELEMENT_ELEMENT);
        for (int i = 0; i < arrayList.size(); ++i) {
            Element element = (Element)arrayList.get(i);
            this.model.add(new MetadataElementModel(element, this.meta_info));
        }
    }

    public boolean doesChildWithThisNameExist(String string) {
        for (int i = 0; i < this.model.size(); ++i) {
            if (!string.equals(((MetadataElementModel)this.model.get(i)).getName())) continue;
            return true;
        }
        return false;
    }

    public Document getMetadataSetDocument() {
        return this.metadata_doc;
    }

    public void setMetadataSetDocument(Document document) {
        this.metadata_doc = document;
    }

    public MetadataSetManager getMetadataSetManager() {
        return this.meta_manager;
    }

    public ArrayList getMetadataSetModel() {
        return this.model;
    }

    public void addChild(MetadataElementModel metadataElementModel) {
        this.model.add(metadataElementModel);
        this.changed = true;
    }

    public void removeChild(MetadataElementModel metadataElementModel) {
        this.model.remove(metadataElementModel);
        this.changed = true;
    }

    @Override
    public void attributeChanged(AttributeEvent attributeEvent) {
        this.changed = true;
    }

    public void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void save(boolean bl) {
        Object object;
        if (this.meta_info == null || !this.changed && !this.meta_info.isNew()) {
            return;
        }
        this.meta_info.save();
        if (this.metadata_doc != null) {
            Element element = this.metadata_doc.getDocumentElement();
            object = XMLTools.getChildElementsByTagName(element, GEMSConstants.ELEMENT_ELEMENT);
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                Element element2 = (Element)((ArrayList)object).get(i);
                element.removeChild(element2);
            }
        }
        for (int i = 0; i < this.model.size(); ++i) {
            object = (MetadataElementModel)this.model.get(i);
            ((MetadataElementModel)object).save();
        }
        this.meta_manager.save(bl);
        this.changed = false;
    }

    public MetadataSetInfo getMetadataSetInfo() {
        return this.meta_info;
    }

    public void metadataSetDeleted() {
        this.meta_info = null;
        this.setChanged();
        this.notifyObservers();
        this.clearChanged();
        this.changed = false;
    }

    public boolean moveUp(MetadataElementModel metadataElementModel) {
        int n = this.model.indexOf(metadataElementModel);
        if (n - 1 >= 0) {
            this.changed = true;
            this.model.remove(metadataElementModel);
            this.model.add(n - 1, metadataElementModel);
            return true;
        }
        return false;
    }

    public boolean moveDown(MetadataElementModel metadataElementModel) {
        int n = this.model.indexOf(metadataElementModel);
        if (n + 1 < this.model.size()) {
            this.changed = true;
            this.model.remove(metadataElementModel);
            this.model.add(n + 1, metadataElementModel);
            return true;
        }
        return false;
    }
}

