/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gems;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gems.MetadataElementModel;
import org.greenstone.gatherer.gems.MetadataSetModel;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;

public class NewMetadataElementNamePrompt
extends ModalDialog {
    private Dimension SIZE = new Dimension(350, 120);
    private boolean cancelled = false;
    private String element_name = null;
    private JTextField name_textfield = null;
    private JDialog prompt;
    private Object model;

    public NewMetadataElementNamePrompt(Frame frame, boolean bl, Object object) {
        super(frame, true);
        this.setSize(this.SIZE);
        this.prompt = this;
        this.model = object;
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setOpaque(true);
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel();
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        if (bl) {
            this.setTitle(Dictionary.get("GEMS.NewMetadataElementNamePrompt.SubTitle"));
            jLabel.setText(Dictionary.get("GEMS.NewMetadataElementNamePrompt.SubName"));
        } else {
            this.setTitle(Dictionary.get("GEMS.NewMetadataElementNamePrompt.Title"));
            jLabel.setText(Dictionary.get("GEMS.NewMetadataElementNamePrompt.Name"));
        }
        this.name_textfield = new JTextField();
        this.name_textfield.setComponentOrientation(Dictionary.getOrientation());
        this.name_textfield.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    NewMetadataElementNamePrompt.this.validateElementName();
                }
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add(jLabel);
        jPanel2.add(this.name_textfield);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        GLIButton gLIButton = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        GLIButton gLIButton2 = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        jPanel3.add(gLIButton);
        jPanel3.add(gLIButton2);
        gLIButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewMetadataElementNamePrompt.this.validateElementName();
            }
        });
        gLIButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewMetadataElementNamePrompt.this.cancelled = true;
                NewMetadataElementNamePrompt.this.prompt.dispose();
            }
        });
        jPanel.setLayout(new BorderLayout(5, 5));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - this.SIZE.width) / 2, (dimension.height - this.SIZE.height) / 2);
        this.setVisible(true);
    }

    @Override
    public String getName() {
        return this.element_name;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private void validateElementName() {
        String string = this.name_textfield.getText();
        if (string.equals("")) {
            JOptionPane.showMessageDialog(this.prompt, Dictionary.get("GEMS.NewMetadataElementNamePrompt.EmptyName_Error_Message"), Dictionary.get("GEMS.NewMetadataElementNamePrompt.Name_Error"), 0);
            return;
        }
        boolean bl = false;
        if (this.model instanceof MetadataSetModel) {
            bl = ((MetadataSetModel)this.model).doesChildWithThisNameExist(string);
        } else if (this.model instanceof MetadataElementModel) {
            bl = ((MetadataElementModel)this.model).doesChildWithThisNameExist(string);
        }
        if (!bl) {
            this.element_name = string;
            this.prompt.dispose();
        } else {
            JOptionPane.showMessageDialog(this.prompt, Dictionary.get("GEMS.NewMetadataElementNamePrompt.Name_Error_Message"), Dictionary.get("GEMS.NewMetadataElementNamePrompt.Name_Error"), 0);
        }
    }
}

