/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.CollectionDesignManager;
import org.greenstone.gatherer.cdm.Control;

public abstract class BaseConfigPane
extends JPanel {
    protected String[] contents;
    private static final Dimension TREE_SIZE = new Dimension(200, 500);
    protected Control view = null;
    protected String view_type = null;
    protected CollectionDesignManager cdm = null;
    protected DesignTree tree;
    protected JPanel tree_pane;

    public BaseConfigPane() {
        DebugStream.println("BaseConfigPane: Main GUI components created.");
        this.setComponentOrientation(Dictionary.getOrientation());
        this.tree_pane = new JPanel();
        this.tree_pane.setComponentOrientation(Dictionary.getOrientation());
        this.tree = new DesignTree();
        this.tree.setComponentOrientation(Dictionary.getOrientation());
        this.tree.addTreeSelectionListener(new TreeListener());
        this.tree_pane.setLayout(new BorderLayout());
        this.tree_pane.setPreferredSize(TREE_SIZE);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        this.tree_pane.add((Component)jScrollPane, "Center");
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)this.tree_pane, "Before");
    }

    protected abstract Control getSubControls(String var1);

    public void display() {
    }

    public void gainFocus() {
        if (this.cdm == null) {
            if (Gatherer.c_man.ready()) {
                this.cdm = Gatherer.c_man.getCollection().cdm;
            }
        }
        if (this.view != null) {
            this.view.gainFocus();
        }
    }

    public void loseFocus() {
        if (this.view != null) {
            this.view.loseFocus();
        }
        if (this.cdm != null) {
            Gatherer.c_man.saveCollection();
        }
    }

    public void destroy() {
        this.tree = null;
        this.view = null;
    }

    public void modeChanged(int n) {
        if (this.cdm != null) {
            this.cdm.modeChanged(n);
        }
    }

    public void refresh(int n, boolean bl) {
        if (bl) {
            this.cdm = Gatherer.c_man.getCollection().cdm;
            this.tree.resetModel(Configuration.getMode());
        }
    }

    public void setSelectedView(String string) {
        this.tree.setSelectedView(string);
    }

    private class TreeListener
    implements TreeSelectionListener {
        private TreeListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (!BaseConfigPane.this.tree.isSelectionEmpty()) {
                TreePath treePath = BaseConfigPane.this.tree.getSelectionPath();
                DesignNode designNode = (DesignNode)treePath.getLastPathComponent();
                String string = (String)designNode.getUserObject();
                Gatherer.g_man.wait(true);
                if (BaseConfigPane.this.view != null) {
                    BaseConfigPane.this.view.loseFocus();
                    BaseConfigPane.this.remove((JPanel)((Object)BaseConfigPane.this.view));
                }
                BaseConfigPane.this.view_type = string;
                BaseConfigPane.this.view = BaseConfigPane.this.getSubControls(string);
                if (BaseConfigPane.this.view != null) {
                    BaseConfigPane.this.add((Component)((JPanel)((Object)BaseConfigPane.this.view)), "Center");
                    BaseConfigPane.this.view.gainFocus();
                }
                BaseConfigPane.this.repaint();
                Gatherer.g_man.wait(false);
            }
        }
    }

    private class DesignNode
    extends DefaultMutableTreeNode {
        public DesignNode(String string) {
            super(string);
        }

        @Override
        public String toString() {
            return Dictionary.get((String)this.getUserObject());
        }
    }

    private class DesignTree
    extends JTree {
        private DesignNode root = null;

        public void resetModel(int n) {
            this.root = new DesignNode("CDM.GUI.Root");
            for (int i = 0; i < BaseConfigPane.this.contents.length; ++i) {
                this.root.add(new DesignNode(BaseConfigPane.this.contents[i]));
            }
            this.setModel(new DefaultTreeModel(this.root));
            this.expandRow(0);
            this.setRootVisible(false);
            this.setSelectionRow(0);
            this.updateUI();
        }

        public void setSelectedView(String string) {
            string = Dictionary.get(string);
            for (int i = 0; i < this.root.getChildCount(); ++i) {
                DesignNode designNode = (DesignNode)this.root.getChildAt(i);
                if (!designNode.toString().equals(string)) continue;
                TreePath treePath = new TreePath(designNode.getPath());
                this.setSelectionPath(treePath);
            }
        }
    }
}

