/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.Color;
import java.io.File;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.XMLFileEditor;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CollectionConfigFileEditor
extends XMLFileEditor {
    protected String[] nonEscapingTagNames = new String[]{"format", "displayItem"};

    public CollectionConfigFileEditor(File file) {
        super(file);
    }

    protected ElementOption[] getElementOptions() {
        return ElementOption.values();
    }

    @Override
    protected boolean addElementsEnabled() {
        return true;
    }

    @Override
    protected String getElementsXMLFileString() {
        return "xml/elementsForInsertion.xml";
    }

    @Override
    protected void customActionOnSave() {
        String string = Gatherer.c_man.getCollection().getCollectionPath();
        Gatherer.c_man.saveCollection();
        Gatherer.c_man.reloadAfterConfigFileEdited();
    }

    @Override
    protected void addElementToFile() {
        ElementOption elementOption = (ElementOption)((Object)this.chooseElementComboBox.getSelectedItem());
        this.addElementToConfigFile(elementOption);
        this.editor.setCaretPosition(0);
    }

    protected void addElementToConfigFile(ElementOption elementOption) {
        Object object;
        String string = this.editor.getText();
        if (string.equals("")) {
            this.editor_msgarea.setText(Dictionary.get("CollectionConfigFileEditor.Press_Undo_Once_More_First"));
            this.editor_msgarea.setBackground(Color.orange);
            return;
        }
        Document document = XMLTools.getDOM(string);
        Object object2 = document.getDocumentElement();
        NodeList nodeList = this.elements_available_for_insertion.getElementsByTagName("security");
        Element element = null;
        boolean bl = false;
        NodeList nodeList2 = document.getElementsByTagName("security");
        switch (elementOption) {
            case HIDE_COLLECTION: {
                object = (Element)XMLTools.getChildByTagName((Node)object2, "metadataList");
                if (object == null) break;
                Element element2 = XMLTools.getNamedElement((Element)object, "metadata", "name", "public");
                if (element2 != null) {
                    XMLTools.setNodeText(element2, "false");
                    bl = true;
                    break;
                }
                object2 = object;
                element = XMLTools.getNamedElement(this.elements_available_for_insertion.getDocumentElement(), "metadata", "name", "public");
                break;
            }
            case SECURE_COLLECTION: 
            case SECURE_ALL_DOCUMENTS: 
            case SECURE_CERTAIN_DOCUMENTS: {
                if (nodeList2.getLength() == 0) {
                    element = (Element)nodeList.item(elementOption.ordinal() - 1);
                    break;
                }
                this.editor_msgarea.setText(Dictionary.get("CollectionConfigFileEditor.Config_Already_Has_Security_Element"));
                this.editor_msgarea.setBackground(Color.orange);
                break;
            }
            case ADD_ANOTHER_DOCUMENTSET: 
            case ADD_ANOTHER_EXCEPTION: {
                if (nodeList2.getLength() > 0) {
                    object2 = (Element)nodeList2.item(0);
                    Element element3 = (Element)nodeList.item(nodeList.getLength() - 1);
                    if (elementOption == ElementOption.ADD_ANOTHER_DOCUMENTSET) {
                        element = (Element)XMLTools.getChildByTagName(element3, "documentSet");
                        break;
                    }
                    element = (Element)XMLTools.getChildByTagName(element3, "exception");
                    break;
                }
                object2 = null;
                this.editor_msgarea.setText(Dictionary.get("CollectionConfigFileEditor.Need_Security_Element_To_Add"));
                this.editor_msgarea.setBackground(Color.orange);
            }
        }
        if (element != null) {
            object = document.importNode(element, true);
            object2.appendChild((Node)object);
            bl = true;
        }
        if (bl) {
            object = new StringBuffer();
            XMLTools.xmlNodeToString((StringBuffer)object, document.getDocumentElement(), true, "  ", 0);
            this.editor.setText(((StringBuffer)object).toString());
        }
    }

    protected static enum ElementOption {
        HIDE_COLLECTION(Dictionary.get("CollectionConfigFileEditor.Hide_Collection")),
        SECURE_COLLECTION(Dictionary.get("CollectionConfigFileEditor.Secure_Collection")),
        SECURE_ALL_DOCUMENTS(Dictionary.get("CollectionConfigFileEditor.Secure_All_Documents")),
        SECURE_CERTAIN_DOCUMENTS(Dictionary.get("CollectionConfigFileEditor.Secure_Certain_Documents")),
        ADD_ANOTHER_DOCUMENTSET(Dictionary.get("CollectionConfigFileEditor.Add_Another_DocumentSet")),
        ADD_ANOTHER_EXCEPTION(Dictionary.get("CollectionConfigFileEditor.Add_Another_Exception"));

        protected final String displayString;

        private ElementOption(String string2) {
            this.displayString = string2;
        }

        public String toString() {
            return this.displayString;
        }
    }
}

