/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;

public final class EditorDialog
extends ModalDialog
implements ActionListener {
    private boolean editable = true;
    private JButton cancel = null;
    private JButton ok = null;
    private JTextArea text = null;
    private String result = null;
    private static final Dimension SIZE = new Dimension(400, 300);

    public EditorDialog() {
        super(Gatherer.g_man);
        this.setComponentOrientation(Dictionary.getOrientation());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.ok) {
            this.result = this.text.getText();
        }
        this.dispose();
    }

    public String display(String string) {
        this.setModal(true);
        this.setSize(SIZE);
        this.setJMenuBar(new SimpleMenuBar("theenrichview"));
        if (this.editable) {
            this.setTitle(Dictionary.get("General.Edit"));
        } else {
            this.setTitle(Dictionary.get("General.View"));
        }
        this.text = new JTextArea(string);
        this.text.setComponentOrientation(Dictionary.getOrientation());
        this.text.setCaretPosition(string.length());
        this.text.setEditable(this.editable);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(false);
        if (this.editable) {
            this.text.setToolTipText(Dictionary.get("EnrichPane.Value_Field_Tooltip"));
        } else {
            this.text.setToolTipText(Dictionary.get("EnrichPane.Value_Field_Tooltip_Uneditable"));
        }
        this.cancel = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
        this.ok = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.cancel.addActionListener(this);
        this.ok.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setLayout(new GridLayout(1, 2));
        if (this.editable) {
            jPanel.add(this.ok);
            jPanel.add(this.cancel);
        } else {
            jPanel.add(new JPanel());
            jPanel.add(this.ok);
        }
        JPanel jPanel2 = (JPanel)this.getContentPane();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.text);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)jPanel, "South");
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - EditorDialog.SIZE.width) / 2, (dimension.height - EditorDialog.SIZE.height) / 2);
        this.setVisible(true);
        return this.result;
    }

    public void setEditable(boolean bl) {
        if (this.text == null) {
            this.editable = bl;
        } else {
            this.text.setEditable(bl);
        }
    }
}

