/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;

public class FedoraLogin
extends JDialog {
    private static final int MAX_ITEMS = 5;
    private static final Color LIGHT = new Color(244, 244, 224);
    private static final Color TRANSPARENT = new Color(0, 0, 0, 0);
    private JPanel m_infoPane;
    private JComboBox m_serverComboBox;
    private JComboBox m_protocolComboBox;
    private JComboBox m_usernameComboBox;
    private JPasswordField m_passwordField;
    private String m_lastUsername = "fedoraAdmin";
    private String m_lastServer = "localhost:8080";
    private String m_lastProtocol = "http";
    private String m_lastPassword = "";
    private boolean login_requested = false;

    public FedoraLogin(String string, boolean bl) {
        super(Gatherer.g_man, "Login", true);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setDefaultCloseOperation(2);
        JLabel jLabel = new JLabel("Fedora Server");
        JLabel jLabel2 = new JLabel("Protocol");
        JLabel jLabel3 = new JLabel("Username");
        JLabel jLabel4 = new JLabel("Password");
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        jLabel3.setComponentOrientation(Dictionary.getOrientation());
        jLabel4.setComponentOrientation(Dictionary.getOrientation());
        this.m_serverComboBox = new JComboBox<String>(new String[]{this.m_lastServer});
        this.m_serverComboBox.setComponentOrientation(Dictionary.getOrientation());
        this.m_serverComboBox.setEditable(true);
        this.m_protocolComboBox = new JComboBox<String>(new String[]{this.m_lastProtocol, "https"});
        this.m_protocolComboBox.setComponentOrientation(Dictionary.getOrientation());
        this.m_protocolComboBox.setEditable(true);
        this.m_usernameComboBox = new JComboBox<String>(new String[]{this.m_lastUsername});
        this.m_usernameComboBox.setComponentOrientation(Dictionary.getOrientation());
        this.m_usernameComboBox.setEditable(true);
        this.m_passwordField = new JPasswordField();
        this.setComboBoxValues();
        LoginAction loginAction = new LoginAction(this);
        JButton jButton = new JButton(loginAction);
        loginAction.setButton(jButton);
        jButton.setEnabled(false);
        this.getRootPane().setDefaultButton(jButton);
        this.m_passwordField.getDocument().addDocumentListener(new PasswordChangeListener(jButton, this.m_passwordField));
        this.m_passwordField.setAction(loginAction);
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6), BorderFactory.createEtchedBorder()), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.addLabelValueRows(new JLabel[]{jLabel, jLabel2, jLabel3, jLabel4}, new JComponent[]{this.m_serverComboBox, this.m_protocolComboBox, this.m_usernameComboBox, this.m_passwordField}, gridBagLayout, jPanel);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FedoraLogin.this.login_requested = false;
            }
        });
        JButton jButton2 = new JButton(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FedoraLogin.this.login_requested = false;
                FedoraLogin.this.dispose();
            }
        });
        jButton2.setText("Exit");
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        Container container = this.getContentPane();
        container.setComponentOrientation(Dictionary.getOrientation());
        container.setLayout(new BorderLayout());
        this.m_infoPane = new JPanel();
        this.m_infoPane.setComponentOrientation(Dictionary.getOrientation());
        this.m_infoPane.setBackground(TRANSPARENT);
        container.add((Component)this.m_infoPane, "North");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                FedoraLogin.this.m_passwordField.requestFocus();
            }
        });
        this.pack();
        Dimension dimension = this.getSize();
        if (Gatherer.g_man != null) {
            Rectangle rectangle = Gatherer.g_man.getBounds();
            this.setLocation(rectangle.x + (rectangle.width - dimension.width) / 2, rectangle.y + (rectangle.height - dimension.height) / 2);
        } else {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        }
        this.setVisible(true);
    }

    public void saveProperties(JComboBox jComboBox, String string, String string2) {
        jComboBox.insertItemAt(string2, 0);
        if (string2 == null) {
            string2 = (String)jComboBox.getItemAt(0);
        }
        Configuration.setString(string, true, string2);
        int n = 1;
        for (int i = 0; n < 5 && i < jComboBox.getItemCount(); ++i, ++n) {
            String string3 = (String)jComboBox.getItemAt(i);
            if (string3 == null || string3.equals(string2) || string3.equals("")) {
                --n;
                continue;
            }
            Configuration.setString(string + n, true, string3);
        }
    }

    private void setComboBoxValues() {
        Dimension dimension = new Dimension(this.m_serverComboBox.getPreferredSize().width + 20, this.m_serverComboBox.getPreferredSize().height);
        this.m_passwordField.setPreferredSize(dimension);
        this.setComboBoxValues(this.m_serverComboBox, "fedora.server", dimension);
        this.setComboBoxValues(this.m_protocolComboBox, "fedora.protocol", dimension);
        this.setComboBoxValues(this.m_usernameComboBox, "fedora.username", dimension);
        dimension = null;
    }

    private void setComboBoxValues(JComboBox jComboBox, String string, Dimension dimension) {
        String string2 = Configuration.getString(string, true);
        boolean bl = string2.equals("");
        if (!bl) {
            jComboBox.removeAllItems();
            jComboBox.addItem(string2);
        }
        int n = 1;
        while (!bl) {
            string2 = Configuration.getString(string + n, true);
            if (string2.equals("")) {
                bl = true;
            } else {
                jComboBox.addItem(string2);
            }
            ++n;
        }
        jComboBox.setPreferredSize(dimension);
    }

    public void addLabelValueRows(JLabel[] jLabelArray, JComponent[] jComponentArray, GridBagLayout gridBagLayout, Container container) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 6, 6, 6);
        for (int i = 0; i < jLabelArray.length; ++i) {
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagLayout.setConstraints(jLabelArray[i], gridBagConstraints);
            container.add(jLabelArray[i]);
            gridBagConstraints.gridwidth = 0;
            if (!(jComponentArray[i] instanceof JComboBox)) {
                gridBagConstraints.fill = 2;
            } else {
                gridBagConstraints.anchor = 17;
            }
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(jComponentArray[i], gridBagConstraints);
            container.add(jComponentArray[i]);
        }
    }

    public void setErrorMessage(String[] stringArray) {
        this.m_infoPane.removeAll();
        this.m_infoPane.setBackground(LIGHT);
        this.m_infoPane.setLayout(new GridLayout(stringArray.length, 1));
        for (int i = 0; i < stringArray.length; ++i) {
            JLabel jLabel = new JLabel("  " + stringArray[i] + "  ");
            this.m_infoPane.add(jLabel);
        }
        this.m_infoPane.validate();
        this.pack();
    }

    public boolean loginRequested() {
        return this.login_requested;
    }

    public String getLibraryURL() {
        String string = this.m_lastProtocol + "://" + this.m_lastServer + "/fedora/search";
        return string;
    }

    public String getHostname() {
        String[] stringArray = this.m_lastServer.split(":");
        String string = stringArray[0];
        return string;
    }

    public String getPort() {
        String[] stringArray = this.m_lastServer.split(":");
        String string = stringArray[1];
        return string;
    }

    public String getUsername() {
        return this.m_lastUsername;
    }

    public String getPassword() {
        return this.m_lastPassword;
    }

    public String getProtocol() {
        return this.m_lastProtocol;
    }

    public class LoginAction
    extends AbstractAction {
        FedoraLogin m_loginDialog;
        JButton m_button;

        public LoginAction(FedoraLogin fedoraLogin2) {
            super("Login");
            this.m_loginDialog = fedoraLogin2;
        }

        public void setButton(JButton jButton) {
            this.m_button = jButton;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.m_button.isEnabled()) {
                try {
                    String string = (String)FedoraLogin.this.m_serverComboBox.getSelectedItem();
                    int n = string.indexOf(":");
                    if (n == -1) {
                        throw new IOException("Server must be specified as host:port");
                    }
                    String[] stringArray = string.split(":");
                    String string2 = stringArray[0];
                    if (string2.length() == 0) {
                        throw new IOException("No server name provided.");
                    }
                    int n2 = 0;
                    try {
                        n2 = Integer.parseInt(stringArray[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException("Server port must be an integer.");
                    }
                    String string3 = (String)FedoraLogin.this.m_protocolComboBox.getSelectedItem();
                    if (string3.equals("")) {
                        throw new IOException("No protocol provided.");
                    }
                    String string4 = (String)FedoraLogin.this.m_usernameComboBox.getSelectedItem();
                    if (string4.equals("")) {
                        throw new IOException("No username provided.");
                    }
                    String string5 = new String(FedoraLogin.this.m_passwordField.getPassword());
                    FedoraLogin.this.m_lastServer = string2 + ":" + n2;
                    FedoraLogin.this.m_lastProtocol = string3;
                    FedoraLogin.this.m_lastUsername = string4;
                    FedoraLogin.this.m_lastPassword = string5;
                    this.m_loginDialog.saveProperties(FedoraLogin.this.m_serverComboBox, "fedora.server", FedoraLogin.this.m_lastServer);
                    this.m_loginDialog.saveProperties(FedoraLogin.this.m_protocolComboBox, "fedora.protocol", FedoraLogin.this.m_lastProtocol);
                    this.m_loginDialog.saveProperties(FedoraLogin.this.m_usernameComboBox, "fedora.username", FedoraLogin.this.m_lastUsername);
                    Configuration.save();
                    FedoraLogin.this.login_requested = true;
                    this.m_loginDialog.setVisible(false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public class PasswordChangeListener
    implements DocumentListener {
        private JButton m_loginButton;
        private JPasswordField m_passField;

        public PasswordChangeListener(JButton jButton, JPasswordField jPasswordField) {
            this.m_loginButton = jButton;
            this.m_passField = jPasswordField;
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            this.dataChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.dataChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.dataChanged();
        }

        public void dataChanged() {
            if (this.m_passField.getPassword().length == 0) {
                this.m_loginButton.setEnabled(false);
            } else {
                this.m_loginButton.setEnabled(true);
            }
        }
    }
}

