/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.NumberedJTextArea;
import org.greenstone.gatherer.util.Codec;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormatConversionDialog
extends ModalDialog {
    public static final String GSF_FORMAT_GS2_TAG = "gsf:format-gs2";
    private static final String GSF_GS3_ROOT_TAG = "gsf:gs3-root";
    private static final int XMLTIDY = 0;
    private static final int FORMATCONVERTER = 1;
    private static final int FORMATCONVERTER_DOCUMENTNODE = 2;
    private static final int FORMATCONVERTER_CLASSIFIERNODE = 3;
    private static final String[] xmltidy_cmd_args = new String[]{"tidy", "-config", Configuration.getGS3BinPath() + "tidyconfig.cfg", "-utf8", "-wrap", "0", "-raw", "-q"};
    private static final String[] formatconverter_cmd_base_args = new String[]{Configuration.getGS3BinOSPath() + "formatconverter", "--silent"};
    private static final Dimension SIZE = new Dimension(640, 480);
    private File collect_cfg_file = null;
    private Document xml_file_doc = null;
    private NodeList gsf_format_gs2_list = null;
    private int current_index = -1;
    private int dlgResult = 0;
    private int process_exitValue = -1;
    final String WARNING_TITLE = Dictionary.get("General.Warning") + ": " + Dictionary.get("FormatConversionDialog.Invalid_XML") + " " + Dictionary.get("FormatConversionDialog.Invalid_XML_Warning_Title");
    private static final Border EMPTYBORDER = new EmptyBorder(5, 5, 5, 5);
    private JLabel section_label = null;
    private GLIButton cancel_button = null;
    private GLIButton next_button = null;
    private GLIButton accept_all_button = null;
    private GLIButton htmltidy_button = null;
    private GLIButton xmltidy_button = null;
    private NumberedJTextArea gs2_textarea = null;
    private NumberedJTextArea gs3_textarea = null;
    private JLabel count_label = null;
    private JLabel statusbar = null;

    public FormatConversionDialog(File file, Document document, NodeList nodeList) {
        super(Gatherer.g_man, "", true);
        this.collect_cfg_file = file;
        this.xml_file_doc = document;
        this.gsf_format_gs2_list = nodeList;
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("FormatConversionDialog.Title"));
        this.addWindowListener(new WindowClosingListener());
        this.setDefaultCloseOperation(2);
        this.gs2_textarea = new NumberedJTextArea("gs2", Dictionary.get("FormatConversionDialog.GS2_Text_Tooltip"));
        this.gs3_textarea = new NumberedJTextArea("gs3", Dictionary.get("FormatConversionDialog.GS3_Text_Tooltip"));
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        GLIButton gLIButton = new GLIButton(Dictionary.get("FormatConversionDialog.Reconvert"), Dictionary.get("FormatConversionDialog.Reconvert_Tooltip"));
        jPanel.add(this.gs2_textarea.undoButton);
        jPanel.add(this.gs2_textarea.redoButton);
        jPanel.add(gLIButton);
        gLIButton.addActionListener(new ReconvertListener());
        gLIButton.setAlignmentY(0.5f);
        this.section_label = new JLabel("Section Label Goes Here");
        this.section_label.setBorder(EMPTYBORDER);
        this.section_label.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        this.xmltidy_button = new GLIButton(Dictionary.get("FormatConversionDialog.XHTML_Tidy"), Dictionary.get("FormatConversionDialog.XHTML_Tidy_Tooltip"));
        this.xmltidy_button.addActionListener(new XMLTidyButtonListener());
        jPanel2.add(this.gs3_textarea.undoButton);
        jPanel2.add(this.gs3_textarea.redoButton);
        jPanel2.add(this.xmltidy_button);
        JPanel jPanel3 = new JPanel(new FlowLayout());
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        this.count_label = new JLabel("<count>");
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("FormatConversionDialog.Cancel_Tooltip"));
        this.next_button = new GLIButton(Dictionary.get("FormatConversionDialog.Next"), Dictionary.get("FormatConversionDialog.Next_Tooltip"));
        this.accept_all_button = new GLIButton(Dictionary.get("FormatConversionDialog.Accept_All"), Dictionary.get("FormatConversionDialog.Accept_All_Tooltip"));
        this.cancel_button.addActionListener(new CancelButtonListener());
        this.next_button.addActionListener(new NextButtonListener());
        this.accept_all_button.addActionListener(new AcceptAllButtonListener());
        jPanel3.add(this.cancel_button);
        jPanel3.add(this.next_button);
        jPanel3.add(this.accept_all_button);
        jPanel3.add(this.count_label);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        jPanel4.setBorder(EMPTYBORDER);
        jPanel4.add(new JScrollPane(this.gs2_textarea));
        jPanel4.add(jPanel);
        jPanel4.add(new JScrollPane(this.gs3_textarea));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        jPanel5.setBorder(EMPTYBORDER);
        jPanel5.add(jPanel2);
        jPanel5.add(jPanel3);
        this.statusbar = new JLabel("");
        this.statusbar.setBorder(EMPTYBORDER);
        this.statusbar.setAlignmentX(0.5f);
        jPanel5.add(this.statusbar);
        JPanel jPanel6 = (JPanel)this.getContentPane();
        jPanel6.setComponentOrientation(Dictionary.getOrientation());
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)this.section_label, "North");
        jPanel6.add((Component)jPanel4, "Center");
        jPanel6.add((Component)jPanel5, "South");
        this.getRootPane().setDefaultButton(this.next_button);
        Dimension dimension = Configuration.screen_size;
        this.setLocation((dimension.width - FormatConversionDialog.SIZE.width) / 2, (dimension.height - FormatConversionDialog.SIZE.height) / 2);
        dimension = null;
    }

    public int getDialogResult() {
        return this.dlgResult;
    }

    public static int checkForGS2FormatStatements(File file) {
        Document document;
        Element element;
        NodeList nodeList;
        if (Gatherer.GS3 && file.getAbsolutePath().endsWith(".xml") && (nodeList = (element = (document = XMLTools.parseXMLFile(file)).getDocumentElement()).getElementsByTagName(GSF_FORMAT_GS2_TAG)) != null && nodeList.getLength() > 0) {
            Node node = nodeList.item(0);
            NodeList nodeList2 = node.getChildNodes();
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node2 = nodeList2.item(i);
                if (node2.getNodeType() != 4) continue;
                return 0;
            }
            System.err.println("*** Found GS2 format statements in config file to be converted to GS3.");
            if (Gatherer.isGsdlRemote) {
                System.err.println("*** Cannot convert GS2 collections from a remote GS3 server.");
                return 0;
            }
            FormatConversionDialog formatConversionDialog = new FormatConversionDialog(file, document, nodeList);
            formatConversionDialog.convertGS2FormatStatements();
            return formatConversionDialog.getDialogResult();
        }
        return 0;
    }

    public String runInteractiveProgram(int n, String string) {
        String[] stringArray;
        String string2 = "";
        this.process_exitValue = -1;
        switch (n) {
            case 0: {
                stringArray = xmltidy_cmd_args;
                break;
            }
            case 1: {
                stringArray = formatconverter_cmd_base_args;
                break;
            }
            case 2: 
            case 3: {
                stringArray = new String[formatconverter_cmd_base_args.length + 1];
                System.arraycopy(formatconverter_cmd_base_args, 0, stringArray, 0, formatconverter_cmd_base_args.length);
                if (n == 2) {
                    stringArray[stringArray.length - 1] = "--documentNode";
                    break;
                }
                if (n != 3) break;
                stringArray[stringArray.length - 1] = "--classifierNode";
                break;
            }
            default: {
                System.err.println("*** Unrecognised program code: " + n);
                return string2;
            }
        }
        SafeProcess safeProcess = new SafeProcess(stringArray);
        safeProcess.setInputString(string);
        safeProcess.setSplitStdErrorNewLines(true);
        safeProcess.runProcess();
        string2 = safeProcess.getStdOutput();
        String string3 = safeProcess.getStdError();
        if (!string3.equals("")) {
            System.err.println("*** Process errorstream: \n" + string3 + "\n****");
        }
        return string2;
    }

    public void convertGS2FormatStatements() {
        int n = this.gsf_format_gs2_list.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)this.gsf_format_gs2_list.item(i);
            String string = XMLTools.getElementTextValue(element);
            this.processFormatStatement(i, string);
        }
        this.increment();
        this.setVisible(true);
    }

    private String processFormatStatement(int n, String string) {
        boolean bl;
        String string2 = "";
        boolean bl2 = string.toLowerCase().startsWith("<td");
        int n2 = this.formatConverterMode(n);
        String string3 = this.runInteractiveProgram(n2, string);
        String string4 = string3 = string3.replaceAll(">\\s+<", "><");
        String string5 = XMLTools.parseDOM(string3 = this.addSurroundingTags(string3));
        if (!string5.startsWith("well-formed !")) {
            String string6 = this.runInteractiveProgram(0, string4);
            if (this.process_exitValue >= 2) {
                string2 = Dictionary.get("FormatConversionDialog.Tidy_Failed") + " " + Dictionary.get("FormatConversionDialog.XML_Still_Invalid");
            } else {
                string2 = "";
                string4 = string6;
                string4 = this.removeHTMLTags(n, string4, bl2);
                string3 = this.addSurroundingTags(string4);
            }
        }
        if (!(bl = this.setGS3Format(n, string3)) && string2.equals("")) {
            string2 = Dictionary.get("FormatConversionDialog.Tidy_Done") + " " + Dictionary.get("FormatConversionDialog.XML_Still_Invalid");
        }
        return string2;
    }

    private String removeHTMLTags(int n, String string, boolean bl) {
        int n2;
        int n3;
        String string2 = "body>";
        Element element = (Element)this.getParentNode(n);
        if (element.hasAttribute("match") && (!element.hasAttribute("mode") || !element.getAttribute("mode").equals("horizontal")) && bl) {
            string2 = "tr>";
        }
        if ((n3 = string.indexOf(string2)) != -1) {
            string = string.substring(n3 + string2.length());
        }
        if ((n2 = string.lastIndexOf("</" + string2)) != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    private void setGS2Format(int n, String string) {
        XMLTools.setElementTextValue(this.getGS2Format(n), string);
    }

    private boolean setGS3Format(int n, String string) {
        Node node;
        Document document = this.getGS2Format(n).getOwnerDocument();
        Node node2 = null;
        boolean bl = false;
        String string2 = XMLTools.parseDOM(string);
        if (!string2.startsWith("well-formed !")) {
            string = this.removeSurroundingTags(string);
            node2 = document.createElement(GSF_GS3_ROOT_TAG);
            node = document.createCDATASection(string);
            node2.appendChild(node);
            bl = false;
        } else {
            node = XMLTools.getDOM(string);
            Element element = node.getDocumentElement();
            node2 = document.importNode(element, true);
            bl = true;
        }
        node = this.getGS3Format(n);
        if (node == null) {
            this.getParentNode(n).appendChild(node2);
        } else {
            this.getParentNode(n).replaceChild(node2, node);
        }
        return bl;
    }

    private Node getParentNode(int n) {
        return this.gsf_format_gs2_list.item(n).getParentNode();
    }

    private Element getGS2Format(int n) {
        return (Element)this.gsf_format_gs2_list.item(n);
    }

    private String getGS2FormatString(int n) {
        return XMLTools.getElementTextValue(this.getGS2Format(n));
    }

    private Element getGS3Format(int n) {
        Element element = (Element)this.getParentNode(n);
        NodeList nodeList = element.getElementsByTagName(GSF_GS3_ROOT_TAG);
        if (nodeList.getLength() > 0) {
            return (Element)nodeList.item(0);
        }
        return null;
    }

    private String getGS3FormatString(int n) {
        Element element = this.getGS3Format(n);
        if (element == null) {
            return "";
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 4) continue;
            return nodeList.item(i).getNodeValue();
        }
        StringBuffer stringBuffer = new StringBuffer();
        XMLTools.xmlNodeToString(stringBuffer, element, true, "  ", 0);
        return stringBuffer.toString();
    }

    private int formatConverterMode(int n) {
        String string = "";
        Element element = (Element)this.getParentNode(n);
        String string2 = element.getAttribute("match");
        if (string2.equals("documentNode")) {
            return 2;
        }
        if (string2.equals("classifierNode")) {
            return 3;
        }
        return 1;
    }

    private String getLabel(int n) {
        String string = "";
        Element element = (Element)this.getParentNode(n);
        string = element.getAttribute("match");
        if (element.hasAttribute("mode")) {
            string = string + " > " + element.getAttribute("mode");
        }
        Element element2 = (Element)element.getParentNode().getParentNode();
        string = element2.getTagName() + " > " + string;
        return string;
    }

    private String makeLines(String string) {
        return string.replaceAll(">\\s+<", ">\n<");
    }

    private String singleLine(String string) {
        return string.replace(">\n<", "> <");
    }

    private String removeSurroundingTags(String string) {
        return string.replaceAll("<gsf:gs3-root xmlns:gsf=(\"|')http://www.greenstone.org/greenstone3/schema/ConfigFormat(\"|') xmlns:gslib=(\"|')http://www.greenstone.org/skinning(\"|') xmlns:xsl=(\"|')http://www.w3.org/1999/XSL/Transform(\"|')>\n?", "").replaceAll("\n?</gsf:gs3-root>", "");
    }

    private String addSurroundingTags(String string) {
        return "<gsf:gs3-root xmlns:gsf='http://www.greenstone.org/greenstone3/schema/ConfigFormat' xmlns:gslib='http://www.greenstone.org/skinning' xmlns:xsl='http://www.w3.org/1999/XSL/Transform'>" + string + "</" + GSF_GS3_ROOT_TAG + ">";
    }

    private boolean increment() {
        ++this.current_index;
        this.section_label.setText(this.getLabel(this.current_index));
        this.gs2_textarea.setText(this.makeLines(this.getGS2FormatString(this.current_index)));
        this.gs3_textarea.setText(this.removeSurroundingTags(this.getGS3FormatString(this.current_index)));
        this.statusbar.setText("");
        this.gs2_textarea.discardAllEdits();
        this.gs3_textarea.discardAllEdits();
        int n = this.gsf_format_gs2_list.getLength();
        this.count_label.setText(this.current_index + 1 + " / " + n);
        return this.current_index + 1 != n;
    }

    private void setStatus(String string) {
        this.statusbar.setText(string);
    }

    private void setErrorStatus(String string) {
        this.statusbar.setBackground(Color.red);
        this.statusbar.setText(string);
    }

    @Override
    public void dispose() {
        if (this.dlgResult != 1) {
            String[] stringArray;
            int n = this.gsf_format_gs2_list.getLength();
            for (int i = n - 1; i >= 0; --i) {
                int n2;
                stringArray = (String[])this.getParentNode(i);
                NodeList nodeList = stringArray.getChildNodes();
                for (int j = n2 = nodeList.getLength() - 1; j >= 0; --j) {
                    Node node;
                    Object object;
                    Node node2;
                    Node node3 = nodeList.item(j);
                    if (node3.getNodeName().equals(GSF_FORMAT_GS2_TAG)) {
                        node2 = (Element)node3;
                        object = XMLTools.getElementTextValue((Element)node2);
                        object = Codec.transform((String)object, "ESCAPEDHTML_TO_UNESCAPED");
                        Node node4 = XMLTools.getNodeTextNode((Element)node2);
                        node = node2.getOwnerDocument().createCDATASection((String)object);
                        node2.replaceChild(node, node4);
                        continue;
                    }
                    if (!node3.getNodeName().equals(GSF_GS3_ROOT_TAG)) continue;
                    node2 = node3;
                    object = node2.getChildNodes();
                    for (int k = 0; k < object.getLength(); ++k) {
                        node = object.item(k).cloneNode(true);
                        stringArray.appendChild(node);
                    }
                    node2 = stringArray.removeChild(node2);
                    node2 = null;
                }
            }
            Element element = this.xml_file_doc.getDocumentElement();
            stringArray = new String[]{"format", "displayItem"};
            XMLTools.writeXMLFile(this.collect_cfg_file, this.xml_file_doc, stringArray);
        }
        super.dispose();
    }

    private class XMLTidyButtonListener
    implements ActionListener {
        private XMLTidyButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = FormatConversionDialog.this.gs3_textarea.getText();
            boolean bl = string.trim().toLowerCase().startsWith("<td");
            String string2 = FormatConversionDialog.this.runInteractiveProgram(0, string);
            if (FormatConversionDialog.this.process_exitValue >= 2) {
                FormatConversionDialog.this.setErrorStatus(Dictionary.get("FormatConversionDialog.Tidy_Failed"));
            } else {
                string = string2;
                string = FormatConversionDialog.this.removeHTMLTags(FormatConversionDialog.this.current_index, string, bl);
                String string3 = FormatConversionDialog.this.addSurroundingTags(string);
                boolean bl2 = FormatConversionDialog.this.setGS3Format(FormatConversionDialog.this.current_index, string3);
                FormatConversionDialog.this.gs3_textarea.setText(FormatConversionDialog.this.removeSurroundingTags(FormatConversionDialog.this.getGS3FormatString(FormatConversionDialog.this.current_index)));
                if (bl2) {
                    FormatConversionDialog.this.statusbar.setText(Dictionary.get("FormatConversionDialog.Tidy_Done"));
                } else {
                    FormatConversionDialog.this.setErrorStatus(Dictionary.get("FormatConversionDialog.Tidy_Done") + " " + Dictionary.get("FormatConversionDialog.Error_GS3_Format") + " " + Dictionary.get("FormatConversionDialog.Invalid_XML"));
                }
            }
        }
    }

    private class AcceptAllButtonListener
    implements ActionListener {
        private AcceptAllButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            FormatConversionDialog.this.setGS2Format(FormatConversionDialog.this.current_index, FormatConversionDialog.this.gs2_textarea.getText());
            String string = FormatConversionDialog.this.gs3_textarea.getText();
            boolean bl = FormatConversionDialog.this.setGS3Format(FormatConversionDialog.this.current_index, FormatConversionDialog.this.addSurroundingTags(string));
            String string2 = "";
            if (!bl) {
                FormatConversionDialog.this.setErrorStatus(Dictionary.get("FormatConversionDialog.Invalid_XML"));
                string2 = Dictionary.get("FormatConversionDialog.Invalid_XML") + " " + Dictionary.get("FormatConversionDialog.Cancel_Or_Continue_Next");
            }
            for (n = FormatConversionDialog.this.current_index + 1; bl && n < FormatConversionDialog.this.gsf_format_gs2_list.getLength(); ++n) {
                string = FormatConversionDialog.this.getGS3FormatString(n);
                String string3 = XMLTools.parseDOM(string);
                if (string3.startsWith("well-formed !")) continue;
                bl = false;
                string2 = Dictionary.get("FormatConversionDialog.Cancel_Or_Accept_All");
            }
            if (!bl && (n = JOptionPane.showConfirmDialog(FormatConversionDialog.this, string2, FormatConversionDialog.this.WARNING_TITLE, 2, 2)) == 2) {
                return;
            }
            FormatConversionDialog.this.dispose();
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FormatConversionDialog.this.dlgResult = 1;
            FormatConversionDialog.this.dispose();
        }
    }

    private class NextButtonListener
    implements ActionListener {
        private NextButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string;
            int n;
            FormatConversionDialog.this.setGS2Format(FormatConversionDialog.this.current_index, FormatConversionDialog.this.singleLine(FormatConversionDialog.this.gs2_textarea.getText()));
            boolean bl = FormatConversionDialog.this.setGS3Format(FormatConversionDialog.this.current_index, FormatConversionDialog.this.addSurroundingTags(FormatConversionDialog.this.gs3_textarea.getText()));
            if (!bl && (n = JOptionPane.showConfirmDialog(FormatConversionDialog.this, string = Dictionary.get("FormatConversionDialog.Invalid_XML") + " " + Dictionary.get("FormatConversionDialog.Cancel_Or_Continue_Next"), FormatConversionDialog.this.WARNING_TITLE, 2, 2)) == 2) {
                return;
            }
            if (FormatConversionDialog.this.increment()) {
                FormatConversionDialog.this.repaint();
            } else {
                FormatConversionDialog.this.next_button.setEnabled(false);
                FormatConversionDialog.this.getRootPane().setDefaultButton(FormatConversionDialog.this.accept_all_button);
            }
        }
    }

    private class ReconvertListener
    implements ActionListener {
        private ReconvertListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = FormatConversionDialog.this.singleLine(FormatConversionDialog.this.gs2_textarea.getText());
            String string2 = FormatConversionDialog.this.processFormatStatement(FormatConversionDialog.this.current_index, string);
            FormatConversionDialog.this.gs3_textarea.setText(FormatConversionDialog.this.removeSurroundingTags(FormatConversionDialog.this.getGS3FormatString(FormatConversionDialog.this.current_index)));
            if (!string2.equals("")) {
                FormatConversionDialog.this.setErrorStatus(string2);
            } else {
                FormatConversionDialog.this.statusbar.setText("");
            }
        }
    }

    private class WindowClosingListener
    extends WindowAdapter {
        private WindowClosingListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            FormatConversionDialog.this.dlgResult = 1;
        }
    }
}

