/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.util.Utility;

public class GComboBox
extends JComboBox {
    private Color background = null;
    private Color foreground = null;
    private Color editable_background = null;
    private Color editable_foreground = null;
    private Color selection_background = null;
    private Color selection_foreground = null;
    private boolean sort_objects = true;

    public GComboBox() {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.init();
        this.setOpaque(!Utility.isMac());
    }

    public GComboBox(boolean bl) {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.setEditable(bl);
        this.init();
    }

    public GComboBox(ArrayList arrayList) {
        super(arrayList.toArray());
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.init();
    }

    public GComboBox(ArrayList arrayList, boolean bl) {
        super(arrayList.toArray());
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.setEditable(bl);
        this.init();
    }

    public GComboBox(ArrayList arrayList, boolean bl, boolean bl2) {
        super(arrayList.toArray());
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.setEditable(bl);
        this.setSorted(bl2);
        this.init();
    }

    public GComboBox(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.init();
    }

    public GComboBox(ComboBoxModel comboBoxModel, boolean bl) {
        super(comboBoxModel);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.setEditable(bl);
        this.init();
    }

    public GComboBox(Object[] objectArray) {
        super(objectArray);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.init();
    }

    public GComboBox(Object[] objectArray, boolean bl) {
        super(objectArray);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.setEditable(bl);
        this.init();
    }

    public GComboBox(Object[] objectArray, boolean bl, boolean bl2) {
        super(objectArray);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.setEditable(bl);
        this.setSorted(bl2);
        this.init();
    }

    public GComboBox(Vector vector) {
        super(vector);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.init();
    }

    public GComboBox(Vector vector, boolean bl) {
        super(vector);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setOpaque(!Utility.isMac());
        this.setEditable(bl);
        this.init();
    }

    public void setSorted(boolean bl) {
        this.sort_objects = bl;
    }

    public int add(Object object) {
        if (this.dataModel instanceof Model) {
            return ((Model)this.dataModel).add(object);
        }
        return -1;
    }

    public Object get(int n) {
        return this.dataModel.getElementAt(n);
    }

    public void clear() {
        if (this.dataModel instanceof Model) {
            ((Model)this.dataModel).clear();
        }
    }

    public void init() {
        Model model = new Model();
        ComboBoxModel comboBoxModel = this.getModel();
        this.setModel(model);
        this.setOpaque(true);
        for (int i = 0; i < comboBoxModel.getSize(); ++i) {
            model.add(comboBoxModel.getElementAt(i));
        }
        UI uI = new UI();
        this.setUI(uI);
        uI.setButtonBackground();
        this.background = Configuration.getColor("coloring.collection_tree_background", false);
        this.foreground = Configuration.getColor("coloring.collection_tree_foreground", false);
        this.editable_background = Configuration.getColor("coloring.editable_background", false);
        this.editable_foreground = Configuration.getColor("coloring.editable_foreground", false);
        this.selection_background = Configuration.getColor("coloring.collection_selection_background", false);
        this.selection_foreground = Configuration.getColor("coloring.collection_selection_foreground", false);
        if (this.isEditable()) {
            this.setBackground(this.editable_background);
            this.setForeground(this.editable_foreground);
        } else {
            this.setBackground(this.background);
            this.setForeground(this.foreground);
        }
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setRenderer(new Renderer());
    }

    @Override
    public void setBackground(Color color) {
    }

    public void setBackgroundEditableColor(Color color) {
        this.editable_background = color;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.background = color;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.selection_background = color;
    }

    @Override
    public void setEditable(boolean bl) {
        this.setEditor(new Editor());
        super.setEditable(bl);
        if (this.isEditable()) {
            this.setBackground(this.editable_background);
            this.setForeground(this.editable_foreground);
        } else {
            this.setBackground(this.background);
            this.setForeground(this.foreground);
        }
    }

    public void setTextEditableColor(Color color) {
        this.editable_foreground = color;
    }

    public void setTextNonSelectionColor(Color color) {
        this.foreground = color;
    }

    public void setTextSelectionColor(Color color) {
        this.selection_foreground = color;
    }

    private class UI
    extends BasicComboBoxUI {
        @Override
        protected ComboPopup createPopup() {
            BasicComboPopup basicComboPopup = new BasicComboPopup(this.comboBox);
            basicComboPopup.getAccessibleContext().setAccessibleParent(this.comboBox);
            return basicComboPopup;
        }

        public void setButtonBackground() {
            this.arrowButton.setBackground(Configuration.getColor("coloring.button_background", false));
        }
    }

    private class Renderer
    extends JLabel
    implements ListCellRenderer {
        public Renderer() {
            super("");
            this.setOpaque(true);
            this.setComponentOrientation(Dictionary.getOrientation());
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            if (bl) {
                this.setBackground(GComboBox.this.selection_background);
                this.setForeground(GComboBox.this.selection_foreground);
            } else if (GComboBox.this.isEditable()) {
                this.setBackground(GComboBox.this.editable_background);
                this.setForeground(GComboBox.this.editable_foreground);
            } else {
                this.setBackground(GComboBox.this.background);
                this.setForeground(GComboBox.this.foreground);
            }
            return this;
        }
    }

    private class Model
    extends DefaultComboBoxModel {
        private Model() {
        }

        public int add(Object object) {
            int n = 0;
            String string = object.toString().toLowerCase();
            while (object != null && n < this.getSize()) {
                String string2 = this.getElementAt(n).toString().toLowerCase();
                int n2 = string.compareTo(string2);
                if (GComboBox.this.sort_objects && n2 < 0) {
                    this.insertElementAt(object, n);
                    object = null;
                    continue;
                }
                if (n2 == 0) {
                    object = null;
                    continue;
                }
                ++n;
            }
            if (object != null) {
                n = this.getSize();
                this.addElement(object);
            }
            return n;
        }

        public void clear() {
            this.removeAllElements();
        }
    }

    private class Editor
    extends JTextField
    implements ComboBoxEditor {
        public Editor() {
            this.setOpaque(true);
            if (this.isEditable()) {
                this.setBackground(GComboBox.this.editable_background);
                this.setForeground(GComboBox.this.editable_foreground);
            } else {
                this.setBackground(GComboBox.this.background);
                this.setForeground(GComboBox.this.foreground);
            }
            this.setSelectionColor(GComboBox.this.selection_background);
            this.setSelectedTextColor(GComboBox.this.selection_foreground);
        }

        @Override
        public Component getEditorComponent() {
            return this;
        }

        @Override
        public Object getItem() {
            return this.getText();
        }

        @Override
        public void setItem(Object object) {
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
        }
    }
}

