/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataValue;
import org.greenstone.gatherer.metadata.MetadataValueTreeNode;
import org.greenstone.gatherer.util.PatternTokenizer;

public class MetadataValueTreePane
extends JPanel {
    private boolean ignore_tree_selection_event = false;
    private MetadataValue metadata_value = null;
    private CardLayout card_layout = null;
    private String METADATA_VALUE_TREE_CARD = "";
    private String EXTRACTED_METADATA_ELEMENT_SELECTED_CARD = "Extracted metadata element selected";
    private String INHERITED_METADATA_SELECTED_CARD = "Inherited metadata selected";
    private String NOT_ONE_FILE_ONLY_METADATA_SELECTED_CARD = "Not one file only metadata selected";
    private String NO_METADATA_ELEMENT_SELECTED_CARD = "No metadata element selected";
    private JLabel metadata_value_tree_label = new JLabel();
    private JTextArea extracted_metadata_element_selected_message;
    private JTree metadata_value_tree;

    public MetadataValueTreePane() {
        this.setComponentOrientation(Dictionary.getOrientation());
        this.metadata_value_tree_label.setComponentOrientation(Dictionary.getOrientation());
        this.metadata_value_tree = new JTree();
        this.metadata_value_tree.setComponentOrientation(Dictionary.getOrientation());
        this.metadata_value_tree.getSelectionModel().setSelectionMode(1);
        this.metadata_value_tree.setModel(null);
        this.metadata_value_tree.setRootVisible(false);
        this.metadata_value_tree.putClientProperty("JTree.lineStyle", "Angled");
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.metadata_value_tree_label, "North");
        JScrollPane jScrollPane = new JScrollPane(this.metadata_value_tree);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)jScrollPane, "Center");
        this.extracted_metadata_element_selected_message = new JTextArea("");
        this.extracted_metadata_element_selected_message.setComponentOrientation(Dictionary.getOrientation());
        this.extracted_metadata_element_selected_message.setEditable(false);
        this.extracted_metadata_element_selected_message.setLineWrap(true);
        this.extracted_metadata_element_selected_message.setOpaque(false);
        this.extracted_metadata_element_selected_message.setWrapStyleWord(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setBorder(BorderFactory.createEmptyBorder(25, 0, 0, 0));
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)this.extracted_metadata_element_selected_message, "Center");
        JTextArea jTextArea = new JTextArea(Dictionary.get("EnrichPane.InheritedMetadataSelected"));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setOpaque(false);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setBorder(BorderFactory.createEmptyBorder(25, 0, 0, 0));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jTextArea, "Center");
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JTextArea jTextArea2 = new JTextArea(Dictionary.get("EnrichPane.NotOneFileOnlyMetadataSelected"));
        jTextArea2.setEditable(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setOpaque(false);
        jTextArea2.setWrapStyleWord(true);
        jTextArea2.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(BorderFactory.createEmptyBorder(25, 0, 0, 0));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jTextArea2, "Center");
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("EnrichPane.No_Metadata_Element"));
        jLabel.setHorizontalAlignment(0);
        jLabel.setOpaque(false);
        jLabel.setVerticalAlignment(0);
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jLabel, "Center");
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        this.card_layout = new CardLayout();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setFont(Configuration.getFont("general.font", false));
        this.setLayout(this.card_layout);
        this.add((Component)jPanel5, this.NO_METADATA_ELEMENT_SELECTED_CARD);
        this.add((Component)jPanel2, this.EXTRACTED_METADATA_ELEMENT_SELECTED_CARD);
        this.add((Component)jPanel3, this.INHERITED_METADATA_SELECTED_CARD);
        this.add((Component)jPanel4, this.NOT_ONE_FILE_ONLY_METADATA_SELECTED_CARD);
        this.add((Component)jPanel, this.METADATA_VALUE_TREE_CARD);
    }

    public void addMetadataValueTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.metadata_value_tree.addTreeSelectionListener(treeSelectionListener);
    }

    private TreePath getClosestPath(String string) {
        if (this.metadata_value_tree.getModel() == null) {
            return null;
        }
        MetadataValueTreeNode metadataValueTreeNode = (MetadataValueTreeNode)this.metadata_value_tree.getModel().getRoot();
        PatternTokenizer patternTokenizer = new PatternTokenizer(string, "|");
        block0: while (patternTokenizer.hasMoreTokens()) {
            MetadataValueTreeNode metadataValueTreeNode2;
            int n;
            String string2 = patternTokenizer.nextToken();
            if (patternTokenizer.hasMoreTokens()) {
                for (n = 0; n < metadataValueTreeNode.getChildCount(); ++n) {
                    metadataValueTreeNode2 = (MetadataValueTreeNode)metadataValueTreeNode.getChildAt(n);
                    if (!metadataValueTreeNode2.getValue().equals(string2)) continue;
                    metadataValueTreeNode = metadataValueTreeNode2;
                    continue block0;
                }
                continue;
            }
            for (n = 0; n < metadataValueTreeNode.getChildCount(); ++n) {
                metadataValueTreeNode2 = (MetadataValueTreeNode)metadataValueTreeNode.getChildAt(n);
                if (!metadataValueTreeNode2.getFullValue().startsWith(string)) continue;
                return new TreePath(metadataValueTreeNode2.getPath());
            }
            return null;
        }
        return new TreePath(metadataValueTreeNode.getPath());
    }

    public MetadataValueTreeNode getSelectedMetadataValueTreeNode() {
        if (this.metadata_value_tree.getSelectionCount() == 0 || this.ignore_tree_selection_event) {
            return null;
        }
        return (MetadataValueTreeNode)this.metadata_value_tree.getSelectionPath().getLastPathComponent();
    }

    public void rebuild(MetadataValue metadataValue) {
        if (metadataValue == this.metadata_value) {
            return;
        }
        MetadataElement metadataElement = this.metadata_value != null ? this.metadata_value.getMetadataElement() : null;
        this.metadata_value = metadataValue;
        if (metadataValue == null) {
            this.metadata_value_tree.setModel(null);
            this.card_layout.show(this, this.NO_METADATA_ELEMENT_SELECTED_CARD);
            return;
        }
        if (metadataValue.isInheritedMetadata()) {
            this.card_layout.show(this, this.INHERITED_METADATA_SELECTED_CARD);
            return;
        }
        if (!metadataValue.isOneFileOnlyMetadata()) {
            this.card_layout.show(this, this.NOT_ONE_FILE_ONLY_METADATA_SELECTED_CARD);
            return;
        }
        MetadataElement metadataElement2 = metadataValue.getMetadataElement();
        if (metadataElement2.isExtractedMetadataElement()) {
            String[] stringArray = new String[]{metadataElement2.getDisplayName()};
            this.extracted_metadata_element_selected_message.setText(Dictionary.get("EnrichPane.AutoMessage", stringArray));
            this.card_layout.show(this, this.EXTRACTED_METADATA_ELEMENT_SELECTED_CARD);
            return;
        }
        String[] stringArray = new String[]{metadataElement2.getDisplayName()};
        this.metadata_value_tree_label.setText(Dictionary.get("EnrichPane.ExistingValues", stringArray));
        this.metadata_value_tree.setModel(metadataElement2.getMetadataValueTreeModel());
        this.card_layout.show(this, this.METADATA_VALUE_TREE_CARD);
        this.selectBestPathForMetadataValue(metadataValue.getFullValue());
    }

    public void selectBestPathForMetadataValue(String string) {
        TreePath treePath = this.getClosestPath(string);
        this.ignore_tree_selection_event = true;
        this.metadata_value_tree.setSelectionPath(treePath);
        this.ignore_tree_selection_event = false;
        if (string.endsWith("|") && !this.metadata_value_tree.isExpanded(treePath)) {
            this.metadata_value_tree.expandPath(treePath);
        }
        this.metadata_value_tree.makeVisible(treePath);
        final Rectangle rectangle = this.metadata_value_tree.getPathBounds(treePath);
        if (rectangle != null) {
            rectangle.x = 0;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MetadataValueTreePane.this.metadata_value_tree.scrollRectToVisible(rectangle);
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }
}

