/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.greenstone.gatherer.Dictionary;

public class NonWhitespaceField
extends JTextField {
    public NonWhitespaceField() {
        this.setComponentOrientation(Dictionary.getOrientation());
    }

    public NonWhitespaceField(String string) {
        super(string);
        this.setComponentOrientation(Dictionary.getOrientation());
    }

    @Override
    protected Document createDefaultModel() {
        return new NonWhitespaceDocument();
    }

    static class NonWhitespaceDocument
    extends PlainDocument {
        NonWhitespaceDocument() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            char[] cArray = string.toCharArray();
            StringBuffer stringBuffer = new StringBuffer("");
            for (int i = 0; i < cArray.length; ++i) {
                if (Character.isWhitespace(cArray[i])) continue;
                stringBuffer.append(cArray[i]);
            }
            super.insertString(n, stringBuffer.toString(), attributeSet);
        }
    }
}

