/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.gui.GLIButton;

public class NumberedJTextArea
extends RSyntaxTextArea
implements UndoableEditListener,
ActionListener {
    String id = null;
    public final GLIButton undoButton;
    public final GLIButton redoButton;

    public NumberedJTextArea() {
        this("", "", "text/xml");
    }

    public NumberedJTextArea(String string) {
        this("", string, "text/xml");
    }

    public NumberedJTextArea(String string, String string2) {
        this(string, string2, "text/xml");
    }

    public NumberedJTextArea(String string, String string2, String string3) {
        this.id = string;
        this.undoButton = new GLIButton(Dictionary.get("General.Undo"), Dictionary.get("General.Undo_Tooltip"));
        this.undoButton.setEnabled(false);
        this.redoButton = new GLIButton(Dictionary.get("General.Redo"), Dictionary.get("General.Redo_Tooltip"));
        this.redoButton.setEnabled(false);
        this.undoButton.addActionListener(this);
        this.redoButton.addActionListener(this);
        this.getDocument().addUndoableEditListener(this);
        this.setSyntaxEditingStyle(string3);
        this.setBracketMatchingEnabled(true);
        this.setAnimateBracketMatching(true);
        this.setAntiAliasingEnabled(true);
        this.setAutoIndentEnabled(true);
        this.setPaintMarkOccurrencesBorder(false);
        this.setOpaque(false);
        this.setBackground(Configuration.getColor("coloring.editable_background", false));
        this.setCaretPosition(0);
        this.setLineWrap(true);
        this.setRows(11);
        this.setWrapStyleWord(false);
        this.setToolTipText(string2);
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(Color.white);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        super.paintComponent(graphics);
        if (rectangle.x < insets.left) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getHeight();
            int n2 = fontMetrics.getAscent() + insets.top;
            int n3 = (rectangle.y + insets.top) / n + 1;
            if (n2 < rectangle.y) {
                n2 = n3 * n - (n - fontMetrics.getAscent());
            }
            int n4 = n2 + rectangle.height + n;
            int n5 = insets.left;
            n5 -= this.getFontMetrics(this.getFont()).stringWidth(Math.max(this.getRows(), this.getLineCount() + 1) + " ");
            if (!this.getText().trim().equals("")) {
                graphics.setColor(Color.DARK_GRAY);
            } else {
                graphics.setColor(Color.white);
            }
            int n6 = ("" + Math.max(this.getRows(), this.getLineCount() + 1)).length();
            while (n2 < n4) {
                graphics.drawString(n3 + "  ", n5, n2);
                n2 += n;
                ++n3;
            }
        }
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets(new Insets(0, 0, 0, 0));
        insets.left += this.getFontMetrics(this.getFont()).stringWidth(Math.max(this.getRows(), this.getLineCount() + 1) + " ");
        return insets;
    }

    @Override
    public void undoLastAction() {
        super.undoLastAction();
        this.redoButton.setEnabled(true);
        if (!this.canUndo()) {
            this.undoButton.setEnabled(false);
        } else {
            this.undoButton.setEnabled(true);
        }
    }

    @Override
    public void redoLastAction() {
        super.redoLastAction();
        this.undoButton.setEnabled(true);
        if (!this.canRedo()) {
            this.redoButton.setEnabled(false);
        } else {
            this.redoButton.setEnabled(true);
        }
    }

    @Override
    public void discardAllEdits() {
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
        super.discardAllEdits();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block12: {
            if (actionEvent.getSource() == this.undoButton) {
                try {
                    if (this.canUndo()) {
                        this.undoLastAction();
                    }
                    if (!this.canUndo()) {
                        this.undoButton.setEnabled(false);
                        break block12;
                    }
                    this.undoButton.setEnabled(true);
                }
                catch (Exception exception) {
                    System.err.println("Exception trying to undo: " + exception.getMessage());
                    exception.printStackTrace();
                }
            } else if (actionEvent.getSource() == this.redoButton) {
                try {
                    if (this.canRedo()) {
                        this.redoLastAction();
                    }
                    if (!this.canRedo()) {
                        this.redoButton.setEnabled(false);
                    } else {
                        this.redoButton.setEnabled(true);
                    }
                }
                catch (Exception exception) {
                    System.err.println("Exception trying to redo: " + exception.getMessage());
                    exception.printStackTrace();
                }
            }
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        this.undoButton.setEnabled(true);
        this.redoButton.setEnabled(false);
    }
}

