/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Document;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.Argument;
import org.greenstone.gatherer.cdm.ArgumentControl;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.collection.ScriptOptions;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.AppendLineOnlyFileDocument;
import org.greenstone.gatherer.util.AppendLineOnlyFileDocumentOwner;

public class OptionsPane
extends JPanel
implements AppendLineOnlyFileDocumentOwner,
MouseListener {
    public static final char SUCCESSFUL = 's';
    public static final char UNSUCCESSFUL = 'u';
    public static final char CANCELLED = 'c';
    public static final char UNKNOWN = 'x';
    public static final char SCHEDULED = 'd';
    private static int BUILD = 0;
    private static int IMPORT = 1;
    private static int SCHEDULE = 2;
    private static int MINIMUM_ROWS = 15;
    public JTextArea log_textarea = null;
    private ArrayList current_controls;
    private ScriptOptions build_options = null;
    private ScriptOptions import_options = null;
    private ScriptOptions schedule_options = null;
    private FileEntry file_entry = null;
    private JPanel log_pane = null;
    private JList log_list = null;
    private Vector writing_documents;

    public OptionsPane(ScriptOptions scriptOptions, ScriptOptions scriptOptions2, ScriptOptions scriptOptions3) {
        this.build_options = scriptOptions2;
        this.import_options = scriptOptions;
        this.schedule_options = scriptOptions3;
        this.current_controls = new ArrayList();
        this.writing_documents = new Vector();
        this.setComponentOrientation(Dictionary.getOrientation());
        this.log_textarea = new JTextArea();
        this.log_textarea.setComponentOrientation(Dictionary.getOrientation());
        this.log_textarea.setEditable(false);
        TestingPreparation.setIndividualSubcomponentNames(this, this.log_textarea);
    }

    public JPanel buildBuild(JPanel jPanel) {
        int n;
        if (jPanel == null) {
            this.current_controls.clear();
        }
        ArrayList<MyArgumentControl> arrayList = new ArrayList<MyArgumentControl>();
        int n2 = Configuration.getMode();
        int n3 = this.build_options.getArgumentCount();
        for (n = 0; n < n3; ++n) {
            Argument argument = this.build_options.getArgument(n);
            if (argument.isHiddenGLI() || argument.getModeLevel() > n2) continue;
            boolean bl = this.build_options.getValueEnabled(argument.getName());
            String string = this.build_options.getValue(argument.getName());
            MyArgumentControl myArgumentControl = new MyArgumentControl(BUILD, argument, bl, string);
            arrayList.add(myArgumentControl);
        }
        this.current_controls.addAll(arrayList);
        if (jPanel == null || n2 >= 3) {
            jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            n = arrayList.size();
            if (n2 >= 3) {
                if (n < MINIMUM_ROWS) {
                    n = MINIMUM_ROWS;
                }
                jPanel.setLayout(new GridLayout(n, 1, 5, 5));
            } else {
                jPanel.setLayout(new GridLayout(0, 1, 5, 5));
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            jPanel.add((JComponent)arrayList.get(n));
        }
        jPanel.addMouseListener(this);
        arrayList = null;
        return jPanel;
    }

    public JPanel buildSchedule(JPanel jPanel) {
        int n;
        if (jPanel == null) {
            this.current_controls.clear();
        }
        ArrayList<MyArgumentControl> arrayList = new ArrayList<MyArgumentControl>();
        int n2 = Configuration.getMode();
        int n3 = this.schedule_options.getArgumentCount();
        for (n = 0; n < n3; ++n) {
            Argument argument = this.schedule_options.getArgument(n);
            if (argument.isHiddenGLI() || argument.getModeLevel() > n2) continue;
            boolean bl = this.schedule_options.getValueEnabled(argument.getName());
            String string = this.schedule_options.getValue(argument.getName());
            MyArgumentControl myArgumentControl = new MyArgumentControl(SCHEDULE, argument, bl, string);
            arrayList.add(myArgumentControl);
        }
        this.current_controls.addAll(arrayList);
        if (jPanel == null || n2 >= 3) {
            jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            n = arrayList.size();
            if (n2 >= 3) {
                if (n < MINIMUM_ROWS) {
                    n = MINIMUM_ROWS;
                }
                jPanel.setLayout(new GridLayout(n, 1, 5, 5));
            } else {
                jPanel.setLayout(new GridLayout(0, 1, 5, 5));
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            jPanel.add((JComponent)arrayList.get(n));
        }
        jPanel.addMouseListener(this);
        arrayList = null;
        return jPanel;
    }

    public JPanel buildImport(JPanel jPanel) {
        int n;
        if (jPanel == null) {
            this.current_controls.clear();
        }
        ArrayList<MyArgumentControl> arrayList = new ArrayList<MyArgumentControl>();
        int n2 = Configuration.getMode();
        int n3 = this.import_options.getArgumentCount();
        for (n = 0; n < n3; ++n) {
            Argument argument = this.import_options.getArgument(n);
            if (argument.isHiddenGLI() || argument.getModeLevel() > n2) continue;
            boolean bl = this.import_options.getValueEnabled(argument.getName());
            String string = this.import_options.getValue(argument.getName());
            MyArgumentControl myArgumentControl = new MyArgumentControl(IMPORT, argument, bl, string);
            arrayList.add(myArgumentControl);
        }
        this.current_controls.addAll(arrayList);
        if (jPanel == null || n2 >= 3) {
            jPanel = new JPanel();
            jPanel.setComponentOrientation(Dictionary.getOrientation());
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            jPanel.setBackground(Configuration.getColor("coloring.collection_tree_background", false));
            n = arrayList.size();
            if (n2 >= 3) {
                if (n < MINIMUM_ROWS) {
                    n = MINIMUM_ROWS;
                }
                jPanel.setLayout(new GridLayout(n, 1, 5, 5));
            } else {
                jPanel.setLayout(new GridLayout(0, 1, 5, 5));
            }
        }
        for (n = 0; n < arrayList.size(); ++n) {
            jPanel.add((JComponent)arrayList.get(n));
        }
        jPanel.addMouseListener(this);
        arrayList = null;
        return jPanel;
    }

    public JPanel buildLog() {
        if (this.log_pane == null) {
            Object object;
            Object object2;
            this.log_pane = new JPanel(new BorderLayout());
            this.log_pane.setComponentOrientation(Dictionary.getOrientation());
            DefaultListModel<FileEntry> defaultListModel = new DefaultListModel<FileEntry>();
            File file = new File(CollectionManager.getLoadedCollectionLogDirectoryPath());
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                object2 = fileArray[i].getName();
                if (!((String)object2).startsWith("build_log.") || !((String)object2).endsWith(".txt") || ((String)(object = ((String)object2).substring(((String)object2).indexOf(".") + 1, ((String)object2).lastIndexOf(".")).toLowerCase())).indexOf("s") != -1 || ((String)object).indexOf("u") != -1 || ((String)object).indexOf("c") != -1 || ((String)object).indexOf("x") != -1) continue;
                FileEntry fileEntry = new FileEntry(fileArray[i].getName(), fileArray[i].getAbsolutePath());
                boolean bl = false;
                for (int j = 0; !bl && j < defaultListModel.size(); ++j) {
                    FileEntry fileEntry2 = (FileEntry)defaultListModel.getElementAt(j);
                    int n = fileEntry.compareTo(fileEntry2);
                    if (n <= 0) continue;
                    defaultListModel.insertElementAt(fileEntry, j);
                    bl = true;
                }
                if (bl) continue;
                defaultListModel.addElement(fileEntry);
            }
            this.log_list = new JList(defaultListModel);
            this.log_list.setComponentOrientation(Dictionary.getOrientation());
            this.log_list.setSelectionMode(0);
            this.log_list.setLayoutOrientation(0);
            this.log_list.setPreferredSize(new Dimension(600, 100));
            this.log_list.setVisibleRowCount(3);
            this.log_list.addListSelectionListener(new LogListListener());
            JLabel jLabel = new JLabel(Dictionary.get("OptionsPane.LogHistory"));
            jLabel.setComponentOrientation(Dictionary.getOrientation());
            object2 = new JPanel();
            ((Component)object2).setComponentOrientation(Dictionary.getOrientation());
            ((JComponent)object2).setPreferredSize(new Dimension(600, 100));
            ((Container)object2).setLayout(new BorderLayout());
            ((Container)object2).add((Component)jLabel, "North");
            object = new JScrollPane(this.log_list);
            ((JScrollPane)object).setComponentOrientation(Dictionary.getOrientation());
            ((Container)object2).add((Component)object, "Center");
            object = new JScrollPane(this.log_textarea);
            ((JScrollPane)object).setComponentOrientation(Dictionary.getOrientation());
            this.log_pane.add((Component)object, "Center");
            this.log_pane.add((Component)object2, "South");
        }
        return this.log_pane;
    }

    public AppendLineOnlyFileDocument createNewLogDocument() {
        long l = System.currentTimeMillis();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("build_log.");
        stringBuffer.append(l);
        stringBuffer.append(".txt");
        File file = new File(CollectionManager.getLoadedCollectionLogDirectoryPath() + stringBuffer.toString());
        File file2 = file.getParentFile();
        file2.mkdirs();
        file2 = null;
        this.file_entry = new FileEntry(stringBuffer.toString(), file.getAbsolutePath());
        ((DefaultListModel)this.log_list.getModel()).add(0, this.file_entry);
        this.log_list.setSelectedIndex(0);
        return this.file_entry.getDocument();
    }

    public void closeCurrentLogDocument() {
        if (this.file_entry == null) {
            return;
        }
        AppendLineOnlyFileDocument appendLineOnlyFileDocument = this.file_entry.getDocument();
        if (appendLineOnlyFileDocument != null) {
            appendLineOnlyFileDocument.close();
        }
    }

    public int getDocumentCount() {
        int n;
        if (Gatherer.c_man.ready() && (n = Gatherer.c_man.getCollection().getDocumentCount()) != 0) {
            return n;
        }
        return 1;
    }

    @Override
    public void remove(AppendLineOnlyFileDocument appendLineOnlyFileDocument) {
        this.writing_documents.remove(appendLineOnlyFileDocument);
    }

    public void resetFileEntry() {
        if (this.file_entry != null) {
            this.file_entry.reset();
        }
    }

    public void update(JPanel jPanel) {
        if (jPanel == this.log_pane) {
            return;
        }
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if (!(component instanceof MyArgumentControl)) continue;
            ((MyArgumentControl)component).update();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        for (int i = 0; i < this.current_controls.size(); ++i) {
            MyArgumentControl myArgumentControl = (MyArgumentControl)this.current_controls.get(i);
            JComponent jComponent = myArgumentControl.getValueControl();
            if (jComponent instanceof JSpinner) {
                try {
                    ((JSpinner)jComponent).commitEdit();
                }
                catch (Exception exception) {
                    DebugStream.println("Exception in OptionsPane.mouseExited() - unexpected");
                    DebugStream.printStackTrace(exception);
                }
            }
            jComponent = null;
            myArgumentControl = null;
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    private class LogListListener
    implements ListSelectionListener {
        private LogListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JList jList = (JList)listSelectionEvent.getSource();
                OptionsPane.this.file_entry = (FileEntry)jList.getSelectedValue();
                Document document = OptionsPane.this.log_textarea.getDocument();
                if (document != OptionsPane.this.file_entry.getDocument()) {
                    AppendLineOnlyFileDocument appendLineOnlyFileDocument;
                    if (document instanceof AppendLineOnlyFileDocument && (appendLineOnlyFileDocument = (AppendLineOnlyFileDocument)document).isStillWriting()) {
                        OptionsPane.this.writing_documents.add(appendLineOnlyFileDocument);
                        appendLineOnlyFileDocument.setOwner(OptionsPane.this);
                        appendLineOnlyFileDocument.setExit();
                    }
                    OptionsPane.this.log_textarea.setDocument(OptionsPane.this.file_entry.getDocument());
                }
            }
        }
    }

    private class FileEntry {
        private AppendLineOnlyFileDocument current_document;
        private Date date = null;
        private long last_modified;
        private String display = null;
        private String filename;
        private String filepath;

        public FileEntry(String string, String string2) {
            this.filename = string;
            this.filepath = string2;
            this.last_modified = 0L;
        }

        public int compareTo(FileEntry fileEntry) {
            Date date = this.getDate();
            Date date2 = fileEntry.getDate();
            return date.compareTo(date2);
        }

        public Date getDate() {
            if (this.date == null) {
                int n = this.filename.indexOf(".") + 1;
                int n2 = this.filename.lastIndexOf(".");
                if (n > 0 && n2 > 0 && n < n2) {
                    String string = this.filename.substring(n, n2);
                    this.date = new Date(Long.parseLong(string));
                } else {
                    this.date = new Date();
                }
            }
            return this.date;
        }

        public AppendLineOnlyFileDocument getDocument() {
            if (this.current_document == null) {
                this.current_document = new AppendLineOnlyFileDocument(this.filepath);
            }
            return this.current_document;
        }

        public void reset() {
            this.display = null;
        }

        public String toString() {
            File file = new File(this.filename);
            if (this.display == null) {
                this.last_modified = file.lastModified();
                StringBuffer stringBuffer = new StringBuffer();
                Date date = this.getDate();
                stringBuffer.append(date.toString());
                int n = 120;
                File file2 = new File(this.filepath);
                if (file2.exists()) {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        n = (char)fileInputStream.read();
                        fileInputStream.close();
                        fileInputStream = null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                file2 = null;
                switch (n) {
                    case 115: {
                        stringBuffer.append(Dictionary.get("OptionsPane.Successful"));
                        break;
                    }
                    case 117: {
                        stringBuffer.append(Dictionary.get("OptionsPane.Unsuccessful"));
                        break;
                    }
                    case 99: {
                        stringBuffer.append(Dictionary.get("OptionsPane.Cancelled"));
                        break;
                    }
                    case 100: {
                        stringBuffer.append(Dictionary.get("OptionsPane.Scheduled"));
                        break;
                    }
                    default: {
                        stringBuffer.append(Dictionary.get("OptionsPane.Unknown"));
                    }
                }
                this.display = stringBuffer.toString();
            }
            return this.display;
        }
    }

    private class MyArgumentControl
    extends ArgumentControl {
        private int type;

        public MyArgumentControl(int n, Argument argument, boolean bl, String string) {
            super(argument, bl, string);
            this.type = n;
        }

        public void update() {
            String string = this.getArgumentName();
            boolean bl = this.isEnabled();
            String string2 = this.getValue();
            if (!bl && string2 == null) {
                if (this.type == BUILD) {
                    OptionsPane.this.build_options.removeValue(string);
                } else if (this.type == SCHEDULE) {
                    OptionsPane.this.schedule_options.removeValue(string);
                } else {
                    OptionsPane.this.import_options.removeValue(string);
                }
            } else if (this.type == BUILD) {
                OptionsPane.this.build_options.setValue(string, bl, string2);
            } else if (this.type == SCHEDULE) {
                OptionsPane.this.schedule_options.setValue(string, bl, string2);
            } else {
                OptionsPane.this.import_options.setValue(string, bl, string2);
            }
        }
    }
}

