/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.cdm.LanguageManager;
import org.greenstone.gatherer.collection.Collection;
import org.greenstone.gatherer.gui.EmailField;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.util.CheckList;
import org.greenstone.gatherer.util.CheckListEntry;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Preferences
extends ModalDialog {
    public static final String HTTP = "HTTP";
    public static final String HTTPS = "HTTPS";
    public static final String FTP = "FTP";
    public static final String CONNECTION_PREFS = "connection";
    public static final String GENERAL_PREFS = "general";
    private static final Dimension LABEL_SIZE = new Dimension(280, 25);
    private static final Dimension ROW_SIZE = new Dimension(640, 25);
    private static final Dimension SIZE = new Dimension(640, 345);
    private static final String TRUE = "true";
    private CheckList warning_preferences_check_list;
    private EmailField email_field;
    private JButton apply_button;
    private JButton cancel_button;
    private JButton chdir_button;
    private JButton ok_button;
    private JCheckBox show_file_size_checkbox;
    private JCheckBox no_check_certificate_checkbox;
    private JCheckBox use_proxy_checkbox;
    private JCheckBox view_extracted_metadata_checkbox;
    private JCheckBox workflow_download;
    private JCheckBox workflow_gather;
    private JCheckBox workflow_enrich;
    private JCheckBox workflow_design;
    private JCheckBox workflow_create;
    private JCheckBox workflow_format;
    private JCheckBox workflow_files;
    private JComboBox language_combobox;
    private JComboBox servlet_combobox;
    private JComboBox site_combobox;
    private JRadioButton assistant_mode_radio_button;
    private JRadioButton expert_mode_radio_button;
    private JRadioButton librarian_mode_radio_button;
    private JSpinner http_proxy_port_field;
    private JSpinner https_proxy_port_field;
    private JSpinner ftp_proxy_port_field;
    private JTabbedPane tab_pane;
    private JTextArea mode_description_textarea;
    private JTextField font_field;
    private JTextField gliserver_url_field;
    private JTextField library_path_field;
    private JTextField program_field;
    private JTextField http_proxy_host_field;
    private JTextField https_proxy_host_field;
    private JTextField ftp_proxy_host_field;
    private JTextField collect_dir_field;
    private Preferences self = this;
    private String current_site_selection;

    public Preferences() {
        this(GENERAL_PREFS);
    }

    public Preferences(String string) {
        super((Frame)Gatherer.g_man, true);
        this.setSize(SIZE);
        this.setTitle(Dictionary.get("Preferences"));
        this.setJMenuBar(new SimpleMenuBar("preferences"));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        this.tab_pane = new JTabbedPane();
        this.tab_pane.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = this.createGeneralPreferences();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        this.tab_pane.addTab(Dictionary.get("Preferences.General"), null, jPanel2, Dictionary.get("Preferences.General_Tooltip"));
        this.tab_pane.addTab(Dictionary.get("Preferences.Mode"), null, this.createModePreferences(), Dictionary.get("Preferences.Mode_Tooltip"));
        JPanel jPanel3 = this.createConnectionPreferences();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        this.tab_pane.addTab(Dictionary.get("Preferences.Connection"), null, jPanel3, Dictionary.get("Preferences.Connection_Tooltip"));
        this.tab_pane.addTab(Dictionary.get("Preferences.Warnings"), null, this.createWarningPreferences(), Dictionary.get("Preferences.Warnings_Tooltip"));
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("General.OK_Tooltip"));
        this.apply_button = new GLIButton(Dictionary.get("General.Apply"), Dictionary.get("General.Apply_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Cancel_Tooltip"));
        this.ok_button.addActionListener(new OKButtonListener(true));
        this.apply_button.addActionListener(new OKButtonListener(false));
        this.cancel_button.addActionListener(new CancelButtonListener());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(5, 2, 2, 2));
        jPanel4.setLayout(new GridLayout(1, 3, 0, 5));
        jPanel4.add(this.ok_button);
        jPanel4.add(this.apply_button);
        jPanel4.add(this.cancel_button);
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tab_pane, "Center");
        jPanel.add((Component)jPanel4, "South");
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        Dimension dimension = Gatherer.g_man.getSize();
        Point point = Gatherer.g_man.getLocation();
        this.setLocation((dimension.width - Preferences.SIZE.width) / 2, dimension.height - Preferences.SIZE.height);
        if (string.equals(CONNECTION_PREFS)) {
            this.tab_pane.setSelectedComponent(jPanel3);
        } else {
            this.tab_pane.setSelectedComponent(jPanel2);
        }
        if (!TestingPreparation.TEST_MODE) {
            jPanel2 = null;
            jPanel3 = null;
            point = null;
            dimension = null;
            this.cancel_button = null;
            this.ok_button = null;
            jPanel4 = null;
            this.tab_pane = null;
            jPanel = null;
        }
        TestingPreparation.setNamesRecursively(this);
        this.setVisible(true);
    }

    private JPanel createConnectionPreferences() {
        int n;
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setPreferredSize(ROW_SIZE);
        JLabel jLabel = new JLabel(Dictionary.get("Preferences.Connection.ProgramCommand"));
        jLabel.setPreferredSize(LABEL_SIZE);
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        this.program_field = new JTextField(Configuration.getPreviewCommand());
        this.program_field.setCaretPosition(0);
        this.program_field.setToolTipText(Dictionary.get("Preferences.Connection.ProgramCommand_Tooltip"));
        this.program_field.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setPreferredSize(ROW_SIZE);
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel2 = new JLabel();
        jLabel2.setPreferredSize(LABEL_SIZE);
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        String string = "";
        if (Configuration.library_url != null) {
            string = Configuration.library_url.toString();
        }
        this.library_path_field = new JTextField(string);
        this.library_path_field.setCaretPosition(0);
        this.library_path_field.setComponentOrientation(Dictionary.getOrientation());
        if (Gatherer.GS3) {
            jLabel2.setText(Dictionary.get("Preferences.Connection.Library_Path_GS3"));
            this.library_path_field.setToolTipText(Dictionary.get("Preferences.Connection.Library_Path_Tooltip_GS3"));
        } else {
            jLabel2.setText(Dictionary.get("Preferences.Connection.Library_Path"));
            this.library_path_field.setToolTipText(Dictionary.get("Preferences.Connection.Library_Path_Tooltip"));
        }
        this.library_path_field.setEnabled(!Gatherer.isApplet && !Gatherer.isWebswing);
        JPanel jPanel3 = null;
        JLabel jLabel3 = null;
        if (Gatherer.isGsdlRemote && !Gatherer.GS3) {
            jPanel3 = new JPanel();
            jPanel3.setPreferredSize(ROW_SIZE);
            jLabel3 = new JLabel(Dictionary.get("Preferences.Connection.GLIServer_URL"));
            jLabel3.setPreferredSize(LABEL_SIZE);
            jLabel3.setComponentOrientation(Dictionary.getOrientation());
            object3 = "";
            if (Configuration.gliserver_url != null) {
                object3 = Configuration.gliserver_url.toString();
            }
            this.gliserver_url_field = new JTextField((String)object3);
            this.gliserver_url_field.setComponentOrientation(Dictionary.getOrientation());
            this.gliserver_url_field.setCaretPosition(0);
            this.gliserver_url_field.setToolTipText(Dictionary.get("Preferences.Connection.GLIServer_URL_Tooltip"));
            this.gliserver_url_field.setEnabled(!Gatherer.isApplet && !Gatherer.isWebswing);
        }
        object3 = null;
        JLabel jLabel4 = null;
        JPanel jPanel4 = null;
        JLabel jLabel5 = null;
        if (Gatherer.GS3) {
            object3 = new JPanel();
            ((JComponent)object3).setPreferredSize(ROW_SIZE);
            ((Component)object3).setComponentOrientation(Dictionary.getOrientation());
            jLabel4 = new JLabel(Dictionary.get("Preferences.Connection.Site"));
            jLabel4.setPreferredSize(LABEL_SIZE);
            jLabel4.setComponentOrientation(Dictionary.getOrientation());
            this.site_combobox = new JComboBox<Object>(Gatherer.servlet_config.getSites().toArray());
            this.site_combobox.setOpaque(false);
            this.site_combobox.setToolTipText(Dictionary.get("Preferences.Connection.Site_Tooltip"));
            this.site_combobox.setComponentOrientation(Dictionary.getOrientation());
            jPanel4 = new JPanel();
            jPanel4.setPreferredSize(ROW_SIZE);
            jPanel4.setComponentOrientation(Dictionary.getOrientation());
            jLabel5 = new JLabel(Dictionary.get("Preferences.Connection.Servlet"));
            jLabel5.setPreferredSize(LABEL_SIZE);
            jLabel5.setComponentOrientation(Dictionary.getOrientation());
            this.servlet_combobox = new JComboBox();
            this.servlet_combobox.setOpaque(false);
            this.servlet_combobox.setComponentOrientation(Dictionary.getOrientation());
            object2 = Configuration.site_name;
            for (int i = 0; i < this.site_combobox.getItemCount(); ++i) {
                object = (String)this.site_combobox.getItemAt(i);
                if (!((String)object2).equals(object)) continue;
                this.site_combobox.setSelectedIndex(i);
                break;
            }
            this.current_site_selection = (String)this.site_combobox.getSelectedItem();
            serializable = Gatherer.servlet_config.getServletsForSite(this.current_site_selection);
            if (serializable == null) {
                this.servlet_combobox.setToolTipText(Dictionary.get("Preferences.Connection.Servlet_Tooltip2"));
                this.servlet_combobox.setEnabled(false);
            } else {
                this.servlet_combobox.setModel(new DefaultComboBoxModel<Object>(((ArrayList)serializable).toArray()));
                this.servlet_combobox.setToolTipText(Dictionary.get("Preferences.Connection.Servlet_Tooltip"));
                this.servlet_combobox.setEnabled(true);
                object = Configuration.getServletPath();
                for (n = 0; n < this.servlet_combobox.getItemCount(); ++n) {
                    String string2 = (String)this.servlet_combobox.getItemAt(n);
                    if (!((String)object).equals(string2)) continue;
                    this.servlet_combobox.setSelectedIndex(n);
                    break;
                }
            }
            if (Gatherer.isWebswing) {
                this.site_combobox.setEnabled(false);
                this.servlet_combobox.setEnabled(false);
            }
        }
        object2 = new JPanel();
        ((Component)object2).setComponentOrientation(Dictionary.getOrientation());
        ((JComponent)object2).setPreferredSize(ROW_SIZE);
        serializable = new JLabel(Dictionary.get("Preferences.Connection.CollectDirectory"));
        ((JComponent)serializable).setPreferredSize(LABEL_SIZE);
        ((Component)serializable).setComponentOrientation(Dictionary.getOrientation());
        this.collect_dir_field = new JTextField(Gatherer.getCollectDirectoryPath());
        this.collect_dir_field.setCaretPosition(0);
        this.collect_dir_field.setToolTipText(Dictionary.get("Preferences.Connection.CollectDirectory_Tooltip"));
        this.collect_dir_field.setEditable(false);
        object = new GLIButton(Dictionary.get("General.CD"), Dictionary.get("General.CD_Tooltip"));
        ((AbstractButton)object).addActionListener(new ChangeDirListener());
        if (Gatherer.isGsdlRemote || Gatherer.isWebswing) {
            this.collect_dir_field.setEnabled(false);
            ((AbstractButton)object).setEnabled(false);
        }
        n = Configuration.get("general.no_check_certificate", true);
        boolean bl = Configuration.get("general.use_proxy", true);
        JPanel jPanel5 = new JPanel();
        jPanel5.setComponentOrientation(Dictionary.getOrientation());
        this.no_check_certificate_checkbox = new JCheckBox(Dictionary.get("Preferences.Connection.No_Check_Certificate"));
        this.no_check_certificate_checkbox.setToolTipText(Dictionary.get("Preferences.Connection.No_Check_Certificate_Tooltip"));
        this.no_check_certificate_checkbox.setSelected(n != 0);
        this.no_check_certificate_checkbox.setComponentOrientation(Dictionary.getOrientation());
        this.no_check_certificate_checkbox.setPreferredSize(ROW_SIZE);
        this.use_proxy_checkbox = new JCheckBox(Dictionary.get("Preferences.Connection.Use_Proxy"));
        this.use_proxy_checkbox.setSelected(bl);
        this.use_proxy_checkbox.setComponentOrientation(Dictionary.getOrientation());
        this.use_proxy_checkbox.setPreferredSize(ROW_SIZE);
        this.no_check_certificate_checkbox.addActionListener(new NoCheckCertificateListener());
        this.use_proxy_checkbox.addActionListener(new UseProxyListener());
        if (Gatherer.GS3) {
            this.site_combobox.addActionListener(new SiteComboboxListener());
        }
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "Before");
        jPanel.add((Component)this.program_field, "Center");
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel2, "Before");
        jPanel2.add((Component)this.library_path_field, "Center");
        if (Gatherer.isGsdlRemote && !Gatherer.GS3) {
            jPanel3.setLayout(new BorderLayout());
            jPanel3.add((Component)jLabel3, "Before");
            jPanel3.add((Component)this.gliserver_url_field, "Center");
        }
        if (Gatherer.GS3) {
            ((Container)object3).setLayout(new BorderLayout());
            ((Container)object3).add((Component)jLabel4, "Before");
            ((Container)object3).add((Component)this.site_combobox, "Center");
            jPanel4.setLayout(new BorderLayout());
            jPanel4.add((Component)jLabel5, "Before");
            jPanel4.add((Component)this.servlet_combobox, "Center");
        }
        ((Container)object2).setLayout(new BorderLayout());
        ((Container)object2).add((Component)serializable, "Before");
        ((Container)object2).add((Component)this.collect_dir_field, "Center");
        ((Container)object2).add((Component)object, "After");
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel5.setLayout(new GridLayout(10, 1, 0, 2));
        if (!Gatherer.isWebswing) {
            jPanel5.add(jPanel);
        }
        jPanel5.add(jPanel2);
        if (Gatherer.isGsdlRemote && !Gatherer.GS3) {
            jPanel5.add(jPanel3);
        }
        if (Gatherer.GS3) {
            jPanel5.add((Component)object3);
            jPanel5.add(jPanel4);
        }
        jPanel5.add((Component)object2);
        jPanel5.add(this.no_check_certificate_checkbox);
        jPanel5.add(this.use_proxy_checkbox);
        this.setupProxyHostPane(HTTP, jPanel5, bl, this.http_proxy_host_field, this.http_proxy_port_field);
        this.setupProxyHostPane(HTTPS, jPanel5, bl, this.https_proxy_host_field, this.https_proxy_port_field);
        this.setupProxyHostPane(FTP, jPanel5, bl, this.ftp_proxy_host_field, this.ftp_proxy_port_field);
        return jPanel5;
    }

    private JPanel createGeneralPreferences() {
        int n;
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        ArrayList<DictionaryEntry> arrayList = new ArrayList<DictionaryEntry>();
        NodeList nodeList = LanguageManager.LANGUAGES_DOCUMENT.getDocumentElement().getElementsByTagName("Language");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object3 = (Element)nodeList.item(i);
            if (object3.hasAttribute("gli") && object3.getAttribute("gli").equalsIgnoreCase(TRUE) || object3.hasAttribute("mds") && object3.getAttribute("mds").equalsIgnoreCase(TRUE)) {
                serializable = new Locale(object3.getAttribute("code"));
                object2 = object3.getAttribute("name");
                object = new DictionaryEntry((String)object2, (Locale)serializable);
                if (!arrayList.contains(object)) {
                    arrayList.add((DictionaryEntry)object);
                }
                object = null;
                object2 = null;
                serializable = null;
            }
            object3 = null;
        }
        nodeList = null;
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        object3 = new JLabel(Dictionary.get("Preferences.General.Email"));
        ((Component)object3).setComponentOrientation(Dictionary.getOrientation());
        ((JComponent)object3).setPreferredSize(LABEL_SIZE);
        this.email_field = new EmailField(Configuration.getColor("coloring.error_background", false));
        this.email_field.setText(Configuration.getEmail());
        this.email_field.setToolTipText(Dictionary.get("Preferences.General.Email_Tooltip"));
        this.email_field.setComponentOrientation(Dictionary.getOrientation());
        serializable = new JPanel();
        ((Component)serializable).setComponentOrientation(Dictionary.getOrientation());
        object2 = new JLabel(Dictionary.get("Preferences.General.Font"));
        ((Component)object2).setComponentOrientation(Dictionary.getOrientation());
        ((JComponent)object2).setPreferredSize(LABEL_SIZE);
        this.font_field = new JTextField(Configuration.getString("general.font", true));
        this.font_field.setToolTipText(Dictionary.get("Preferences.General.Font_Tooltip"));
        this.font_field.setComponentOrientation(Dictionary.getOrientation());
        this.view_extracted_metadata_checkbox = new JCheckBox(Dictionary.get("Preferences.General.View_Extracted_Metadata"));
        this.view_extracted_metadata_checkbox.setSelected(false);
        this.view_extracted_metadata_checkbox.setComponentOrientation(Dictionary.getOrientation());
        if (Configuration.get("general.view_extracted_metadata", true)) {
            this.view_extracted_metadata_checkbox.setSelected(true);
        }
        this.view_extracted_metadata_checkbox.setToolTipText(Dictionary.get("Preferences.General.View_Extracted_Metadata_Tooltip"));
        this.view_extracted_metadata_checkbox.setComponentOrientation(Dictionary.getOrientation());
        this.show_file_size_checkbox = new JCheckBox(Dictionary.get("Preferences.General.Show_File_Size"));
        this.show_file_size_checkbox.setSelected(false);
        this.show_file_size_checkbox.setComponentOrientation(Dictionary.getOrientation());
        if (Configuration.get("general.show_file_size", true)) {
            this.show_file_size_checkbox.setSelected(true);
        }
        this.show_file_size_checkbox.setToolTipText(Dictionary.get("Preferences.General.Show_File_Size_Tooltip"));
        object = new JPanel();
        ((Component)object).setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("Preferences.General.Interface_Language"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jLabel.setPreferredSize(LABEL_SIZE);
        this.language_combobox = new JComboBox<Object>(arrayList.toArray());
        this.language_combobox.setOpaque(false);
        this.language_combobox.setToolTipText(Dictionary.get("Preferences.General.Interface_Language_Tooltip"));
        this.language_combobox.setComponentOrientation(Dictionary.getOrientation());
        String string = Configuration.getLanguage();
        int n2 = 0;
        DictionaryEntry dictionaryEntry = null;
        for (n = 0; n < this.language_combobox.getItemCount(); ++n) {
            DictionaryEntry dictionaryEntry2 = (DictionaryEntry)this.language_combobox.getItemAt(n);
            if (string.equalsIgnoreCase(dictionaryEntry2.getLocale().getLanguage())) {
                this.language_combobox.setSelectedIndex(n);
                break;
            }
            if (!dictionaryEntry2.getLocale().getLanguage().equalsIgnoreCase("en")) continue;
            n2 = n;
            dictionaryEntry = dictionaryEntry2;
        }
        if (n == this.language_combobox.getItemCount()) {
            this.language_combobox.setSelectedIndex(n2);
            Configuration.setLocale("general.locale", true, dictionaryEntry.getLocale());
            System.err.println("*** GLI doesn't yet support the language: " + string + " and has therefore defaulted to: " + Configuration.getLanguage());
        }
        if (Gatherer.isWebswing) {
            this.language_combobox.setToolTipText(Dictionary.get("Preferences.General.Interface_Language_Tooltip_Webswing"));
            this.language_combobox.setEnabled(false);
            this.font_field.setEnabled(false);
        }
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)object3, "Before");
        jPanel2.add((Component)this.email_field, "Center");
        ((Container)object).setLayout(new BorderLayout());
        ((Container)object).add((Component)jLabel, "Before");
        ((Container)object).add((Component)this.language_combobox, "Center");
        ((Container)serializable).setLayout(new BorderLayout());
        ((Container)serializable).add((Component)object2, "Before");
        ((Container)serializable).add(this.font_field, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new GridLayout(5, 1, 0, 5));
        jPanel.add(jPanel2);
        jPanel.add((Component)object);
        jPanel.add((Component)serializable);
        jPanel.add(this.view_extracted_metadata_checkbox);
        jPanel.add(this.show_file_size_checkbox);
        return jPanel;
    }

    private void setupProxyHostPane(String string, JPanel jPanel, boolean bl, JTextField jTextField, JSpinner jSpinner) {
        Dimension dimension = new Dimension(180, 25);
        Dimension dimension2 = new Dimension(60, 25);
        Dimension dimension3 = new Dimension(480, 25);
        Dimension dimension4 = new Dimension(120, 25);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        jPanel2.setPreferredSize(dimension3);
        JLabel jLabel = new JLabel(Dictionary.get("Preferences.Connection." + string + "_Proxy_Host"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jLabel.setPreferredSize(dimension);
        jTextField = new JTextField(Configuration.getString("general." + string + "_proxy_host", true));
        jTextField.setEnabled(bl);
        jTextField.setToolTipText(Dictionary.get("Preferences.Connection." + string + "_Proxy_Host_Tooltip"));
        jTextField.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        jPanel3.setPreferredSize(dimension4);
        JLabel jLabel2 = new JLabel(Dictionary.get("Preferences.Connection.Proxy_Port"));
        jLabel2.setPreferredSize(dimension2);
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        String string2 = Configuration.getString("general." + string + "_proxy_port", true);
        jSpinner = string2.length() > 0 ? new JSpinner(new SpinnerNumberModel(Integer.valueOf(string2), 0, 65535, 1)) : new JSpinner(new SpinnerNumberModel(0, 0, 65535, 1));
        jSpinner.setEnabled(bl);
        jSpinner.setToolTipText(Dictionary.get("Preferences.Connection." + string + "_Proxy_Port_Tooltip"));
        if (string.equals(HTTP)) {
            this.http_proxy_host_field = jTextField;
            this.http_proxy_port_field = jSpinner;
        } else if (string.equals(HTTPS)) {
            this.https_proxy_host_field = jTextField;
            this.https_proxy_port_field = jSpinner;
        } else if (string.equals(FTP)) {
            this.ftp_proxy_host_field = jTextField;
            this.ftp_proxy_port_field = jSpinner;
        }
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jLabel, "Before");
        jPanel2.add((Component)jTextField, "Center");
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jLabel2, "Before");
        jPanel3.add((Component)jSpinner, "Center");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)jPanel2, "West");
        jPanel4.add((Component)jPanel3, "Center");
        jPanel.add(jPanel4);
    }

    private JPanel createModePreferences() {
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        ButtonGroup buttonGroup = new ButtonGroup();
        this.assistant_mode_radio_button = new JRadioButton(Dictionary.get("Preferences.Mode.Assistant"));
        this.assistant_mode_radio_button.setOpaque(false);
        this.assistant_mode_radio_button.setComponentOrientation(Dictionary.getOrientation());
        buttonGroup.add(this.assistant_mode_radio_button);
        this.expert_mode_radio_button = new JRadioButton(Dictionary.get("Preferences.Mode.Expert"));
        this.expert_mode_radio_button.setOpaque(false);
        this.expert_mode_radio_button.setComponentOrientation(Dictionary.getOrientation());
        buttonGroup.add(this.expert_mode_radio_button);
        this.librarian_mode_radio_button = new JRadioButton(Dictionary.get("Preferences.Mode.Librarian"));
        this.librarian_mode_radio_button.setOpaque(false);
        this.librarian_mode_radio_button.setComponentOrientation(Dictionary.getOrientation());
        buttonGroup.add(this.librarian_mode_radio_button);
        this.mode_description_textarea = new JTextArea();
        this.mode_description_textarea.setComponentOrientation(Dictionary.getOrientation());
        this.mode_description_textarea.setEditable(false);
        this.mode_description_textarea.setLineWrap(true);
        this.mode_description_textarea.setWrapStyleWord(true);
        switch (Configuration.getMode()) {
            case 1: {
                this.assistant_mode_radio_button.setSelected(true);
                this.mode_description_textarea.setText(Dictionary.get("Preferences.Mode.Assistant_Description"));
                break;
            }
            case 3: {
                this.expert_mode_radio_button.setSelected(true);
                this.mode_description_textarea.setText(Dictionary.get("Preferences.Mode.Expert_Description"));
                break;
            }
            default: {
                this.librarian_mode_radio_button.setSelected(true);
                this.mode_description_textarea.setText(Dictionary.get("Preferences.Mode.Librarian_Description"));
            }
        }
        ModeRadioButtonListener modeRadioButtonListener = new ModeRadioButtonListener();
        this.assistant_mode_radio_button.addActionListener(modeRadioButtonListener);
        this.expert_mode_radio_button.addActionListener(modeRadioButtonListener);
        this.librarian_mode_radio_button.addActionListener(modeRadioButtonListener);
        modeRadioButtonListener = null;
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        jPanel2.setLayout(new GridLayout(3, 1, 2, 2));
        jPanel2.add(this.assistant_mode_radio_button);
        jPanel2.add(this.librarian_mode_radio_button);
        jPanel2.add(this.expert_mode_radio_button);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)new JScrollPane(this.mode_description_textarea), "Center");
        return jPanel;
    }

    private JPanel createWarningPreferences() {
        Object object;
        this.warning_preferences_check_list = new CheckList(false);
        this.warning_preferences_check_list.setComponentOrientation(Dictionary.getOrientation());
        Document document = XMLTools.parseXMLFile("xml/config.xml", true);
        NodeList nodeList = document.getDocumentElement().getElementsByTagName("Argument");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = (Element)nodeList.item(i);
            String string = object.getAttribute("name");
            if (!string.startsWith("warning.")) continue;
            String string2 = Dictionary.get(string.substring("warning.".length()) + ".Title");
            boolean bl = Configuration.get(string, true);
            CheckListEntry checkListEntry = new CheckListEntry(string2, bl);
            checkListEntry.setProperty(string);
            this.warning_preferences_check_list.addEntry(checkListEntry);
        }
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        object = new JScrollPane(this.warning_preferences_check_list);
        ((JScrollPane)object).setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)object, "Center");
        return jPanel;
    }

    private JPanel createWorkflowPreferences() {
        Vector<WorkflowElementWrapper> vector = new Vector<WorkflowElementWrapper>();
        Document document = XMLTools.parseXMLFile("xml/workflows.xml", true);
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getElementsByTagName("Workflow");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            vector.add(new WorkflowElementWrapper((Element)nodeList.item(i)));
        }
        JPanel jPanel = new JPanel();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel = new JLabel(Dictionary.get("Preferences.Workflow.Title"));
        jLabel.setComponentOrientation(Dictionary.getOrientation());
        jLabel.setPreferredSize(ROW_SIZE);
        this.workflow_download = new JCheckBox(Dictionary.get("GUI.Download") + " - " + Dictionary.get("GUI.Download_Tooltip"));
        this.workflow_download.setComponentOrientation(Dictionary.getOrientation());
        this.workflow_download.setSelected(Configuration.get("workflow.download", false) && Gatherer.isDownloadEnabled);
        this.workflow_download.setPreferredSize(ROW_SIZE);
        this.workflow_gather = new JCheckBox(Dictionary.get("GUI.Gather") + " - " + Dictionary.get("GUI.Gather_Tooltip"));
        this.workflow_gather.setSelected(Configuration.get("workflow.gather", false));
        this.workflow_gather.setPreferredSize(ROW_SIZE);
        this.workflow_gather.setComponentOrientation(Dictionary.getOrientation());
        this.workflow_enrich = new JCheckBox(Dictionary.get("GUI.Enrich") + " - " + Dictionary.get("GUI.Enrich_Tooltip"));
        this.workflow_enrich.setSelected(Configuration.get("workflow.enrich", false));
        this.workflow_enrich.setPreferredSize(ROW_SIZE);
        this.workflow_enrich.setComponentOrientation(Dictionary.getOrientation());
        this.workflow_design = new JCheckBox(Dictionary.get("GUI.Design") + " - " + Dictionary.get("GUI.Design_Tooltip"));
        this.workflow_design.setSelected(Configuration.get("workflow.design", false));
        this.workflow_design.setPreferredSize(ROW_SIZE);
        this.workflow_design.setComponentOrientation(Dictionary.getOrientation());
        this.workflow_create = new JCheckBox(Dictionary.get("GUI.Create") + " - " + Dictionary.get("GUI.Create_Tooltip"));
        this.workflow_create.setSelected(Configuration.get("workflow.create", false));
        this.workflow_create.setPreferredSize(ROW_SIZE);
        this.workflow_create.setComponentOrientation(Dictionary.getOrientation());
        this.workflow_format = new JCheckBox(Dictionary.get("GUI.Format") + " - " + Dictionary.get("GUI.Format_Tooltip"));
        this.workflow_format.setSelected(Configuration.get("workflow.format", false));
        this.workflow_format.setPreferredSize(ROW_SIZE);
        this.workflow_format.setComponentOrientation(Dictionary.getOrientation());
        this.workflow_files = new JCheckBox(Dictionary.get("GUI.Files") + " - " + Dictionary.get("GUI.Files_Tooltip"));
        this.workflow_files.setSelected(Configuration.get("workflow.files", false));
        this.workflow_files.setPreferredSize(ROW_SIZE);
        this.workflow_files.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JLabel jLabel2 = new JLabel(Dictionary.get("Preferences.Workflow.Predefined.Label"));
        jLabel2.setComponentOrientation(Dictionary.getOrientation());
        JComboBox jComboBox = new JComboBox(vector);
        jComboBox.setOpaque(false);
        jComboBox.addActionListener(new PredefinedActionListener());
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(jLabel);
        if (Configuration.get("workflow.download", true)) {
            jPanel2.add(this.workflow_download);
        }
        if (Configuration.get("workflow.gather", true)) {
            jPanel2.add(this.workflow_gather);
        }
        if (Configuration.get("workflow.enrich", true)) {
            jPanel2.add(this.workflow_enrich);
        }
        if (Configuration.get("workflow.design", true)) {
            jPanel2.add(this.workflow_design);
        }
        if (Configuration.get("workflow.create", true)) {
            jPanel2.add(this.workflow_create);
        }
        if (Configuration.get("workflow.format", true)) {
            jPanel2.add(this.workflow_format);
        }
        if (Configuration.get("workflow.files", true)) {
            jPanel2.add(this.workflow_files);
        }
        jPanel3.setLayout(new BorderLayout(5, 0));
        jPanel3.add((Component)jLabel2, "Before");
        jPanel3.add(jComboBox, "Center");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel2, "Center");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    private class WorkflowElementWrapper {
        private Element element;
        private String text;

        public WorkflowElementWrapper(Element element) {
            this.element = element;
        }

        public boolean getEnabled(String string) {
            boolean bl = true;
            if (this.element.getAttribute(string).equalsIgnoreCase("false")) {
                bl = false;
            }
            return bl;
        }

        public String toString() {
            if (this.text == null) {
                this.text = Dictionary.get(this.element.getFirstChild().getNodeValue());
            }
            return this.text;
        }
    }

    private class UseProxyListener
    implements ActionListener {
        private UseProxyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = Preferences.this.use_proxy_checkbox.isSelected();
            Configuration.set("general.use_proxy", true, bl);
            Preferences.this.http_proxy_host_field.setEnabled(bl);
            Preferences.this.http_proxy_port_field.setEnabled(bl);
            Preferences.this.https_proxy_host_field.setEnabled(bl);
            Preferences.this.https_proxy_port_field.setEnabled(bl);
            Preferences.this.ftp_proxy_host_field.setEnabled(bl);
            Preferences.this.ftp_proxy_port_field.setEnabled(bl);
        }
    }

    private class NoCheckCertificateListener
    implements ActionListener {
        private NoCheckCertificateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = Preferences.this.no_check_certificate_checkbox.isSelected();
            Configuration.set("general.no_check_certificate", true, bl);
            boolean bl2 = Configuration.get("general.no_check_certificate", true);
        }
    }

    private class SiteComboboxListener
    implements ActionListener {
        private boolean ignore_event = false;

        private SiteComboboxListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.err.println("event occurred " + actionEvent.paramString());
            String string = (String)Preferences.this.site_combobox.getSelectedItem();
            System.err.println("The site changed to = " + string);
            if (!string.equals(Preferences.this.current_site_selection)) {
                Preferences.this.current_site_selection = string;
                System.err.println("changed the current selection");
                ArrayList arrayList = Gatherer.servlet_config.getServletsForSite(Preferences.this.current_site_selection);
                if (arrayList == null) {
                    Preferences.this.servlet_combobox.setModel(new DefaultComboBoxModel());
                    Preferences.this.servlet_combobox.setToolTipText(Dictionary.get("Preferences.Connection.Servlet_Tooltip2"));
                    Preferences.this.servlet_combobox.setEnabled(false);
                } else {
                    Preferences.this.servlet_combobox.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
                    Preferences.this.servlet_combobox.setToolTipText(Dictionary.get("Preferences.Connection.Servlet_Tooltip"));
                    Preferences.this.servlet_combobox.setEnabled(true);
                }
                if (Gatherer.isGsdlRemote) {
                    if (Gatherer.c_man.getCollection() != null) {
                        Gatherer.g_man.closeCurrentCollection();
                    }
                    Configuration.site_name = string;
                    System.err.println("download colls");
                    Gatherer.remoteGreenstoneServer.downloadCollectionConfigurations();
                }
            }
        }
    }

    private class PredefinedActionListener
    implements ActionListener {
        private PredefinedActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
            WorkflowElementWrapper workflowElementWrapper = (WorkflowElementWrapper)jComboBox.getSelectedItem();
            CheckboxUpdater checkboxUpdater = new CheckboxUpdater(workflowElementWrapper);
            SwingUtilities.invokeLater(checkboxUpdater);
        }

        private class CheckboxUpdater
        implements Runnable {
            private WorkflowElementWrapper element;

            public CheckboxUpdater(WorkflowElementWrapper workflowElementWrapper) {
                this.element = workflowElementWrapper;
            }

            @Override
            public void run() {
                Preferences.this.workflow_download.setSelected(this.element.getEnabled("download"));
                Preferences.this.workflow_gather.setSelected(this.element.getEnabled("gather"));
                Preferences.this.workflow_enrich.setSelected(this.element.getEnabled("enrich"));
                Preferences.this.workflow_design.setSelected(this.element.getEnabled("design"));
                Preferences.this.workflow_create.setSelected(this.element.getEnabled("create"));
                Preferences.this.workflow_format.setSelected(this.element.getEnabled("format"));
                Preferences.this.workflow_files.setSelected(this.element.getEnabled("files"));
            }
        }
    }

    private class ModeRadioButtonListener
    implements ActionListener {
        private ModeRadioButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Preferences.this.assistant_mode_radio_button) {
                Preferences.this.mode_description_textarea.setText(Dictionary.get("Preferences.Mode.Assistant_Description"));
            } else if (object == Preferences.this.expert_mode_radio_button) {
                Preferences.this.mode_description_textarea.setText(Dictionary.get("Preferences.Mode.Expert_Description"));
            } else {
                Preferences.this.mode_description_textarea.setText(Dictionary.get("Preferences.Mode.Librarian_Description"));
            }
            object = null;
        }
    }

    private class DictionaryEntry
    implements Comparable {
        private Locale locale;
        private String description;

        public DictionaryEntry(Locale locale) {
            this.description = null;
            this.locale = locale;
        }

        public DictionaryEntry(String string, Locale locale) {
            this.description = string;
            this.locale = locale;
        }

        public int compareTo(Object object) {
            return this.toString().compareTo(object.toString());
        }

        public boolean equals(Object object) {
            return this.toString().equals(object.toString());
        }

        public Locale getLocale() {
            return this.locale;
        }

        public String toString() {
            if (this.description != null) {
                return this.description;
            }
            return this.locale.getDisplayName();
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Preferences.this.self.dispose();
        }
    }

    private class OKButtonListener
    implements ActionListener {
        private boolean close;

        public OKButtonListener(boolean bl) {
            this.close = bl;
        }

        private void setProxyHostForProtocol(String string, JTextField jTextField, JSpinner jSpinner) {
            Configuration.setString("general." + string + "_proxy_host", true, jTextField.getText());
            Configuration.setString("general." + string + "_proxy_port", true, jSpinner.getValue() + "");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Container container;
            Object object;
            String string;
            String string2;
            boolean bl = false;
            boolean bl2 = false;
            String string3 = "";
            String string4 = Preferences.this.program_field.getText();
            if (string4.length() > 0 && string4.indexOf("%1") == -1) {
                string4 = string4 + " %1";
            }
            Configuration.setPreviewCommand(string4);
            String string5 = Configuration.library_url == null ? null : Configuration.library_url.toString();
            String string6 = Preferences.this.library_path_field.getText();
            if (string5 != null && !string5.equals(string6)) {
                if (Gatherer.isGsdlRemote) {
                    bl = true;
                    string3 = Dictionary.get("Preferences.General.Manual_Restart_Required");
                }
                if (Gatherer.c_man.getCollection() != null) {
                    Gatherer.g_man.saveThenCloseCurrentCollection();
                    Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, "");
                }
            }
            if (string6.equals("")) {
                Configuration.library_url = null;
            } else {
                try {
                    Configuration.library_url = new URL(string6);
                }
                catch (MalformedURLException malformedURLException) {
                    DebugStream.printStackTrace(malformedURLException);
                }
            }
            Configuration.setString("general.library_url" + Configuration.gliPropertyNameSuffix(), true, string6);
            if (Gatherer.isGsdlRemote && !Gatherer.GS3) {
                String string7 = Configuration.gliserver_url.toString();
                if (!string7.equals(string2 = Preferences.this.gliserver_url_field.getText())) {
                    bl = true;
                    string3 = Dictionary.get("Preferences.General.Manual_Restart_Required");
                    if (Gatherer.c_man.getCollection() != null) {
                        Gatherer.g_man.saveThenCloseCurrentCollection();
                        Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, "");
                    }
                }
                if (string2.equals("")) {
                    Configuration.gliserver_url = null;
                } else {
                    try {
                        Configuration.gliserver_url = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        DebugStream.printStackTrace(malformedURLException);
                    }
                }
                Configuration.setString("general.gliserver_url", true, string2);
            }
            boolean bl3 = false;
            if (Gatherer.GS3) {
                string2 = Configuration.site_name;
                string = (String)Preferences.this.site_combobox.getSelectedItem();
                if (!string.equals(string2)) {
                    bl3 = true;
                }
                Configuration.setSiteAndServlet(string, (String)Preferences.this.servlet_combobox.getSelectedItem());
            }
            Configuration.set("general.use_proxy", true, Preferences.this.use_proxy_checkbox.isSelected());
            this.setProxyHostForProtocol(Preferences.HTTP, Preferences.this.http_proxy_host_field, Preferences.this.http_proxy_port_field);
            this.setProxyHostForProtocol(Preferences.HTTPS, Preferences.this.https_proxy_host_field, Preferences.this.https_proxy_port_field);
            this.setProxyHostForProtocol(Preferences.FTP, Preferences.this.ftp_proxy_host_field, Preferences.this.ftp_proxy_port_field);
            Gatherer.setProxy();
            Configuration.setEmail(Preferences.this.email_field.getText());
            Configuration.set("general.show_file_size", true, Preferences.this.show_file_size_checkbox.isSelected());
            Configuration.set("general.view_extracted_metadata", true, Preferences.this.view_extracted_metadata_checkbox.isSelected());
            string2 = Configuration.getString("general.font", true);
            if (!string2.equals(Preferences.this.font_field.getText())) {
                Configuration.setString("general.font", true, Preferences.this.font_field.getText());
                bl = true;
                string3 = Dictionary.get("Preferences.General.Restart_Required");
            }
            if (!(string = Configuration.getLanguage()).equals(((DictionaryEntry)Preferences.this.language_combobox.getSelectedItem()).getLocale().getLanguage())) {
                if (Gatherer.c_man.getCollection() != null) {
                    Configuration.setString("general.open_collection" + Configuration.gliPropertyNameSuffix(), true, Gatherer.c_man.getLoadedCollectionColFilePath());
                    Gatherer.g_man.saveThenCloseCurrentCollection();
                    bl2 = true;
                }
                Configuration.setLocale("general.locale", true, ((DictionaryEntry)Preferences.this.language_combobox.getSelectedItem()).getLocale());
                bl = true;
                string3 = Dictionary.get("Preferences.General.Restart_Required");
            }
            if (bl) {
                JOptionPane.showMessageDialog(Gatherer.g_man, string3, Dictionary.get("General.Warning"), 2);
            }
            int n = Configuration.getMode();
            int n2 = Preferences.this.assistant_mode_radio_button.isSelected() ? 1 : (Preferences.this.expert_mode_radio_button.isSelected() ? 3 : 2);
            if (n2 != n) {
                Configuration.setMode(n2);
                object = Gatherer.c_man.getCollection();
                if (object != null) {
                    ((Collection)object).cdm.modeChanged(n2);
                }
                Gatherer.g_man.modeChanged(n2);
            }
            object = Preferences.this.warning_preferences_check_list.getModel();
            for (int i = 0; i < object.getSize(); ++i) {
                container = (CheckListEntry)object.getElementAt(i);
                Configuration.set(container.getProperty(), true, container.isSelected());
            }
            if (Gatherer.GS3 && bl3 && Gatherer.c_man.getCollection() != null && !Gatherer.isGsdlRemote) {
                System.err.println("shutting down the collection");
                Gatherer.g_man.saveThenCloseCurrentCollection();
            }
            Configuration.save();
            if (Gatherer.isGsdlRemote && Gatherer.GS3 && bl3) {
                Gatherer.remoteGreenstoneServer.downloadCollectionConfigurations();
            }
            Gatherer.refresh(3);
            if (Preferences.this.use_proxy_checkbox.isSelected() && Preferences.this.http_proxy_host_field.getText().equals("") && Preferences.this.https_proxy_host_field.getText().equals("") && Preferences.this.ftp_proxy_host_field.getText().equals("")) {
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("Preferences.Connection.Proxy_Host_Missing"), Dictionary.get("General.Error"), 0);
            } else if (this.close) {
                Preferences.this.self.dispose();
            }
            String string8 = Preferences.this.collect_dir_field.getText();
            if (!string8.endsWith(File.separator)) {
                string8 = string8 + File.separator;
            }
            container = this.close ? Gatherer.g_man.getContentPane() : Preferences.this.getContentPane();
            Gatherer.collectDirectoryHasChanged(Gatherer.getCollectDirectoryPath(), string8, container);
            if (bl) {
                if (bl2) {
                    Gatherer.g_man.exitNoCollectionSave(2);
                } else {
                    Gatherer.g_man.exit(2);
                }
            }
        }
    }

    private class ChangeDirListener
    implements ActionListener {
        private ChangeDirListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(Preferences.this.collect_dir_field.getText());
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(Preferences.this);
            if (n == 0) {
                Preferences.this.collect_dir_field.setText(jFileChooser.getSelectedFile().getAbsolutePath() + File.separator);
            }
        }
    }
}

