/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.greenstone.LocalLibraryServer;
import org.greenstone.gatherer.greenstone3.ServletConfiguration;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.PreviewButtonOwner;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.webswing.toolkit.api.WebswingUtil;

public class PreviewButton
extends GLIButton {
    public static final int HOME_PAGE = 1;
    public static final int SEARCH_PAGE = 2;
    public static final int CLASSIFIER_PAGE = 3;
    public static final int DOCUMENT_PAGE = 4;
    private String preview_address;
    private int page_type = 1;
    private boolean variable_preview = false;
    private PreviewButtonOwner owner = null;

    public PreviewButton() {
        PreviewButtonListener previewButtonListener = new PreviewButtonListener();
        this.addActionListener(previewButtonListener);
    }

    public PreviewButton(String string, String string2) {
        super(string, string2);
        PreviewButtonListener previewButtonListener = new PreviewButtonListener();
        this.addActionListener(previewButtonListener);
    }

    public String getPreviewURL() {
        return this.preview_address;
    }

    public void setOwner(PreviewButtonOwner previewButtonOwner) {
        this.owner = previewButtonOwner;
    }

    public void setVariablePreview(boolean bl) {
        this.variable_preview = bl;
    }

    protected void configureHomeURL() {
        String string = CollectionManager.getLoadedCollectionName(true);
        if (Gatherer.GS3) {
            if (Configuration.library_url == null) {
                Gatherer.missingEXEC(null);
            }
            if (Configuration.library_url != null) {
                this.preview_address = Configuration.library_url.toString() + Configuration.getServletPath() + "?a=p&sa=about&c=" + string + "&l=" + Configuration.getLanguage();
            }
            return;
        }
        if (Gatherer.isLocalLibrary) {
            LocalLibraryServer.checkServerRunning();
            if (LocalLibraryServer.isURLPending()) {
                JOptionPane.showMessageDialog(Gatherer.g_man, Dictionary.get("General.LLS_Not_Started"), Dictionary.get("General.LLS_Not_Started_Title"), 1);
                this.preview_address = null;
                return;
            }
        }
        this.preview_address = Configuration.fedora_info.isActive() ? Configuration.library_url.toString() + "?pid=true&title=true&terms=&query=pid~greenstone:" + string + "*&maxResults=20" : Configuration.library_url.toString() + "?c=" + string + "&l=" + Configuration.getLanguage();
        String string2 = "&a=p&p=about";
        this.preview_address = this.preview_address + string2 + "&uq=" + System.currentTimeMillis();
    }

    private class PreviewButtonListener
    implements ActionListener {
        private PreviewButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Gatherer.c_man.saveCollection();
            PreviewButton.this.configureHomeURL();
            if (Gatherer.GS3) {
                Gatherer.configGS3Server(Configuration.site_name, ServletConfiguration.ADD_COMMAND + Gatherer.c_man.getLoadedCollectionName());
            }
            if (PreviewButton.this.preview_address != null) {
                if (Gatherer.isWebswing) {
                    WebswingUtil.getWebswingApi().sendActionEvent("previewURL", PreviewButton.this.preview_address, null);
                } else if (TestingPreparation.TEST_MODE) {
                    System.err.println("*** TEST_MODE: not opening preview URL in regular browser");
                } else {
                    Gatherer.spawnBrowser(PreviewButton.this.preview_address);
                }
            }
        }
    }
}

