/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.GLIButton;
import org.greenstone.gatherer.gui.GUIUtils;
import org.greenstone.gatherer.gui.ModalDialog;
import org.greenstone.gatherer.gui.SimpleMenuBar;
import org.greenstone.gatherer.util.Utility;

public class PreviewCommandDialog
extends ModalDialog {
    private static final Dimension SIZE = new Dimension(500, 195);
    private PreviewCommandDialog self = this;
    private JButton browse_button;
    private JButton cancel_button;
    private JButton ok_button;
    private JTextField command_field;
    private String preview_command = null;

    public PreviewCommandDialog() {
        super(Gatherer.g_man);
        this.setComponentOrientation(Dictionary.getOrientation());
        this.setModal(true);
        this.setSize(SIZE);
        this.setJMenuBar(new SimpleMenuBar("thepreviewview"));
        this.setTitle(Dictionary.get("PreviewCommandDialog.Title"));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setComponentOrientation(Dictionary.getOrientation());
        jPanel.setBackground(Configuration.getColor("coloring.collection_heading_background", false));
        JTextArea jTextArea = new JTextArea(Dictionary.get("PreviewCommandDialog.Instructions"));
        jTextArea.setComponentOrientation(Dictionary.getOrientation());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setRows(5);
        jTextArea.setWrapStyleWord(true);
        JPanel jPanel2 = new JPanel();
        jPanel2.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel3 = new JPanel();
        jPanel3.setComponentOrientation(Dictionary.getOrientation());
        JPanel jPanel4 = new JPanel();
        jPanel4.setComponentOrientation(Dictionary.getOrientation());
        this.command_field = new JTextField();
        this.command_field.setComponentOrientation(Dictionary.getOrientation());
        this.browse_button = new GLIButton(Dictionary.get("FileAssociationDialog.Browse"));
        this.browse_button.setEnabled(!Utility.isMac());
        if (Utility.isMac()) {
            this.browse_button.setToolTipText(Dictionary.get("FileAssociationDialog.Browse_Tooltip_Mac"));
        } else {
            this.browse_button.setToolTipText(Dictionary.get("FileAssociationDialog.Browse", "FileAssociationDialog.Browse_Tooltip"));
        }
        this.ok_button = new GLIButton(Dictionary.get("General.OK"), Dictionary.get("FileAssociationDialog.Close_Tooltip"));
        this.cancel_button = new GLIButton(Dictionary.get("General.Cancel"), Dictionary.get("General.Pure_Cancel_Tooltip"));
        this.browse_button.addActionListener(new BrowseButtonListener());
        this.ok_button.addActionListener(new OkButtonListener());
        this.cancel_button.addActionListener(new CancelButtonListener());
        jPanel4.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.command_field, "Center");
        jPanel4.add((Component)this.browse_button, "After");
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jPanel2.setLayout(new GridLayout(1, 2, 5, 0));
        jPanel2.add(this.ok_button);
        jPanel2.add(this.cancel_button);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(2, 0, 0, 0));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jPanel2, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setComponentOrientation(Dictionary.getOrientation());
        jPanel.add((Component)jScrollPane, "North");
        jPanel.add((Component)jPanel3, "Center");
        Rectangle rectangle = Gatherer.g_man.getBounds(null);
        this.setLocation((int)(rectangle.getX() + (rectangle.getWidth() - (double)PreviewCommandDialog.SIZE.width) / 2.0), (int)(rectangle.getY() + (rectangle.getHeight() - (double)PreviewCommandDialog.SIZE.height) / 2.0));
        rectangle = null;
    }

    public void destroy() {
        this.self = null;
    }

    public String display() {
        this.setVisible(true);
        return this.preview_command;
    }

    private class ExecutableFileFilter
    extends FileFilter {
        private ExecutableFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".exe");
        }

        @Override
        public String getDescription() {
            return Dictionary.get("FileAssociationDialog.Executable_File");
        }
    }

    private class CoreObjectModelFileFilter
    extends FileFilter {
        private CoreObjectModelFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".com");
        }

        @Override
        public String getDescription() {
            return Dictionary.get("FileAssociationDialog.Command_File");
        }
    }

    private class BatchFileFilter
    extends FileFilter {
        private BatchFileFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".bat");
        }

        @Override
        public String getDescription() {
            return Dictionary.get("FileAssociationDialog.Batch_File");
        }
    }

    private class CancelButtonListener
    implements ActionListener {
        private CancelButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreviewCommandDialog.this.self.dispose();
        }
    }

    private class BrowseButtonListener
    implements ActionListener {
        private BrowseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = new JFileChooser(new File(Gatherer.getGLIUserDirectoryPath()));
            jFileChooser.setComponentOrientation(Dictionary.getOrientation());
            GUIUtils.disableRename(jFileChooser);
            jFileChooser.setDialogTitle(Dictionary.get("FileAssociationDialog.Browse_Title"));
            jFileChooser.setFileFilter(new BatchFileFilter());
            jFileChooser.setFileFilter(new CoreObjectModelFileFilter());
            jFileChooser.setFileFilter(new ExecutableFileFilter());
            jFileChooser.setAcceptAllFileFilterUsed(true);
            if (jFileChooser.showOpenDialog(Gatherer.g_man) == 0) {
                PreviewCommandDialog.this.command_field.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    private class OkButtonListener
    implements ActionListener {
        private OkButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PreviewCommandDialog.this.preview_command = PreviewCommandDialog.this.command_field.getText();
            PreviewCommandDialog.this.self.dispose();
        }
    }
}

