/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.gui.metaaudit;

import de.qfs.lib.gui.TableModelFilter;
import de.qfs.lib.gui.TableModelFilterEvent;
import de.qfs.lib.gui.TableModelFilterListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.TableModel;
import org.greenstone.gatherer.gui.metaaudit.Autofilter;

public class Filter
implements TableModelFilter {
    private Autofilter[] filters;
    private Vector listeners = new Vector();

    public Filter(int n) {
        this.filters = new Autofilter[n];
    }

    @Override
    public synchronized void addTableModelFilterListener(TableModelFilterListener tableModelFilterListener) {
        if (!this.listeners.contains(tableModelFilterListener)) {
            this.listeners.addElement(tableModelFilterListener);
        }
    }

    public void clearFilter(int n) {
        if (this.filters[n] != null) {
            this.filters[n].setActive(false);
        }
    }

    @Override
    public boolean filter(TableModel tableModel, int n) {
        for (int i = 0; i < this.filters.length; ++i) {
            ArrayList arrayList;
            if (this.filters[i] == null || !this.filters[i].active() || this.filters[i].filter(arrayList = (ArrayList)tableModel.getValueAt(n, i))) continue;
            return false;
        }
        return true;
    }

    public Autofilter getFilter(int n) {
        Autofilter autofilter = this.filters[n];
        if (autofilter == null) {
            this.filters[n] = autofilter = new Autofilter();
        }
        return autofilter;
    }

    public boolean isFiltered(int n) {
        boolean bl = false;
        if (this.filters[n] != null) {
            bl = this.filters[n].active();
        }
        return bl;
    }

    @Override
    public synchronized void removeTableModelFilterListener(TableModelFilterListener tableModelFilterListener) {
        this.listeners.removeElement(tableModelFilterListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireFilterChanged() {
        Vector vector;
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        object = new TableModelFilterEvent(this);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((TableModelFilterListener)enumeration.nextElement()).filterChanged((TableModelFilterEvent)object);
        }
    }
}

