/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.util.ArrayList;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.metadata.DocGAFile;
import org.greenstone.gatherer.metadata.DocMetsXMLFile;
import org.greenstone.gatherer.metadata.DocXMLFile;

public class DocXMLFileManager {
    private static ArrayList doc_xml_files = new ArrayList();

    public static void clearDocXMLFiles() {
        doc_xml_files.clear();
    }

    public static ArrayList getMetadataExtractedFromFile(File file) {
        String string = file.getAbsolutePath();
        int n = string.indexOf("import");
        if (n != -1) {
            string = string.substring(n + "import".length() + 1);
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < doc_xml_files.size(); ++i) {
            DocXMLFile docXMLFile = (DocXMLFile)doc_xml_files.get(i);
            arrayList.addAll(docXMLFile.getMetadataExtractedFromFile(file, string));
        }
        return arrayList;
    }

    public static void loadDocXMLFiles(File file, String string) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                DocXMLFileManager.loadDocXMLFiles(file2, string);
                continue;
            }
            if (!file2.getName().equals(string)) continue;
            DocXMLFileManager.loadDocXMLFile(file2, string);
        }
    }

    private static void loadDocXMLFile(File file, String string) {
        String string2 = file.getAbsolutePath();
        DocXMLFile docXMLFile = string.equals("docmets.xml") ? new DocMetsXMLFile(string2) : new DocGAFile(string2);
        try {
            docXMLFile.skimFile();
            doc_xml_files.add(docXMLFile);
        }
        catch (Exception exception) {
            System.err.println("Error: Could not skim doc.xml file " + docXMLFile.getAbsolutePath());
            DebugStream.printStackTrace(exception);
        }
    }
}

