/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.gui.TestingPreparation;
import org.greenstone.gatherer.metadata.MetadataValue;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;

public class FilenameEncoding {
    public static boolean DEBUGGING = false;
    public static boolean MULTIPLE_FILENAME_ENCODINGS_SUPPORTED = false;
    public static String URL_FILE_SEPARATOR = File.separator;
    public static Map map = new HashMap();
    public static final Pattern HEX_PATTERN = Pattern.compile("(&#x[0-9a-zA-Z]{1,4}+;)");
    public static final String HEX_AMPERSAND = "%26";
    private static boolean refreshRequired = false;

    public static synchronized boolean isRefreshRequired() {
        return refreshRequired;
    }

    public static synchronized void setRefreshRequired(boolean bl) {
        refreshRequired = MULTIPLE_FILENAME_ENCODINGS_SUPPORTED ? bl : false;
    }

    public static String findFilenameEncoding(File file, String string, boolean bl) {
        String string2 = "";
        if (!map.containsKey(string)) {
            ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedDirectlyToFile(file, true);
            if (!arrayList.isEmpty()) {
                MetadataValue metadataValue = (MetadataValue)arrayList.get(0);
                string2 = metadataValue.getValue();
            }
            map.put(string, string2);
        } else {
            string2 = (String)map.get(string);
        }
        if (string2.equals("")) {
            string2 = FilenameEncoding.getInheritedFilenameEncoding(string, file);
        }
        return string2;
    }

    public static String getInheritedFilenameEncoding(String string, File file) {
        String string2 = "";
        boolean bl = false;
        File file2 = new File(CollectionManager.getLoadedCollectionImportDirectoryPath());
        if (file.equals(file2)) {
            bl = true;
        } else if (!file.getAbsolutePath().contains(file2.getAbsolutePath())) {
            if (!TestingPreparation.TEST_MODE) {
                System.err.println("@@@ " + file + " is not in the import dir!\nShould this function really be called on this dir?\nNot trying to determine the file encoding as it's supposed to be determined off the collection's import files.");
            }
            bl = true;
        }
        int n = string.length() - 1;
        char c = URL_FILE_SEPARATOR.charAt(0);
        if (string.charAt(n) == c) {
            string = string.substring(0, n);
        }
        while (!bl) {
            file = file.getParentFile();
            int n2 = string.lastIndexOf(URL_FILE_SEPARATOR);
            if (n2 == -1) {
                bl = true;
            } else {
                string = string.substring(0, n2);
            }
            String string3 = string + URL_FILE_SEPARATOR;
            if (map.containsKey(string3)) {
                string2 = (String)map.get(string3);
            } else {
                ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedDirectlyToFile(file, true);
                if (!arrayList.isEmpty()) {
                    MetadataValue metadataValue = (MetadataValue)arrayList.get(0);
                    string2 = metadataValue.getValue();
                }
                map.put(string3, string2);
            }
            if (!string2.equals("")) {
                bl = true;
                continue;
            }
            if (!file.equals(file2)) continue;
            bl = true;
        }
        return string2;
    }

    public static void closeCollection() {
        map.clear();
    }

    public static void printFilenameMap(String string) {
        System.err.println("\n********************************************");
        System.err.println(string.toUpperCase());
        for (Map.Entry entry : map.entrySet()) {
            System.err.println("+ " + (String)entry.getKey() + ": " + (String)entry.getValue());
        }
        System.err.println("********************************************\n");
    }

    public static String findFilenameEncodingBruteForce(File file, String string, boolean bl) {
        MetadataValue metadataValue;
        System.err.println("\n***** BRUTE FORCE getFilenameEncoding() called\n");
        String string2 = "";
        ArrayList arrayList = MetadataXMLFileManager.getMetadataAssignedToFile(file, true);
        if (!arrayList.isEmpty() && (string2 = (metadataValue = (MetadataValue)arrayList.get(arrayList.size() - 1)).getValue()) == null) {
            System.err.println("**** ERROR: encoding for " + string + " is NULL!");
            string2 = "";
        }
        return string2;
    }

    public static String calcURLEncodedFilePath(File file) {
        return FilenameEncoding.fileToURLEncoding(file);
    }

    public static String calcURLEncodedFileName(String string) {
        int n;
        String string2 = string;
        if (string2.endsWith(URL_FILE_SEPARATOR)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if ((n = string2.lastIndexOf(URL_FILE_SEPARATOR)) != -1) {
            string2 = string2.substring(n + 1);
        }
        return string2;
    }

    public static String canonicalEncodingName(String string) {
        String string2 = string;
        try {
            String string3 = string2.toLowerCase();
            if (string3.startsWith("latin")) {
                string2 = "ISO-8859" + string3.substring("latin".length());
            }
            string2 = Charset.forName(string2).name();
            return string2;
        }
        catch (Exception exception) {
            System.err.println("(Could not recognise encoding (alias): " + string + ".)");
            return string;
        }
    }

    public static String decodeStringContainingHexEntities(String string) {
        String string2 = "";
        Matcher matcher = HEX_PATTERN.matcher(string);
        int n = 0;
        int n2 = -1;
        while (matcher.find(n)) {
            String string3 = matcher.group();
            int n3 = matcher.start();
            n2 = matcher.end();
            string2 = string2 + string.substring(n, n3);
            String string4 = string3.substring(3, string3.length() - 1);
            string4 = "0x" + string4;
            int n4 = Integer.decode(string4);
            String string5 = Character.toString((char)n4);
            string2 = string2 + string5;
            n = n2;
        }
        string2 = n2 != -1 ? string2 + string.substring(n2) : string;
        return string2;
    }

    public static String fileToURLEncoding(File file) {
        if (!MULTIPLE_FILENAME_ENCODINGS_SUPPORTED) {
            String string = file.getAbsolutePath();
            return string;
        }
        String string = "";
        URI uRI = file.toURI();
        try {
            String string2 = uRI.toASCIIString();
            string2 = string2.replace("+", "%252B");
            string2 = string2.replace("&", "%2526");
            String string3 = URLDecoder.decode(string2, "ISO-8859-1");
            string = FilenameEncoding.iso_8859_1_filename_to_url_encoded(string3);
            string = string.replace("%2B", "+");
            string = string.replace(HEX_AMPERSAND, "&");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            string = file.getAbsolutePath();
        }
        return string;
    }

    public static String iso_8859_1_filename_to_url_encoded(String string) throws Exception {
        String string2 = "";
        byte[] byArray = string.getBytes("ISO-8859-1");
        String string3 = new String(byArray, "UTF-8");
        for (int i = 0; i < string3.length(); ++i) {
            char c = string3.charAt(i);
            string2 = c > '\u00ff' ? string2 + String.format("&#x%02X;", c) : (c > '\u007f' ? string2 + String.format("%%%02X", c) : string2 + String.format("%c", Character.valueOf(c)));
        }
        return string2;
    }

    public static String raw_filename_to_url_encoded(String string) throws Exception {
        String string2 = "";
        byte[] byArray = string.getBytes();
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            string2 = n > 127 ? string2 + String.format("%%%02X", n) : string2 + String.format("%c", Character.valueOf((char)n));
        }
        return string2;
    }

    public static String fullFilepathToURLEncoding(String string) {
        if (!MULTIPLE_FILENAME_ENCODINGS_SUPPORTED) {
            return string;
        }
        File file = new File(string);
        String string2 = FilenameEncoding.fileToURLEncoding(file);
        if (string2.endsWith(URL_FILE_SEPARATOR + "." + URL_FILE_SEPARATOR)) {
            string2 = string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    public static String relativeFilenameToURLEncoding(String string) {
        if (!MULTIPLE_FILENAME_ENCODINGS_SUPPORTED) {
            return string;
        }
        String string2 = FilenameEncoding.fullFilepathToURLEncoding(".");
        return FilenameEncoding.filenameToURLEncodingWithPrefixRemoved(string, string2);
    }

    public static String filenameToURLEncodingWithPrefixRemoved(String string, String string2) {
        if (!MULTIPLE_FILENAME_ENCODINGS_SUPPORTED) {
            return string;
        }
        File file = new File(string);
        String string3 = FilenameEncoding.fileToURLEncoding(file);
        if ((string3 = string3.substring(string2.length())).startsWith(URL_FILE_SEPARATOR)) {
            string3 = string3.substring(URL_FILE_SEPARATOR.length());
        }
        return string3;
    }

    public static String stringToHex(String string) {
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            int n = string.codePointAt(i);
            string2 = n >= 20 && n <= 126 || n == 9 || n == 10 || n == 13 ? string2 + string.charAt(i) : string2 + "&#x" + String.format("%x", n).toUpperCase() + ";";
        }
        return string2;
    }

    public static String hexEntityForChar(String string) {
        int n = string.codePointAt(0);
        String string2 = "&#x" + String.format("%x", n).toUpperCase() + ";";
        return string2;
    }

    public static String escapeAllCharWithHexEntity(String string, char c) {
        if (string.indexOf(c) == -1) {
            return string;
        }
        String string2 = Character.toString(c);
        String string3 = FilenameEncoding.hexEntityForChar(string2);
        Matcher matcher = HEX_PATTERN.matcher(string);
        int n = 0;
        boolean bl = false;
        while (!bl) {
            if ((n = string.indexOf(c, n)) == -1) {
                bl = true;
                continue;
            }
            if (matcher.find(n) && n == matcher.start()) {
                n = matcher.end();
                continue;
            }
            String string4 = string.substring(0, n) + string3;
            if (string.length() > ++n) {
                string4 = string4 + string.substring(n);
            }
            string = string4;
            n = n + string3.length() - 1;
            matcher = HEX_PATTERN.matcher(string);
            if (n < string.length()) continue;
            bl = true;
        }
        return string;
    }
}

