/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.metadata.MetadataValueTreeModel;
import org.greenstone.gatherer.metadata.MetadataValueTreeNode;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class MetadataElement {
    private String metadata_element_name_full = null;
    private Element metadata_element_element = null;
    private MetadataValueTreeModel metadata_value_tree_model = null;
    private boolean predefined_values = false;
    private boolean restricted_values = false;
    private boolean accumulating = true;

    public MetadataElement(String string, Element element) {
        this.metadata_element_name_full = string;
        this.metadata_element_element = element;
        this.metadata_value_tree_model = new MetadataValueTreeModel(this);
        if (element != null) {
            if (element.getAttribute("predefined").equals("true")) {
                this.predefined_values = true;
                this.loadOptionList();
                if (element.getAttribute("restricted").equals("true")) {
                    this.restricted_values = true;
                }
            }
            if (element.getAttribute("accumulating").equals("false")) {
                this.accumulating = false;
            }
        }
    }

    protected boolean loadOptionList() {
        NodeList nodeList = this.metadata_element_element.getElementsByTagName("Value");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string = XMLTools.getValue(nodeList.item(i));
            this.addMetadataValue(string);
        }
        return true;
    }

    public MetadataValueTreeNode addMetadataValue(String string) {
        return this.metadata_value_tree_model.addMetadataValue(string);
    }

    public String getAttribute(String string, String string2) {
        Object object;
        if (this.metadata_element_element == null) {
            return null;
        }
        Element element = this.metadata_element_element;
        boolean bl = false;
        NodeList nodeList = this.metadata_element_element.getElementsByTagName("Language");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            object = element2.getAttribute("code");
            if (!((String)object).equals(string2)) continue;
            element = element2;
            bl = true;
            break;
        }
        NodeList nodeList2 = element.getElementsByTagName("Attribute");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object = (Element)nodeList2.item(i);
            String string3 = object.getAttribute("name");
            if (!string3.equals(string)) continue;
            String string4 = object.getAttribute("language");
            if (!bl && !string4.equals(string2)) continue;
            return XMLTools.getElementTextValue((Element)object);
        }
        return null;
    }

    public String getDisplayName() {
        String string = MetadataTools.getMetadataElementAttribute(this, "label", Configuration.getLanguage(), "en");
        if (string == null) {
            string = MetadataTools.getMetadataElementAttribute(this, "identifier", Configuration.getLanguage(), "en");
        }
        if (this.metadata_element_name_full.indexOf("^") == -1) {
            if (string != null) {
                return this.getNamespace() + "." + string;
            }
            return this.metadata_element_name_full;
        }
        String string2 = this.metadata_element_name_full.substring(0, this.metadata_element_name_full.lastIndexOf("^"));
        MetadataElement metadataElement = MetadataTools.getMetadataElementWithName(string2);
        String string3 = string2;
        if (metadataElement != null) {
            string3 = metadataElement.getDisplayName();
        }
        if (string != null) {
            return string3 + "^" + string;
        }
        return string3 + this.metadata_element_name_full.substring(string2.length());
    }

    public MetadataValueTreeModel getMetadataValueTreeModel() {
        return this.metadata_value_tree_model;
    }

    public MetadataValueTreeNode getMetadataValueTreeNode(String string) {
        return this.metadata_value_tree_model.getMetadataValueTreeNode(string);
    }

    public String getFullName() {
        return this.metadata_element_name_full;
    }

    public String getNamespace() {
        return MetadataTools.getMetadataSetNamespace(this.metadata_element_name_full);
    }

    public String getName() {
        return MetadataTools.getMetadataElementName(this.metadata_element_name_full);
    }

    public boolean isGSExtractedMetadataElement() {
        return this.getNamespace().equals("ex");
    }

    public boolean isExtractedMetadataElement() {
        return this.getNamespace().startsWith("ex");
    }

    public boolean isPredefined() {
        return this.predefined_values;
    }

    public boolean isRestricted() {
        return this.restricted_values;
    }

    public boolean isAccumulating() {
        return this.accumulating;
    }

    public boolean isSubelement() {
        return this.metadata_element_name_full.indexOf("^") != -1;
    }

    public String toString() {
        return this.getDisplayName();
    }
}

