/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.util.ArrayList;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.gui.MetadataImportMappingPrompt;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSet;
import org.greenstone.gatherer.metadata.MetadataTools;
import org.greenstone.gatherer.metadata.ProfileXMLFileManager;

public class MetadataSetManager {
    public static final String EXTRACTED_METADATA_NAMESPACE = "ex";
    public static final String EXPLODED_METADATA_NAMESPACE = "exp";
    private static ArrayList metadata_sets = new ArrayList();
    private static MetadataImportMappingPrompt metadata_import_mapping_prompt = null;

    public static void clearMetadataSets() {
        metadata_sets.clear();
    }

    public static int compareMetadataElements(MetadataElement metadataElement, MetadataElement metadataElement2) {
        if (!metadataElement.getNamespace().equals(metadataElement2.getNamespace())) {
            if (metadataElement.getNamespace().equals(EXTRACTED_METADATA_NAMESPACE)) {
                return 1;
            }
            if (metadataElement2.getNamespace().equals(EXTRACTED_METADATA_NAMESPACE)) {
                return -1;
            }
            return metadataElement.getNamespace().compareTo(metadataElement2.getNamespace());
        }
        MetadataSet metadataSet = MetadataSetManager.getMetadataSet(metadataElement.getNamespace());
        return metadataSet.compareMetadataElements(metadataElement, metadataElement2);
    }

    public static ArrayList getEveryMetadataSetElement() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < metadata_sets.size(); ++i) {
            MetadataSet metadataSet = (MetadataSet)metadata_sets.get(i);
            arrayList.addAll(metadataSet.getMetadataSetElements());
        }
        return arrayList;
    }

    public static MetadataSet getMetadataSet(String string) {
        for (int i = 0; i < metadata_sets.size(); ++i) {
            MetadataSet metadataSet = (MetadataSet)metadata_sets.get(i);
            if (!metadataSet.getNamespace().equals(string)) continue;
            return metadataSet;
        }
        return null;
    }

    public static ArrayList getMetadataSets() {
        return (ArrayList)metadata_sets.clone();
    }

    public static ArrayList listMetadataSets(File file) {
        if (!file.exists()) {
            return null;
        }
        ArrayList<MetadataSet> arrayList = new ArrayList<MetadataSet>();
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory() || !file2.getName().endsWith(".mds")) continue;
            MetadataSet metadataSet = new MetadataSet(file2);
            arrayList.add(metadataSet);
        }
        return arrayList;
    }

    public static void loadMetadataSets(File file) {
        if (!file.exists()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                MetadataSetManager.loadMetadataSets(file2);
                continue;
            }
            if (!file2.getName().endsWith(".mds")) continue;
            MetadataSetManager.loadMetadataSet(file2);
        }
    }

    public static void loadMetadataSet(File file) {
        MetadataSet metadataSet = new MetadataSet(file);
        if (metadataSet.getNamespace().equals("hidden")) {
            return;
        }
        metadata_sets.add(metadataSet);
    }

    public static String mapUnloadedMetadataElement(final String string) {
        Object object;
        String string2 = ProfileXMLFileManager.getMetadataElementFor(string);
        if (string2 != null) {
            return string2;
        }
        if (metadata_sets.size() <= 1) {
            return null;
        }
        Gatherer.invokeInEDT_replacesProceedInCurrThread("MetadataSetManager.mapUnloadedMetadataElement() - metadata_import_mapping_prompt", true, new Runnable(){

            @Override
            public void run() {
                metadata_import_mapping_prompt = new MetadataImportMappingPrompt(string);
            }
        });
        int n = metadata_import_mapping_prompt.getResult();
        if (n == 0) {
            object = metadata_import_mapping_prompt.getSelectedMetadataSet();
            String string3 = MetadataTools.getMetadataElementName(string);
            ((MetadataSet)object).addMetadataElementForThisSession(string3);
            string2 = ((MetadataSet)object).getNamespace() + "." + string3;
        }
        if (n == 1) {
            object = metadata_import_mapping_prompt.getSelectedMetadataElement();
            string2 = ((MetadataElement)object).getFullName();
        }
        if (n == 2) {
            string2 = "";
        }
        metadata_import_mapping_prompt = null;
        ProfileXMLFileManager.mapElement(string, string2);
        return string2;
    }

    public static void unloadMetadataSet(MetadataSet metadataSet) {
        for (int i = 0; i < metadata_sets.size(); ++i) {
            if (metadataSet != (MetadataSet)metadata_sets.get(i)) continue;
            metadata_sets.remove(i);
            break;
        }
    }
}

