/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataValue;
import org.greenstone.gatherer.metadata.MetadataXMLFileManager;
import org.greenstone.gatherer.util.SafeProcess;
import org.greenstone.gatherer.util.Utility;

public class MetadataToCSV
implements FileFilter {
    private char meta_field_sep = (char)44;
    private String meta_value_sep_re = "\\|";
    private char meta_value_sep_char = (char)124;
    private String collection_directory_path = "";
    private String coll_importdir_path = "";
    private final int import_path_length;
    private File metadataCSVFile;
    private final String IMPORT_DIRNAME = "import";
    TreeMap<File, TreeMap<String, TreeSet<String>>> collMetaMap = new TreeMap();

    public MetadataToCSV(String string) {
        this.collection_directory_path = string;
        this.coll_importdir_path = string + "import" + File.separator;
        this.import_path_length = this.coll_importdir_path.length();
        this.metadataCSVFile = new File(this.coll_importdir_path, "metadata.csv");
    }

    public MetadataToCSV(String string, File file) {
        this(string);
        this.metadataCSVFile = file;
    }

    public MetadataToCSV(String string, File file, char c, String string2, char c2) {
        this(string, file);
        this.meta_field_sep = c;
        this.meta_value_sep_re = string2;
        this.meta_value_sep_char = c2;
    }

    private String fileToRelativeString(File file) {
        String string = file.getAbsolutePath();
        int n = string.indexOf(this.coll_importdir_path);
        if (n == -1) {
            return string;
        }
        string = string.substring(n + this.import_path_length);
        if (Utility.isWindows()) {
            string = string.replace("\\", "/");
        }
        return string;
    }

    public TreeMap<File, TreeMap<String, TreeSet<String>>> getAllAssignedMetadataForAllFiles() {
        TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap = new TreeMap<File, TreeMap<String, TreeSet<String>>>();
        ArrayList<File> arrayList = this.listFilesInCollection(this.collection_directory_path);
        for (File file : arrayList) {
            ArrayList arrayList2 = MetadataXMLFileManager.getMetadataAssignedToFile(file);
            TreeMap<String, TreeSet<String>> treeMap2 = new TreeMap<String, TreeSet<String>>();
            for (MetadataValue metadataValue : arrayList2) {
                String string = metadataValue.getValue();
                MetadataElement metadataElement = metadataValue.getMetadataElement();
                String string2 = metadataElement.getFullName();
                TreeSet<String> treeSet = (TreeSet<String>)treeMap2.get(string2);
                if (treeSet == null) {
                    treeSet = new TreeSet<String>();
                    treeSet.add(string);
                    treeMap2.put(string2, treeSet);
                    continue;
                }
                treeSet.add(string);
            }
            treeMap.put(file, treeMap2);
        }
        return treeMap;
    }

    private void amalgamateAllMeta() {
        TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap = this.getAllAssignedMetadataForAllFiles();
        TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap2 = this.loadMetaFromCSVFile(this.metadataCSVFile);
        if (this.collMetaMap.size() == 0) {
            if (treeMap.keySet().size() > treeMap2.keySet().size()) {
                this.collMetaMap = treeMap;
                this.merge(this.collMetaMap, treeMap2);
            } else {
                this.collMetaMap = treeMap2;
                this.merge(this.collMetaMap, treeMap);
            }
        } else {
            this.merge(this.collMetaMap, treeMap);
            this.merge(this.collMetaMap, treeMap2);
        }
    }

    private TreeSet<String> getAllCollHeadings(TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap) {
        TreeSet<String> treeSet = new TreeSet<String>();
        if (treeMap == null || treeMap.size() == 0) {
            return treeSet;
        }
        for (File file : treeMap.keySet()) {
            TreeMap<String, TreeSet<String>> treeMap2 = treeMap.get(file);
            for (String string : treeMap2.keySet()) {
                treeSet.add(string);
            }
        }
        return treeSet;
    }

    private void merge(TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap, TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap2) {
        if (treeMap2 == null || treeMap2.size() == 0) {
            return;
        }
        for (File file : treeMap2.keySet()) {
            TreeMap<String, TreeSet<String>> treeMap3 = treeMap.get(file);
            TreeMap<String, TreeSet<String>> treeMap4 = treeMap2.get(file);
            Iterator<String> iterator = treeMap4.keySet().iterator();
            if (treeMap3 == null) {
                treeMap2.put(file, treeMap4);
                continue;
            }
            while (iterator.hasNext()) {
                String string = iterator.next();
                TreeSet<String> treeSet = treeMap4.get(string);
                TreeSet<String> treeSet2 = treeMap3.get(string);
                if (treeSet2 == null) {
                    treeMap3.put(string, treeSet);
                    continue;
                }
                for (String string2 : treeSet) {
                    if (treeSet2.contains(string2)) continue;
                    treeSet2.add(string2);
                }
            }
        }
    }

    public boolean convertMetaXMLToCSV(File file, JFrame jFrame) {
        int n = JOptionPane.showConfirmDialog(jFrame, Dictionary.get("MetaToCSV.ConvertMetaXMLToCSV_Warning_Message"), Dictionary.get("General.Warning"), 2, 2);
        if (n == 2 || n == -1) {
            return false;
        }
        boolean bl = this.exportMetaXMLToCSV(file);
        if (bl) {
            System.err.println("About to clear all metadata in collection...");
            MetadataXMLFileManager.clearAllMetadataInCollection();
        } else {
            JOptionPane.showMessageDialog(jFrame, Dictionary.get("MetaToCSV.ConvertMetaXMLToCSV_Failed_Message"), Dictionary.get("General.Error"), 0);
        }
        return bl;
    }

    public boolean exportMetaXMLToCSV(File file) {
        boolean bl = false;
        boolean bl2 = false;
        if (file.exists()) {
            this.amalgamateAllMeta();
            bl2 = this.writeMetaToCSV(this.collMetaMap, file, bl);
        } else {
            TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap = this.getAllAssignedMetadataForAllFiles();
            bl2 = this.writeMetaToCSV(treeMap, file, bl);
        }
        return bl2;
    }

    private boolean writeMetaToCSV(TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap, File file, boolean bl) {
        boolean bl2 = true;
        TreeSet<String> treeSet = this.getAllCollHeadings(treeMap);
        Vector<String> vector = new Vector<String>(treeSet.size());
        vector.add("Filename");
        vector.addAll(treeSet);
        CSVFormat cSVFormat = CSVFormat.DEFAULT.withDelimiter(this.meta_field_sep).withIgnoreSurroundingSpaces(false).withQuoteMode(QuoteMode.MINIMAL).withTrim();
        CSVPrinter cSVPrinter = null;
        try {
            cSVPrinter = new CSVPrinter(new OutputStreamWriter((OutputStream)new FileOutputStream(file, bl), "UTF-8"), cSVFormat);
            cSVPrinter.printRecord(vector);
            for (File file2 : treeMap.keySet()) {
                String string = this.fileToRelativeString(file2);
                cSVPrinter.print(string);
                TreeMap<String, TreeSet<String>> treeMap2 = treeMap.get(file2);
                for (int i = 1; i < vector.size(); ++i) {
                    String string2 = (String)vector.get(i);
                    TreeSet<String> treeSet2 = treeMap2.get(string2);
                    StringBuffer stringBuffer = new StringBuffer();
                    if (treeSet2 == null || treeSet2.size() == 0) {
                        cSVPrinter.print(stringBuffer);
                        continue;
                    }
                    for (String string3 : treeSet2) {
                        stringBuffer.append(this.meta_value_sep_char);
                        stringBuffer.append(string3);
                    }
                    cSVPrinter.print(stringBuffer.substring(1));
                }
                cSVPrinter.println();
            }
            cSVPrinter.close();
        }
        catch (IOException iOException) {
            bl2 = false;
            DebugStream.printStackTrace(iOException);
            System.err.println("Caught exception when writing meta to CSVFile " + file.getAbsolutePath());
            System.err.println("\t" + iOException.getMessage());
            SafeProcess.closeResource(cSVPrinter);
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TreeMap<File, TreeMap<String, TreeSet<String>>> loadMetaFromCSVFile(File file) {
        TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap = new TreeMap<File, TreeMap<String, TreeSet<String>>>();
        if (!file.exists()) {
            return treeMap;
        }
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            boolean bl = true;
            CSVFormat cSVFormat = CSVFormat.DEFAULT.withDelimiter(this.meta_field_sep).withFirstRecordAsHeader().withCommentMarker('#').withIgnoreSurroundingSpaces().withTrim();
            CSVParser cSVParser = cSVFormat.parse(inputStreamReader);
            String[] stringArray = cSVParser.getHeaderMap().keySet().toArray(new String[0]);
            for (CSVRecord cSVRecord : cSVParser) {
                TreeMap<String, Object> treeMap2 = new TreeMap<String, Object>();
                for (int i = 0; i < cSVRecord.size(); ++i) {
                    String[] stringArray2;
                    Object object;
                    Object object2;
                    String string = cSVRecord.get(i);
                    if (i == 0) {
                        object2 = string;
                        if (Utility.isWindows()) {
                            object2 = ((String)object2).replace("/", "\\");
                        }
                        object = new File(this.coll_importdir_path + (String)object2);
                        treeMap.put((File)object, treeMap2);
                        continue;
                    }
                    object2 = new TreeSet();
                    object = stringArray[i];
                    treeMap2.put((String)object, object2);
                    String string2 = string.trim();
                    for (String string3 : stringArray2 = string2.split(this.meta_value_sep_re)) {
                        if ((string3 = string3.trim()).equals("")) continue;
                        ((TreeSet)object2).add(string3);
                    }
                }
            }
        }
        catch (Exception exception) {
            try {
                DebugStream.printStackTrace(exception);
                DebugStream.println("@@@ Error reading from CSV file: " + file.getAbsolutePath());
            }
            catch (Throwable throwable) {
                SafeProcess.closeResource(inputStreamReader);
                throw throwable;
            }
            SafeProcess.closeResource(inputStreamReader);
        }
        SafeProcess.closeResource(inputStreamReader);
        return treeMap;
    }

    private void print(TreeMap<File, TreeMap<String, TreeSet<String>>> treeMap) {
        for (File file : treeMap.keySet()) {
            Iterator<String> iterator;
            TreeMap<String, TreeSet<String>> treeMap2 = treeMap.get(file);
            if (treeMap2 != null) {
                System.err.println("Meta for file: " + this.fileToRelativeString(file));
            }
            if (!(iterator = treeMap2.keySet().iterator()).hasNext()) {
                System.err.println("No meta for file!");
            }
            while (iterator.hasNext()) {
                String string = iterator.next();
                System.err.println("\tMetafield: " + string);
                TreeSet<String> treeSet = treeMap2.get(string);
                for (String string2 : treeSet) {
                    System.err.println("\t\tValue: " + string2);
                }
            }
        }
    }

    private void printOrderedCollectionMeta() {
        this.amalgamateAllMeta();
        this.print(this.collMetaMap);
    }

    public ArrayList<File> listFilesInCollection(String string) {
        File file = new File(string, "import");
        ArrayList<File> arrayList = new ArrayList<File>();
        this.getAllFiles(arrayList, file, this);
        return arrayList;
    }

    private void getAllFiles(ArrayList<File> arrayList, File file, FileFilter fileFilter) {
        File[] fileArray = file.listFiles(fileFilter);
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isFile()) {
                arrayList.add(file2);
                continue;
            }
            this.getAllFiles(arrayList, file2, fileFilter);
        }
    }

    @Override
    public boolean accept(File file) {
        String string = file.getName();
        if (file.isDirectory()) {
            if (string.equals(".svn")) {
                return false;
            }
        } else {
            if (file.equals(this.metadataCSVFile)) {
                return false;
            }
            if (string.equals("metadata.xml")) {
                return false;
            }
            if (string.endsWith("~")) {
                return false;
            }
            if (string.endsWith(".bak")) {
                return false;
            }
        }
        return true;
    }

    public static File chooseMetaCSVFile(String string, boolean bl, JFrame jFrame) {
        if (Gatherer.isWebswing) {
            String string2 = "metadata.csv";
            File file = new File(string, string2);
            System.err.println("meta file = " + file.getAbsolutePath());
            int n = 1;
            while (file.exists()) {
                string2 = "metadata" + n + ".csv";
                file = new File(string, string2);
                ++n;
            }
            return file;
        }
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(0);
        String string3 = Dictionary.get("MetaToCSV.ExportAction");
        if (bl) {
            string3 = Dictionary.get("MetaToCSV.ConvertAction");
        }
        jFileChooser.setDialogTitle(Dictionary.get("MetaToCSV.ChooseMetaCSVFile", string3));
        jFileChooser.setApproveButtonText(Dictionary.get("MetaToCSV.Choose"));
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(Dictionary.get("MetaToCSV.CSVFileExtensionType"), "csv");
        jFileChooser.setFileFilter(fileNameExtensionFilter);
        int n = jFileChooser.showOpenDialog(jFrame);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            return file;
        }
        return null;
    }
}

