/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import org.greenstone.gatherer.metadata.MetadataElement;
import org.greenstone.gatherer.metadata.MetadataSetManager;
import org.greenstone.gatherer.metadata.MetadataValueTreeNode;

public class MetadataValue
implements Comparable {
    private File folder_metadata_inherited_from = null;
    private MetadataElement metadata_element = null;
    private MetadataValueTreeNode metadata_value_tree_node = null;
    private boolean must_not_accumulate = false;
    private boolean is_accumulating_metadata = false;
    private boolean is_one_file_only_metadata = true;

    public MetadataValue(MetadataElement metadataElement, MetadataValueTreeNode metadataValueTreeNode) {
        this.metadata_element = metadataElement;
        this.metadata_value_tree_node = metadataValueTreeNode;
        if (metadataElement != null && !metadataElement.isAccumulating()) {
            this.must_not_accumulate = true;
        }
    }

    public int compareTo(Object object) {
        MetadataValue metadataValue = (MetadataValue)object;
        int n = MetadataSetManager.compareMetadataElements(this.getMetadataElement(), metadataValue.getMetadataElement());
        if (n != 0) {
            return n;
        }
        return this.getFullValue().compareTo(metadataValue.getFullValue());
    }

    public File getFolderMetadataInheritedFrom() {
        return this.folder_metadata_inherited_from;
    }

    public MetadataElement getMetadataElement() {
        return this.metadata_element;
    }

    public String getFullValue() {
        return this.metadata_value_tree_node.getFullValue();
    }

    public String getValue() {
        return this.metadata_value_tree_node.getValue();
    }

    public MetadataValueTreeNode getMetadataValueTreeNode() {
        return this.metadata_value_tree_node;
    }

    public void inheritsMetadataFromFolder(File file) {
        this.folder_metadata_inherited_from = file;
    }

    public boolean isAccumulatingMetadata() {
        return this.is_accumulating_metadata;
    }

    public boolean isInheritedMetadata() {
        return this.folder_metadata_inherited_from != null;
    }

    public boolean isOneFileOnlyMetadata() {
        return this.is_one_file_only_metadata;
    }

    public void setIsAccumulatingMetadata(boolean bl) {
        if (!this.must_not_accumulate) {
            this.is_accumulating_metadata = bl;
        }
    }

    public void setIsOneFileOnlyMetadata(boolean bl) {
        this.is_one_file_only_metadata = bl;
    }
}

