/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.metadata;

import java.io.File;
import java.util.HashMap;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.collection.CollectionManager;
import org.greenstone.gatherer.util.XMLTools;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ProfileXMLFile
extends File {
    private HashMap metadata_mapping = null;

    public ProfileXMLFile(String string) {
        super(string);
    }

    public String getMetadataElementFor(String string) {
        if (this.getMetadataMapping() == null) {
            return null;
        }
        return (String)this.metadata_mapping.get(string);
    }

    public HashMap getMetadataMapping() {
        if (this.metadata_mapping != null) {
            return this.metadata_mapping;
        }
        this.metadata_mapping = new HashMap();
        Document document = XMLTools.parseXMLFile(this);
        if (document == null) {
            System.err.println("Error: Could not parse profile.xml file " + this.getAbsolutePath());
            return null;
        }
        NodeList nodeList = document.getElementsByTagName("Action");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("source");
            String string2 = element.getAttribute("target");
            this.metadata_mapping.put(string, string2);
        }
        return this.metadata_mapping;
    }

    public void mapElement(String string, String string2) {
        Document document = XMLTools.parseXMLFile(this);
        if (document == null) {
            System.err.println("Error: Could not parse profile.xml file " + this.getAbsolutePath());
            return;
        }
        Element element = document.createElement("Action");
        element.setAttribute("source", string);
        element.setAttribute("target", string2);
        document.getDocumentElement().appendChild(element);
        XMLTools.writeXMLFile(this, document);
        if (Gatherer.isGsdlRemote) {
            Gatherer.remoteGreenstoneServer.uploadCollectionFile(CollectionManager.getLoadedCollectionName(), this);
        }
        this.metadata_mapping = null;
    }
}

