/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.remote;

import java.io.FileNotFoundException;
import java.net.ConnectException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Dictionary;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.remote.RemoteGreenstoneServerAction;

class ActionQueue
extends Thread {
    private ArrayList queue = null;
    private boolean exited = false;

    public ActionQueue() {
        super("RemoteGreenstoneServerActionQueue");
        if (Gatherer.isGsdlRemote) {
            this.queue = new ArrayList();
            this.start();
        }
    }

    public synchronized void addAction(RemoteGreenstoneServerAction remoteGreenstoneServerAction) {
        this.queue.add(remoteGreenstoneServerAction);
        this.notifyAll();
    }

    public synchronized int size() {
        return this.queue.size();
    }

    public synchronized RemoteGreenstoneServerAction getAction(int n) {
        return (RemoteGreenstoneServerAction)this.queue.get(n);
    }

    public synchronized boolean hasExited() {
        return this.exited;
    }

    public synchronized void clear() {
        this.queue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        boolean bl = false;
        while (!bl) {
            Object object2;
            object = null;
            try {
                if (Gatherer.remoteGreenstoneServer != null) {
                    Gatherer.remoteGreenstoneServer.getProgressBar().setAction(null);
                }
                object2 = this;
                synchronized (object2) {
                    while (this.queue.size() <= 0) {
                        this.wait();
                    }
                    object = (RemoteGreenstoneServerAction)this.queue.get(0);
                }
            }
            catch (InterruptedException interruptedException) {
                bl = true;
            }
            if (bl) break;
            try {
                ((RemoteGreenstoneServerAction)object).perform();
                ((RemoteGreenstoneServerAction)object).processed_successfully = true;
            }
            catch (RemoteGreenstoneServerAction.ActionCancelledException actionCancelledException) {
                ((RemoteGreenstoneServerAction)object).processed_successfully = false;
            }
            catch (ConnectException connectException) {
                if (connectException.getMessage().trim().startsWith("Connection refused")) {
                    bl = true;
                } else {
                    DebugStream.printStackTrace(connectException);
                }
                RemoteErrorPopup.invokeLater(connectException.getMessage());
                ((RemoteGreenstoneServerAction)object).processed_successfully = false;
            }
            catch (FileNotFoundException fileNotFoundException) {
                bl = true;
                DebugStream.printStackTrace(fileNotFoundException);
                RemoteErrorPopup.invokeLater("No gliserver.pl found. " + fileNotFoundException.getMessage());
                ((RemoteGreenstoneServerAction)object).processed_successfully = false;
            }
            catch (Exception exception) {
                DebugStream.printStackTrace(exception);
                RemoteErrorPopup.invokeLater(exception.getMessage());
                ((RemoteGreenstoneServerAction)object).processed_successfully = false;
            }
            try {
                ((RemoteGreenstoneServerAction)object).processed = true;
                object2 = object;
                synchronized (object2) {
                    object.notifyAll();
                }
            }
            catch (Exception exception) {
                System.err.println("RemoteGreenstoneServerActionQueue.run() - exception: " + exception);
            }
            object2 = this;
            synchronized (object2) {
                this.queue.remove(0);
            }
        }
        object = this;
        synchronized (object) {
            this.queue.clear();
            this.exited = true;
        }
    }

    private static class RemoteErrorPopup
    implements Runnable {
        private String message;

        public static void invokeLater(String string) {
            SwingUtilities.invokeLater(new RemoteErrorPopup(string));
        }

        private RemoteErrorPopup(String string) {
            this.message = string;
        }

        @Override
        public void run() {
            String string = Dictionary.get("RemoteGreenstoneServer.Error", this.message);
            JTextArea jTextArea = new JTextArea(20, 70);
            jTextArea.setText(string);
            jTextArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jTextArea);
            JOptionPane.showMessageDialog(Gatherer.g_man, jScrollPane, Dictionary.get("RemoteGreenstoneServer.Error_Title"), 0);
        }
    }
}

