/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.tree.TreePath;
import org.greenstone.gatherer.gui.tree.DragTree;
import org.greenstone.gatherer.util.DragComponent;

public class DragGroup
implements FocusListener {
    public BufferedImage image_ghost = null;
    public Point mouse_offset = null;
    private DragComponent ghost_owner = null;
    private DragTree drag_source = null;
    private TreePath[] selection = null;
    private Vector registered = new Vector();

    public void add(DragComponent dragComponent) {
        if (!this.registered.contains(dragComponent)) {
            this.registered.add(dragComponent);
            dragComponent.addFocusListener(this);
            dragComponent.setGroup(this);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        ((DragComponent)((Object)focusEvent.getComponent())).gainFocus();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        ((DragComponent)((Object)focusEvent.getComponent())).loseFocus();
    }

    public DragComponent getActive() {
        return this.ghost_owner;
    }

    public TreePath[] getSelection() {
        return this.selection;
    }

    public DragTree getSource() {
        return this.drag_source;
    }

    public void grabFocus(DragComponent dragComponent) {
        if (this.ghost_owner != null) {
            this.ghost_owner.clearGhost();
        }
        this.ghost_owner = dragComponent;
        for (int i = 0; i < this.registered.size(); ++i) {
            DragComponent dragComponent2 = (DragComponent)this.registered.get(i);
            if (dragComponent2 == dragComponent) {
                dragComponent2.gainFocus();
                continue;
            }
            dragComponent2.loseFocus();
        }
    }

    public void setSelection(TreePath[] treePathArray) {
        this.selection = treePathArray;
    }

    public void setSource(DragTree dragTree) {
        this.drag_source = dragTree;
    }
}

