/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import org.greenstone.gatherer.Configuration;
import org.greenstone.gatherer.DebugStream;
import org.greenstone.gatherer.Gatherer;
import org.greenstone.gatherer.util.Utility;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class GLIEntityResolver
implements EntityResolver {
    protected ArrayList<File> list_of_local_search_paths = new ArrayList();
    ClassLoader class_loader = null;

    public GLIEntityResolver() {
        if (Gatherer.GS3) {
            this.list_of_local_search_paths.add(new File(Configuration.gsdl3_writableweb_path, "WEB-INF"));
        }
        if (Gatherer.isGsdlRemote) {
            this.list_of_local_search_paths.add(new File(Configuration.gli_user_directory_path));
        }
    }

    public GLIEntityResolver(File file) {
        this();
        this.addSafeSearchPath(file, true);
    }

    public GLIEntityResolver(ClassLoader classLoader) {
        this.class_loader = classLoader;
    }

    public GLIEntityResolver(File file, ClassLoader classLoader) {
        this(file);
        this.class_loader = classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.class_loader = classLoader;
    }

    public void addSafeSearchPath(File file, boolean bl) {
        if (!Gatherer.GS3 && file.getAbsolutePath().startsWith(Configuration.gsdl_path) || Gatherer.GS3 && file.getAbsolutePath().startsWith(Configuration.gsdl3_src_path)) {
            File file2 = file.getParentFile();
            if (!this.list_of_local_search_paths.contains(file2)) {
                if (bl) {
                    this.list_of_local_search_paths.add(0, file2);
                } else {
                    this.list_of_local_search_paths.add(file2);
                }
            }
        } else {
            DebugStream.println("### Location of file " + file + " not within GS. Not adding to list of search paths.");
        }
    }

    @Override
    public InputSource resolveEntity(String string, String string2) {
        Serializable serializable;
        DebugStream.println("### resolveEntity() called for " + string2);
        String string3 = string2;
        if (string3.startsWith("file://")) {
            serializable = new File(string2);
            if (((File)serializable).exists()) {
                if (((File)serializable).getAbsolutePath().startsWith(Configuration.gsdl_path) || ((File)serializable).getAbsolutePath().startsWith(Configuration.gsdl3_src_path)) {
                    DebugStream.println("### file denoted by systemID is inside GS: " + ((File)serializable).getAbsolutePath());
                    return new InputSource(string2);
                }
                DebugStream.println("\t### file denoted by systemID exists, but not located inside GS: " + ((File)serializable).getAbsolutePath());
            } else {
                string3 = ((File)serializable).getName();
                for (File file : this.list_of_local_search_paths) {
                    DebugStream.println("### searching for entity '" + string3 + "' in: " + file.getAbsolutePath());
                    File file2 = new File(file, string3);
                    if (!file2.exists()) continue;
                    DebugStream.println("\t Found " + file2.getAbsolutePath());
                    String string4 = file2.getAbsolutePath();
                    string4 = Utility.isWindows() ? "file:///" + string4.replace("\\", "/") : "file://" + string4;
                    return new InputSource(string4);
                }
            }
        } else {
            DebugStream.println("### Entity is not a file: " + string2);
            if (string3.indexOf("/") != -1) {
                string3 = string3.substring(string3.lastIndexOf("/") + 1);
            }
        }
        DebugStream.println("### Using classloader to attempt to resolve entity: " + string3);
        if (this.class_loader == null) {
            this.class_loader = this.getClass().getClassLoader();
        }
        if ((serializable = this.class_loader.getResource(string3)) == null) {
            return null;
        }
        return new InputSource("file://" + ((URL)serializable).getFile());
    }
}

