/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

public class HTMLStringTokenizer {
    private int pos = 0;
    private String current = null;
    private String previous = null;
    private String source = null;

    public HTMLStringTokenizer(String string) {
        this.source = string;
        this.parseToken();
    }

    public boolean hasMoreTokens() {
        return this.current != null && this.current.length() > 0;
    }

    public boolean isTag() {
        return this.previous.startsWith("<") && this.previous.endsWith(">");
    }

    public String nextToken() {
        this.previous = this.current;
        this.parseToken();
        return this.previous;
    }

    private void parseToken() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        this.current = "";
        this.dumpWhiteSpace();
        while (this.pos < this.source.length() && !bl) {
            char c = this.source.charAt(this.pos);
            if (!bl2 && !bl3) {
                if (c == '<') {
                    bl2 = true;
                } else {
                    bl3 = true;
                }
                this.current = this.current + c;
            } else if (bl2) {
                if (c == '>') {
                    bl = true;
                }
                this.current = this.current + c;
            } else if (bl3) {
                if (c == ' ') {
                    bl = true;
                } else if (c == '<') {
                    bl = true;
                    --this.pos;
                } else {
                    this.current = this.current + c;
                }
            }
            ++this.pos;
        }
    }

    private void dumpWhiteSpace() {
        while (this.pos < this.source.length() && this.source.charAt(this.pos) == ' ') {
            ++this.pos;
        }
    }
}

