/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;

public class PortFinder {
    public static final int MAX_PORT = 65535;
    public static final int PORTS_RESERVED = 1024;
    public final int PORT_BASE;
    public final int PORT_BLOCK_SIZE;
    private int nextFreePort;
    private int port = -1;

    public PortFinder() {
        this(1025, 64511);
    }

    public PortFinder(int n, int n2) {
        this.PORT_BASE = n;
        this.PORT_BLOCK_SIZE = n2;
        this.nextFreePort = this.PORT_BASE;
    }

    private void incrementNextFreePort() {
        int n = this.nextFreePort - this.PORT_BASE;
        n = (n + 1) % this.PORT_BLOCK_SIZE;
        this.nextFreePort = this.PORT_BASE + n;
    }

    public int findPortInRange(boolean bl) throws Exception {
        try {
            boolean bl2 = false;
            for (int i = 0; i < this.PORT_BLOCK_SIZE; ++i) {
                if (PortFinder.isPortAvailable(this.nextFreePort, bl)) {
                    bl2 = true;
                    break;
                }
                this.incrementNextFreePort();
            }
            if (!bl2) {
                throw new Exception("Cannot find an available port in the range " + this.PORT_BASE + "-" + (this.PORT_BASE + this.PORT_BLOCK_SIZE));
            }
            this.port = this.nextFreePort;
            this.incrementNextFreePort();
        }
        catch (IOException iOException) {
            System.err.println("Error when trying to find an available port. In PortFinder.findPort() " + iOException);
        }
        return this.port;
    }

    public static boolean isValidPortNumber(int n) {
        return n >= 0 && n <= 65535;
    }

    public static boolean isAssignablePortNumber(int n) {
        return n > 1024 && n <= 65535;
    }

    public static int findAnyFreePort() throws Exception {
        ServerSocket serverSocket = null;
        int n = -1;
        try {
            serverSocket = new ServerSocket(0);
            n = serverSocket.getLocalPort();
            serverSocket.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to find a free port or close it. Got Exception: " + exception);
            serverSocket = null;
        }
        return n;
    }

    public static boolean isPortAvailable(int n, boolean bl) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
            serverSocket.close();
            return true;
        }
        catch (BindException bindException) {
            if (bl) {
                System.err.println("Port " + n + " already in use or can't be assigned.");
            }
            serverSocket = null;
            return false;
        }
        catch (Exception exception) {
            System.err.println("Problem creating or closing server socket at port " + n);
            serverSocket = null;
            return false;
        }
    }
}

