/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class RemoveContentBeforeRootElementXMLReader
extends Reader {
    static final Pattern[] xmlIndicators = new Pattern[3];
    static Pattern commentStart;
    static Pattern commentStop;
    Reader ur;
    String finalBuffer = null;
    int finalBufferIndex = 0;

    public RemoveContentBeforeRootElementXMLReader(Reader reader) {
        this.ur = reader;
        int n = -1;
        boolean bl = false;
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 != -1 && n == -1) {
            try {
                n2 = reader.read();
            }
            catch (Exception exception) {
                System.err.println("Exception while reading underlying Reader in RemoveContentBeforeRootElementXMLReader");
            }
            if (n2 == -1) break;
            if (stringBuffer == null && (char)n2 == '<') {
                stringBuffer = new StringBuffer();
            }
            if (stringBuffer == null) {
                System.err.print((char)n2);
                continue;
            }
            stringBuffer.append((char)n2);
            if (!bl) {
                if (commentStart.matcher(stringBuffer.toString()).find()) {
                    bl = true;
                    System.err.print(stringBuffer.toString());
                    stringBuffer = new StringBuffer();
                }
            } else if (commentStop.matcher(stringBuffer.toString()).find()) {
                bl = false;
                System.err.print(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            if (bl) continue;
            for (int i = 0; i < xmlIndicators.length && n == -1; ++i) {
                if (!xmlIndicators[i].matcher(stringBuffer.toString()).find()) continue;
                n = i;
                String string = stringBuffer.toString();
                int n3 = string.lastIndexOf(60);
                System.err.print(string.substring(0, n3));
                stringBuffer.delete(0, n3);
                this.finalBuffer = stringBuffer.toString();
            }
        }
        if (n == -1) {
            System.err.println("RemoveContentBeforeRootElementXMLReader:\nThe XML being loaded was not valid: couldn't find start of XML input");
        }
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        for (int i = n; i < n + n2 && i < cArray.length; ++i) {
            int n3 = this.read();
            if (n3 == -1) {
                if (i == n) {
                    return -1;
                }
                return i - n;
            }
            cArray[i] = (char)n3;
        }
        return n2;
    }

    @Override
    public int read() throws IOException {
        if (this.finalBuffer != null && this.finalBuffer.length() > this.finalBufferIndex) {
            char c = this.finalBuffer.charAt(this.finalBufferIndex++);
            if (this.finalBufferIndex == this.finalBuffer.length()) {
                this.finalBuffer = null;
            }
            return c;
        }
        return this.ur.read();
    }

    @Override
    public void close() throws IOException {
        this.ur.close();
    }

    public static void main(String[] stringArray) {
        System.out.println("------------\nWill now initialise the test reader\n------------");
        RemoveContentBeforeRootElementXMLReader removeContentBeforeRootElementXMLReader = null;
        try {
            removeContentBeforeRootElementXMLReader = new RemoveContentBeforeRootElementXMLReader(new FileReader(new File("text.xml")));
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Please create text.xml to test this class");
            System.exit(-1);
        }
        System.out.println("------------\nWill now read the rest of the input\n------------");
        try {
            int n = 0;
            while ((n = removeContentBeforeRootElementXMLReader.read()) != -1) {
                System.out.print((char)n);
            }
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception);
        }
    }

    static {
        try {
            RemoveContentBeforeRootElementXMLReader.xmlIndicators[0] = Pattern.compile("<\\?xml");
            RemoveContentBeforeRootElementXMLReader.xmlIndicators[1] = Pattern.compile("<!DOCTYPE");
            RemoveContentBeforeRootElementXMLReader.xmlIndicators[2] = Pattern.compile("<[a-zA-Z-]+[ >/]");
            commentStart = Pattern.compile("<!--");
            commentStop = Pattern.compile("-->");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            System.err.println("Pattern no good. " + patternSyntaxException);
            RemoveContentBeforeRootElementXMLReader.xmlIndicators[2] = null;
            RemoveContentBeforeRootElementXMLReader.xmlIndicators[1] = null;
            RemoveContentBeforeRootElementXMLReader.xmlIndicators[0] = null;
            commentStop = null;
            commentStart = null;
        }
    }
}

