/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.compat;

import com.sun.jimi.core.ImageSeriesDecodingController;
import com.sun.jimi.core.JimiDecoder;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.JimiImageHandle;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.MutableJimiImage;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBaseSeriesController;
import com.sun.jimi.core.util.ErrorJimiImage;
import com.sun.jimi.core.util.JimiImageFactoryProxy;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressMonitorSupport;
import java.awt.image.ColorModel;
import java.io.InputStream;
import java.util.Vector;

public abstract class JimiDecoderBase
extends ProgressMonitorSupport
implements JimiDecoder,
Runnable {
    public static final int ERROR = 1;
    public static final int INFOAVAIL = 2;
    public static final int IMAGEAVAIL = 4;
    public static final int MOREIMAGES = 8;
    public static final int MULTIIMAGE = 1;
    public static final int UNKNOWNCOUNT = -1;
    protected AdaptiveRasterImage jimiImage;
    protected JimiImageFactory factory;
    protected InputStream input;
    protected JimiDecodingController currentController;
    protected JimiImageHandle currentHandle;
    protected boolean error;
    protected volatile boolean busyDecoding;
    protected Object decodingLock = new Object();
    protected Vector cleanupCommands = new Vector();
    protected boolean finishedDecoding;

    public ImageSeriesDecodingController initDecoding(JimiImageFactory jimiImageFactory, InputStream inputStream) {
        block2: {
            this.jimiImage = new AdaptiveRasterImage(jimiImageFactory, this);
            this.jimiImage.setDecoder(this);
            this.factory = jimiImageFactory;
            this.input = inputStream;
            try {
                this.initDecoder(inputStream, this.jimiImage);
            }
            catch (JimiException jimiException) {
                this.error = true;
                if (this.currentHandle == null) break block2;
                this.currentHandle.setJimiImage(new ErrorJimiImage());
            }
        }
        return new JimiDecoderBaseSeriesController(this);
    }

    protected void jimiImageCreated(MutableJimiImage mutableJimiImage) {
        this.currentHandle.setJimiImage(mutableJimiImage);
        mutableJimiImage.setDecodingController(this.currentController);
        this.currentController.waitDecodingRequest();
        if (this.progressListener != null) {
            this.progressListener.setStarted();
        }
    }

    public void run() {
        if (this.finishedDecoding) {
            this.error = true;
            this.currentHandle.setJimiImage(new ErrorJimiImage());
            return;
        }
        Object object = this.decodingLock;
        synchronized (object) {
            if (this.error) {
                Object var2_2 = null;
                return;
            }
            do {
                try {
                    while (this.driveDecoder()) {
                    }
                }
                catch (Exception exception) {
                    this.error = true;
                    this.currentHandle.setJimiImage(new ErrorJimiImage());
                }
                if ((this.getState() & 1) != 0 || !this.currentHandle.isImageSet()) {
                    this.error = true;
                    this.currentHandle.setJimiImage(new ErrorJimiImage());
                    continue;
                }
                if (this.progressListener == null) continue;
                this.progressListener.setFinished();
            } while (!this.error && (this.getState() & 4) == 0);
            if ((this.getState() & 1) != 0 && this.progressListener != null) {
                this.progressListener.setAbort();
            }
            this.finishedDecode();
            return;
        }
    }

    protected AdaptiveRasterImage createAdaptiveRasterImage() {
        while (this.factory instanceof JimiImageFactoryProxy) {
            this.factory = ((JimiImageFactoryProxy)this.factory).getProxiedFactory();
        }
        if (this.factory.getClass().getName().equals("com.sun.jimi.core.OneshotJimiImageFactory")) {
            return new AdaptiveRasterImage(new MemoryJimiImageFactory());
        }
        return new AdaptiveRasterImage(this.factory);
    }

    protected AdaptiveRasterImage createAdaptiveRasterImage(int n, int n2, ColorModel colorModel) {
        if (this.factory instanceof JimiImageFactoryProxy) {
            this.factory = ((JimiImageFactoryProxy)this.factory).getProxiedFactory();
        }
        AdaptiveRasterImage adaptiveRasterImage = this.factory.getClass().getName().equals("com.sun.jimi.core.OneshotJimiImageFactory") ? new AdaptiveRasterImage(new MemoryJimiImageFactory()) : new AdaptiveRasterImage(this.factory);
        adaptiveRasterImage.setSize(n, n2);
        adaptiveRasterImage.setColorModel(colorModel);
        return adaptiveRasterImage;
    }

    protected JimiDecodingController decodeNextImage() {
        if (this.currentController != null) {
            this.currentController.requestDecoding();
        }
        JimiDecoderBase jimiDecoderBase = this;
        synchronized (jimiDecoderBase) {
            this.waitReady();
            this.busyDecoding = true;
        }
        this.currentHandle = new JimiImageHandle();
        this.currentController = new JimiDecodingController(this.currentHandle);
        new Thread(this).start();
        return this.currentController;
    }

    protected synchronized void finishedDecode() {
        this.busyDecoding = false;
        this.notifyAll();
        if (this.finishedDecoding || (this.getState() & 8) == 0) {
            JimiUtil.runCommands(this.cleanupCommands);
        }
    }

    protected synchronized void waitReady() {
        while (this.busyDecoding) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected abstract void initDecoder(InputStream var1, AdaptiveRasterImage var2) throws JimiException;

    protected abstract boolean driveDecoder() throws JimiException;

    protected abstract void freeDecoder() throws JimiException;

    protected abstract int getState();

    protected int getCapabilities() {
        return 0;
    }

    public void skipImage() throws JimiException {
    }

    public int getNumberOfImages() {
        return 1;
    }

    public boolean usesChanneledData() {
        return false;
    }

    public boolean mustWaitForOptions() {
        return false;
    }

    public void setFinished() {
        this.finishedDecoding = true;
    }

    public void addCleanupCommand(Runnable runnable) {
        this.cleanupCommands.addElement(runnable);
    }
}

