/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.raster;

import com.sun.jimi.core.ImageAccessException;
import com.sun.jimi.core.JimiDecodingController;
import com.sun.jimi.core.JimiImageFactory;
import com.sun.jimi.core.MemoryJimiImageFactory;
import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.raster.CroppedRasterImageProducer;
import com.sun.jimi.core.raster.MutableJimiRasterImage;
import com.sun.jimi.core.util.MulticastImageConsumer;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Hashtable;

public abstract class JimiRasterImageSupport
implements MutableJimiRasterImage,
ImageProducer {
    protected boolean error = false;
    protected boolean abort = false;
    protected boolean productionStarted = false;
    protected boolean modified = false;
    protected boolean productionAllowed = false;
    protected boolean finished = false;
    protected boolean newFrameData = false;
    protected ColorModel colorModel;
    protected Hashtable properties = new Hashtable();
    private boolean f1 = false;
    private int f2;
    private int f3;
    private int f4;
    private int f5 = this.f4 = 30;
    private MulticastImageConsumer f6 = new MulticastImageConsumer();
    private MulticastImageConsumer f7 = new MulticastImageConsumer();
    private JimiDecodingController f8;
    private JimiImageFactory f9 = new MemoryJimiImageFactory();
    private FormatOptionSet f10 = new BasicFormatOptionSet(new FormatOption[0]);
    protected ColorModel sourceColorModel = null;
    protected boolean forceRGB = false;
    protected int[] rowBuf;
    protected boolean waitForOptions;

    public int getWidth() {
        return this.f2;
    }

    public int getHeight() {
        return this.f3;
    }

    public void setColorModel(ColorModel colorModel) {
        if (!this.forceRGB) {
            this.colorModel = this.getAppropriateColorModel(colorModel);
            this.forceRGB |= colorModel != this.colorModel;
        }
        this.sourceColorModel = colorModel;
    }

    public void setImageConsumerHints(int n) {
        this.f5 = n |= 0x10;
    }

    public boolean isError() {
        return this.error;
    }

    public synchronized void setError() {
        this.error = true;
        this.f6.imageComplete(1);
        this.f7.imageComplete(1);
        this.notifyAll();
    }

    public void setFactory(JimiImageFactory jimiImageFactory) {
        this.f9 = jimiImageFactory;
    }

    public JimiImageFactory getFactory() {
        return this.f9;
    }

    public void setOptions(FormatOptionSet formatOptionSet) {
        this.f10 = formatOptionSet;
    }

    public FormatOptionSet getOptions() {
        if (this.waitForOptions) {
            this.waitFinished();
        }
        return this.f10;
    }

    public synchronized void setFinished() {
        if (!this.finished) {
            this.finished = true;
            this.newFrameData = false;
            this.f6.imageComplete(3);
            this.f6.removeAll();
            if (!this.f7.isEmpty()) {
                try {
                    JimiRasterImageSupport jimiRasterImageSupport = this;
                    jimiRasterImageSupport.sendToConsumerFully(jimiRasterImageSupport.f7);
                }
                catch (ImageAccessException imageAccessException) {
                    this.setError();
                    return;
                }
            }
            this.f7.getConsumers();
            this.f7.imageComplete(3);
            this.f7.removeAll();
            this.notifyAll();
        }
    }

    public void waitInfoAvailable() {
    }

    public synchronized void waitFinished() {
        this.productionStarted = true;
        if (this.f8 != null) {
            this.f8.requestDecoding();
        }
        while (!this.finished && !this.error) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public synchronized void setDecodingController(JimiDecodingController jimiDecodingController) {
        this.f8 = jimiDecodingController;
        if (this.f1 || this.productionStarted) {
            jimiDecodingController.requestDecoding();
        }
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.f1 = true;
        this.initConsumer(imageConsumer);
        if (!this.productionStarted) {
            this.addDirectConsumer(imageConsumer);
            this.productionStarted = true;
            if (this.f8 != null) {
                this.f8.requestDecoding();
                return;
            }
        } else {
            if (this.finished) {
                this.addWaitingConsumer(imageConsumer);
                return;
            }
            if (this.catchupConsumer(imageConsumer)) {
                this.addDirectConsumer(imageConsumer);
                return;
            }
            this.addWaitingConsumer(imageConsumer);
        }
    }

    protected void addDirectConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.getWidth(), this.getHeight());
        this.f6.addConsumer(imageConsumer);
        imageConsumer.setHints(this.f5);
    }

    protected synchronized void addWaitingConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setDimensions(this.getWidth(), this.getHeight());
        imageConsumer.setHints(this.f4);
        if (this.finished) {
            try {
                this.sendToConsumerFully(imageConsumer);
                imageConsumer.imageComplete(3);
                return;
            }
            catch (ImageAccessException imageAccessException) {
                imageConsumer.imageComplete(1);
                return;
            }
        }
        this.f7.addConsumer(imageConsumer);
    }

    protected synchronized boolean catchupConsumer(ImageConsumer imageConsumer) {
        return false;
    }

    public ImageProducer getImageProducer() {
        return this;
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.f6.contains(imageConsumer) || this.f7.contains(imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.f6.removeConsumer(imageConsumer);
        this.f7.removeConsumer(imageConsumer);
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.removeConsumer(imageConsumer);
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        this.addWaitingConsumer(imageConsumer);
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public ImageProducer getCroppedImageProducer(int n, int n2, int n3, int n4) {
        return new CroppedRasterImageProducer(this, n, n2, n3, n4);
    }

    public synchronized void produceCroppedImage(ImageConsumer imageConsumer, Rectangle rectangle) {
        this.waitFinished();
        this.initConsumer(imageConsumer);
        imageConsumer.setDimensions(rectangle.width, rectangle.height);
        imageConsumer.setHints(this.f4);
        try {
            this.sendRegionToConsumerFully(imageConsumer, rectangle);
            imageConsumer.imageComplete(3);
            return;
        }
        catch (Exception exception) {
            imageConsumer.imageComplete(1);
            return;
        }
    }

    protected MulticastImageConsumer getDirectConsumer() {
        return this.f6;
    }

    protected boolean hasDirectConsumer() {
        return !this.f6.isEmpty();
    }

    protected abstract void sendToConsumerFully(ImageConsumer var1) throws ImageAccessException;

    protected abstract void sendRegionToConsumerFully(ImageConsumer var1, Rectangle var2) throws ImageAccessException;

    protected void initConsumer(ImageConsumer imageConsumer) {
        imageConsumer.setColorModel(this.getColorModel());
        imageConsumer.setProperties(this.properties);
    }

    protected ColorModel getAppropriateColorModel(ColorModel colorModel) {
        return colorModel;
    }

    protected void setModified() {
        if (!this.modified) {
            this.modified = true;
            this.f6.setHints(this.f5);
            this.productionStarted = true;
            if (this.f8 != null) {
                this.f8.requestDecoding();
            }
        }
    }

    public void getChannelRectangle(int n, int n2, int n3, int n4, int n5, byte[] byArray, int n6, int n7) throws ImageAccessException {
        try {
            if (this.rowBuf == null) {
                this.rowBuf = new int[n4];
            }
            int n8 = 0;
            while (n8 < n5) {
                this.getRowRGB(n3 + n8, this.rowBuf, 0);
                int n9 = 0;
                while (n9 < n4) {
                    byArray[n6 + n9 + n8 * n7] = (byte)(this.rowBuf[n9] >>> n);
                    ++n9;
                }
                ++n8;
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            throw new ImageAccessException(runtimeException.toString());
        }
    }

    public synchronized void getChannelRow(int n, int n2, byte[] byArray, int n3) throws ImageAccessException {
        this.getChannelRectangle(n, 0, n2, this.getWidth(), 1, byArray, n3, 0);
    }

    public synchronized void getRectangleRGBChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        int n7 = 0;
        while (n7 < n4) {
            this.getRowRGB(n2 + n7, this.rowBuf, 0);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 16);
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 8);
                byArray[n7 * n6 + n9++ + n5] = (byte)this.rowBuf[n8++];
                ++n10;
            }
            ++n7;
        }
    }

    public synchronized void getRectangleARGBChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        int n7 = 0;
        while (n7 < n4) {
            this.getRowRGB(n2 + n7, this.rowBuf, 0);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 24);
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 16);
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 8);
                byArray[n7 * n6 + n9++ + n5] = (byte)this.rowBuf[n8++];
                ++n10;
            }
            ++n7;
        }
    }

    public synchronized void getRectangleRGBAChannels(int n, int n2, int n3, int n4, byte[] byArray, int n5, int n6) throws ImageAccessException {
        if (this.rowBuf == null) {
            this.rowBuf = new int[n3];
        }
        int n7 = 0;
        while (n7 < n4) {
            this.getRowRGB(n2 + n7, this.rowBuf, 0);
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 < n3) {
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 16);
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8] >>> 8);
                byArray[n7 * n6 + n9++ + n5] = (byte)this.rowBuf[n8];
                byArray[n7 * n6 + n9++ + n5] = (byte)(this.rowBuf[n8++] >>> 24);
                ++n10;
            }
            ++n7;
        }
    }

    public void setWaitForOptions(boolean bl) {
        this.waitForOptions = bl;
    }

    public boolean mustWaitForOptions() {
        return this.waitForOptions;
    }

    public abstract void getRectangleRGB(int var1, int var2, int var3, int var4, int[] var5, int var6, int var7) throws ImageAccessException;

    public abstract void getRowRGB(int var1, int[] var2, int var3) throws ImageAccessException;

    public abstract int getPixelRGB(int var1, int var2) throws ImageAccessException;

    protected JimiRasterImageSupport(int n, int n2, ColorModel colorModel) {
        this.f2 = n;
        this.f3 = n2;
        this.setColorModel(colorModel);
    }
}

