/*
 * Decompiled with CFR 0.152.
 */
package org.greenstone.gatherer.remote;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipOutputStream;
import org.greenstone.gatherer.remote.ZipTools;

public class ZipCollectionArchives {
    public static void main(String[] stringArray) {
        if (stringArray.length != 3) {
            System.err.println("Usage: ZipCollectionArchives <zip-file> <collect-directory-path> <collection-name>");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        try {
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(string));
            String string4 = string3 + File.separator + "archives";
            CollectionArchivesZipFilter collectionArchivesZipFilter = new CollectionArchivesZipFilter();
            ZipTools.addFileToZip(zipOutputStream, string2, string4, collectionArchivesZipFilter);
            zipOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static class CollectionArchivesZipFilter
    extends ZipTools.NullZipFilter {
        private byte[] bytes_remaining = new byte[0];
        private int section_depth = 0;
        private boolean in_section_content = false;

        @Override
        public boolean shouldIncludeFile(String string) {
            return string.equals("archives.inf") || string.endsWith(File.separator + "archives.inf") || string.equals("doc.xml") || string.endsWith(File.separator + "doc.xml");
        }

        @Override
        public boolean shouldIncludeFileContent(String string) {
            return string.equals("doc.xml") || string.endsWith(File.separator + "doc.xml");
        }

        @Override
        public void filterFileContent(String string, BufferedInputStream bufferedInputStream, ZipOutputStream zipOutputStream) {
            this.section_depth = 0;
            this.in_section_content = false;
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)bufferedInputStream, "UTF-8"));
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (this.filterFileLine(string2)) continue;
                    string2 = string2 + "\n";
                    byte[] byArray = string2.getBytes("UTF-8");
                    zipOutputStream.write(byArray, 0, byArray.length);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private boolean filterFileLine(String string) {
            boolean bl = false;
            if (string.indexOf("<Section>") != -1) {
                ++this.section_depth;
            }
            if (string.indexOf("<Content>") != -1) {
                this.in_section_content = true;
            }
            if (this.section_depth > 1 || this.in_section_content) {
                bl = true;
            }
            if (string.indexOf("</Content>") != -1) {
                this.in_section_content = false;
            }
            if (string.indexOf("</Section>") != -1) {
                --this.section_depth;
            }
            return bl;
        }
    }
}

